/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoEditButtons
extends JPanel
implements JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] EDIT_BUTTON_ICONS = new String[]{"move.png", "resize.png", "color.png", "edit.png", "duplicate.png", "back.png", "fore.png", "delete.png", "group.png", "ungroup.png", "empty.png", "empty.png"};
    private static final int[] EDIT_MODES = new int[]{450, 451, 453, 454, 452, 456, 457, 455, 460, 459, 10000, 10001};
    private static final int NOF_BUTTONS = EDIT_MODES.length;
    private static final String[] TOOLTIP_KEYS = new String[]{"Move_an_object", "Resize_an_object", "Color_an_object", "Edit_an_object", "Duplicate_an_object", "Put_an_object_in_the_background", "Put_an_object_in_the_foreground", "Delete_an_object", "Select_objects", "Ungroup_objects", "", ""};
    private final JaxoPanelButton[] editButtons = new JaxoPanelButton[NOF_BUTTONS];

    public JaxoEditButtons() {
        super(new GridBagLayout());
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.editButtons[i] = new JaxoPanelButton();
            this.editButtons[i].setIcon(JaxoUtils.newImageIcon(EDIT_BUTTON_ICONS[i]));
            this.editButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
            this.editButtons[i].setId(JaxoConstants.getModeAsString(EDIT_MODES[i]));
        }
        GridBagConstraints c = (GridBagConstraints)JaxoButtonPanel.BUTTON_CONSTRAINTS.clone();
        for (int y = 0; y < NOF_BUTTONS / 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                c.gridx = x;
                c.gridy = y;
                this.add((Component)this.editButtons[x + 4 * y], c);
            }
        }
        this.editButtons[10].setEnabled(false);
        this.editButtons[11].setEnabled(false);
    }

    public final void addActionListener(ActionListener l) {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.editButtons[i].addActionListener(l);
        }
    }

    private void unsetButtons() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.editButtons[i].setSelected(false);
        }
    }

    private int getIndex(int i) {
        int j = NOF_BUTTONS + 1;
        for (int jj = 0; jj < NOF_BUTTONS; ++jj) {
            if (i != EDIT_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void pressButton(int mode) {
        this.unsetButtons();
        if (JaxoConstants.isEditMode(mode)) {
            int j = this.getIndex(mode);
            this.editButtons[j].setSelected(true);
        }
    }

    public final void setDefault(int mode) {
        this.resetDefault();
        if (JaxoConstants.isEditMode(mode)) {
            int j = this.getIndex(mode);
            this.editButtons[j].setDefault(true);
        }
    }

    private void resetDefault() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.editButtons[i].setDefault(false);
        }
    }

    public final void updateLanguage() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.editButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
        }
    }
}

