/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.border.TitledBorder;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.util.JaxoLanguage;

public class JaxoArrowEditPanel
extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private final transient JCheckBox arrowcb = new JCheckBox(JaxoLanguage.translate("JaxoArrowEditPanel.arrow"));
    private final transient JCheckBox flipcb = new JCheckBox(JaxoLanguage.translate("JaxoArrowEditPanel.flip"));
    private final transient JSpinner spstin;

    public JaxoArrowEditPanel() {
        this(true, false, 0.5f);
    }

    public JaxoArrowEditPanel(boolean arrow, boolean flip, float oldPosition) {
        this.spstin = this.getSpinner(oldPosition, 0.0f, 1.0f, 0.005f, "arrowpos");
        this.init(arrow, flip);
    }

    private void init(boolean arrow, boolean flip) {
        final JLabel arpLabel = this.createI18NLabel("JaxoArrowPositionEditPanel.position");
        this.arrowcb.setName("arrow");
        this.arrowcb.setSelected(arrow);
        this.arrowcb.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                JaxoArrowEditPanel.this.flipcb.setEnabled(JaxoArrowEditPanel.this.arrowcb.isSelected());
                JaxoArrowEditPanel.this.spstin.setEnabled(JaxoArrowEditPanel.this.arrowcb.isSelected());
                arpLabel.setEnabled(JaxoArrowEditPanel.this.arrowcb.isSelected());
            }
        });
        JPanel arpPanel = new JPanel();
        this.spstin.setPreferredSize(new Dimension(55, 20));
        arpPanel.add(arpLabel);
        arpPanel.add(this.spstin);
        this.flipcb.setName("flip");
        this.flipcb.setSelected(flip);
        this.flipcb.setEnabled(arrow);
        JPanel arrEPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        arrEPanel.setLayout(gb);
        sc.anchor = 17;
        sc.gridx = 0;
        sc.gridy = 0;
        arrEPanel.add((Component)this.arrowcb, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        arrEPanel.add((Component)this.flipcb, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.gridwidth = 2;
        arrEPanel.add((Component)arpPanel, sc);
        this.setLineBoxLayout();
        TitledBorder arrETitle = this.createI18NBorder("JaxoArrowEditPanel.title");
        this.setBorder(arrETitle);
        this.add(arrEPanel);
    }

    public void addEditPanelListener(JaxoEditPanelListener listener) {
        if (listener != null) {
            this.arrowcb.addItemListener(listener);
            this.flipcb.addItemListener(listener);
            this.spstin.addChangeListener(listener);
        }
    }
}

