/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.gui.panel.button.JaxoColorButton;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoOptionsPanelListener
implements JaxoEditPanelListener {
    private final PropertyChangeListener theObject;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;

    public JaxoOptionsPanelListener(PropertyChangeListener object) {
        this(object, null);
    }

    public JaxoOptionsPanelListener(PropertyChangeListener object, ChangeListener l) {
        this.theObject = object;
        this.changeListener = l;
        if (l != null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireStateChanged() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    private void setParameter(String name, Object value) {
        this.theObject.propertyChange(new PropertyChangeEvent(this, name, null, value));
    }

    public void stateChanged(ChangeEvent evt) {
        Component component = (Component)evt.getSource();
        String name = component.getName();
        if ("spxin".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("xPosition", (Integer)model.getNumber());
        } else if ("spyin".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("yPosition", (Integer)model.getNumber());
        } else if ("spx".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("x", (Integer)model.getNumber());
        } else if ("spy".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("y", (Integer)model.getNumber());
        } else if ("spxfin".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("x2", (Integer)model.getNumber());
        } else if ("spyfin".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("y2", (Integer)model.getNumber());
        } else if ("spwidth".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("relativeWidth", (Integer)model.getNumber());
        } else if ("spheight".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("relativeHeight", (Integer)model.getNumber());
        } else if ("sprad".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("radius", Float.valueOf(model.getNumber().floatValue()));
        } else if ("stroke".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("strokeWidth", Float.valueOf(model.getNumber().floatValue()));
        } else if ("arrowpos".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("arrowPosition", Float.valueOf(Math.abs(model.getNumber().floatValue())));
        } else if ("rotation".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("rotationAngle", (Integer)model.getNumber());
        } else if ("spx4".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("x4", (Integer)model.getNumber());
        } else if ("spx3".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("x3", (Integer)model.getNumber());
        } else if ("spx2".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("x2", (Integer)model.getNumber());
        } else if ("spy4".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("y4", (Integer)model.getNumber());
        } else if ("spy3".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("y3", (Integer)model.getNumber());
        } else if ("spy2".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("y2", (Integer)model.getNumber());
        } else if ("dlsep".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("DLSeparation", Float.valueOf(model.getNumber().floatValue()));
        } else if ("dash".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("dash", Float.valueOf(model.getNumber().floatValue()));
        } else if ("amp".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("amp", (Integer)model.getNumber());
        } else if ("wiggle".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("frequencyFromWiggles", (Integer)model.getNumber());
        } else if ("scale".equals(name)) {
            SpinnerNumberModel model = (SpinnerNumberModel)((JSpinner)component).getModel();
            this.setParameter("newScale", Float.valueOf(Math.abs(model.getNumber().floatValue())));
            model.setValue(1.0);
        }
        this.fireStateChanged();
    }

    public void actionPerformed(ActionEvent evt) {
        AbstractButton pressedButton = (AbstractButton)evt.getSource();
        JaxoColorButton colorButton = pressedButton instanceof JaxoColorButton ? (JaxoColorButton)pressedButton : null;
        JaxoColorChooser colorChooser = new JaxoColorChooser(pressedButton);
        int colorMode = JaxoPrefs.getIntPref("prefCOLORSPACE");
        if ("Fill_color".equals(pressedButton.getActionCommand())) {
            colorChooser.setMode(colorMode == 2 ? 2 : 0);
            colorChooser.setOptional(false);
            colorChooser.setColor(colorButton.getColor());
            colorChooser.show();
            Color c = colorChooser.getColor();
            colorButton.setColor(c);
            if (JaxoColor.isGrayScale(c)) {
                this.setParameter("color", JaxoColor.BLACK);
            }
            this.setParameter("fillColor", c);
        } else if ("Filled".equals(pressedButton.getActionCommand())) {
            JCheckBox fillcb = (JCheckBox)evt.getSource();
            this.setParameter("filled", fillcb.isSelected());
        } else {
            int mode = 0;
            if ("Line_color".equals(pressedButton.getActionCommand())) {
                mode = 1;
            }
            colorChooser.setMode(colorMode == 2 ? 2 : mode);
            colorChooser.setOptionalColor(colorButton.getColor());
            colorChooser.show();
            Color c = colorChooser.getColor();
            colorButton.setColor(c);
            this.setParameter("color", c);
        }
        this.fireStateChanged();
    }

    public final void itemStateChanged(ItemEvent evt) {
        Component component = (Component)evt.getSource();
        String name = component.getName();
        if ("arrow".equals(name)) {
            JCheckBox arrowcb = (JCheckBox)component;
            this.setParameter("paintArrow", arrowcb.isSelected());
        } else if ("flip".equals(name)) {
            JCheckBox flipcb = (JCheckBox)component;
            this.setParameter("flip", flipcb.isSelected());
        } else if ("middle".equals(name)) {
            this.setParameter("arrowPosition", Float.valueOf(0.5f));
        } else if ("end".equals(name)) {
            this.setParameter("arrowPosition", Float.valueOf(1.0f));
        } else if ("dLine".equals(name)) {
            JCheckBox dlcb = (JCheckBox)component;
            this.setParameter("doubleLine", dlcb.isSelected());
        } else if ("symm".equals(name)) {
            JCheckBox symmcb = (JCheckBox)component;
            this.setParameter("symmetric", symmcb.isSelected());
        } else if ("stretch".equals(name)) {
            JCheckBox stretchcb = (JCheckBox)component;
            this.setParameter("noFreqStretching", stretchcb.isSelected());
        } else if ("psfontname".equals(name)) {
            if (evt.getStateChange() != 1) {
                return;
            }
            JComboBox cb = (JComboBox)component;
            this.setParameter("fontName", (String)cb.getSelectedItem());
        } else if ("psfontsize".equals(name)) {
            if (evt.getStateChange() != 1) {
                return;
            }
            JComboBox cb = (JComboBox)component;
            this.setParameter("fontSize", (Integer)cb.getSelectedItem());
        } else if ("psfontstyle".equals(name)) {
            if (evt.getStateChange() != 1) {
                return;
            }
            JComboBox cb = (JComboBox)component;
            this.setParameter("fontStyle", (Integer)cb.getSelectedItem());
        } else if ("latexalign".equals(name)) {
            if (evt.getStateChange() != 1) {
                return;
            }
            JComboBox cb = (JComboBox)component;
            this.setParameter("allign", cb.getSelectedIndex());
        } else if ("latexfontsize".equals(name)) {
            if (evt.getStateChange() != 1) {
                return;
            }
            JComboBox cb = (JComboBox)component;
            this.setParameter("latexTextSize", cb.getSelectedIndex());
        }
        this.fireStateChanged();
    }

    public void insertUpdate(DocumentEvent evt) {
        try {
            String s = evt.getDocument().getText(0, evt.getDocument().getLength());
            this.setParameter("textString", s);
        }
        catch (BadLocationException e) {
            JaxoLog.debug(e);
        }
        this.fireStateChanged();
    }

    public void removeUpdate(DocumentEvent evt) {
        try {
            String s = evt.getDocument().getText(0, evt.getDocument().getLength());
            this.setParameter("textString", s);
        }
        catch (BadLocationException e) {
            JaxoLog.debug(e);
        }
        this.fireStateChanged();
    }

    public void changedUpdate(DocumentEvent evt) {
    }
}

