/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io;

import java.io.File;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.io.exports.JaxoExportLatex;
import net.sf.jaxodraw.io.imports.JaxoImportAxodraw;
import net.sf.jaxodraw.util.JaxoLog;

public final class JaxoCLIConvert {
    private static String destFileName(String name, String suffix) {
        String result = name.substring(0, name.lastIndexOf(46) + 1) + suffix;
        JaxoLog.info(name + " ---> " + result);
        return result;
    }

    private static void toLatex(String filename) {
        JaxoGraph graph = new JaxoIO(null).open(new File(filename), false);
        if (graph == null) {
            JaxoLog.warn("Could not open: " + filename);
        } else {
            JaxoExportLatex exporter = new JaxoExportLatex();
            exporter.setGraph(graph);
            exporter.export(JaxoCLIConvert.destFileName(filename, "tex"));
        }
    }

    private static void toXML(String filename) {
        JaxoGraph graph = new JaxoImportAxodraw().importGraph(filename);
        if (graph == null) {
            JaxoLog.warn("Could not import: " + filename);
        } else {
            new JaxoIO(null).save(graph, "CLI convert", JaxoCLIConvert.destFileName(filename, "xml"));
        }
    }

    public static void convert(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            if (name.endsWith(".xml")) {
                JaxoCLIConvert.toLatex(name);
                continue;
            }
            if (name.endsWith(".tex")) {
                JaxoCLIConvert.toXML(name);
                continue;
            }
            JaxoLog.warn("Skipped unknown file: " + name);
        }
    }

    private JaxoCLIConvert() {
    }
}

