/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoPreview
implements Cloneable {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoPreview.class);
    public static final String USER_DIR = JaxoInfo.LOG_DIR;
    public static final String TMP_DIR = JaxoInfo.LOG_DIR;
    private static Action disposeWindowAction = new AbstractAction(){
        private static final long serialVersionUID = 7526471155622776147L;

        public void actionPerformed(ActionEvent e) {
            Window w;
            if (e.getSource() instanceof Component && (w = SwingUtilities.getWindowAncestor((Component)e.getSource())) != null) {
                w.dispose();
            }
        }
    };
    private Component parent;
    private String title;

    public JaxoPreview(Component parentc) {
        this.parent = parentc;
        this.title = JaxoInfo.VERSION;
    }

    public final Component getParentComponent() {
        return this.parent;
    }

    public void setParentComponent(Component value) {
        this.parent = value;
    }

    public JaxoPreview copy() {
        try {
            return (JaxoPreview)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public final String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void showComponent(Component c) {
        this.showComponent(c, new JFrame());
    }

    public void showComponent(Component c, JFrame frame) {
        JButton closeButton = new JButton(LANGUAGE.value("/Close"));
        closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
        closeButton.addActionListener(disposeWindowAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        JaxoPreview.installDisposeKeyStroke(buttonPanel);
        JScrollPane s = new JScrollPane(c);
        if (!(c instanceof Scrollable)) {
            s.getVerticalScrollBar().setUnitIncrement(16);
            s.getHorizontalScrollBar().setUnitIncrement(16);
        }
        frame.getContentPane().removeAll();
        frame.getContentPane().add((Component)s, "Center");
        frame.getContentPane().add((Component)buttonPanel, "Last");
        frame.setTitle(JaxoDialogs.translatedWindowTitle(this.title));
        frame.pack();
        this.showDefaultFrame(frame);
    }

    public void showText(String text, String fileName) throws IOException {
        this.showText(text, fileName, new JFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showText(String text, String fileName, JFrame frame) throws IOException {
        String prefEDITOR = JaxoPrefs.getStringPref("prefEDITOR");
        if (prefEDITOR.length() == 0) {
            this.showTextInternally(text, frame);
        } else {
            File f = new File(TMP_DIR, fileName);
            f.deleteOnExit();
            BufferedWriter output = null;
            try {
                output = new BufferedWriter(new FileWriter(f));
                output.write(text);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ex) {
                        JaxoLog.debug(ex);
                    }
                }
            }
            try {
                Runtime.getRuntime().exec(new String[]{prefEDITOR, f.toString()});
            }
            catch (IOException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.textEditor%0", prefEDITOR));
            }
            catch (SecurityException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.securityException%0", prefEDITOR));
            }
        }
    }

    public void showTextInternally(String text) {
        this.showTextInternally(text, new JFrame());
    }

    public void showTextInternally(String text, JFrame frame) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/plain");
        editorPane.setText(text);
        JScrollPane scroller = new JScrollPane(editorPane);
        scroller.setPreferredSize(new Dimension(250, 145));
        scroller.setMinimumSize(new Dimension(10, 10));
        scroller.setBorder(BorderFactory.createEtchedBorder());
        JButton closeButton = new JButton(LANGUAGE.value("/Close"));
        closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
        closeButton.addActionListener(disposeWindowAction);
        JPanel buttonPanel = JaxoDialogs.newLineBoxLayoutPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(new JLabel(LANGUAGE.value("customTextEditor")));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(closeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        frame.getContentPane().removeAll();
        frame.getContentPane().add((Component)scroller, "Center");
        frame.getContentPane().add((Component)buttonPanel, "Last");
        frame.setTitle(JaxoDialogs.translatedWindowTitle(this.title));
        frame.setSize(700, 600);
        this.showDefaultFrame(frame);
    }

    public void browseURL(URL u) {
        String prefBROWSER = JaxoPrefs.getStringPref("prefBROWSER");
        if (prefBROWSER.length() > 0) {
            try {
                Runtime.getRuntime().exec(new String[]{prefBROWSER, u.toString()});
            }
            catch (IOException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.browser%0", prefBROWSER));
            }
            catch (SecurityException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.securityException%0", prefBROWSER));
            }
        } else {
            this.browseURLInternally(u);
        }
    }

    public void showURLInternally(URL u) {
        this.showURLInternally(u, false);
    }

    public void browseURLInternally(URL u) {
        this.showURLInternally(u, true);
    }

    private void showURLInternally(URL u, boolean browsingAllowed) {
        final JFrame frame = new JFrame();
        frame.setTitle(JaxoDialogs.translatedWindowTitle(this.title));
        final JEditorPane editorPane = new JEditorPane();
        editorPane.addPropertyChangeListener(new PropertyChangeListener(){
            private String defaultTitle;
            {
                this.defaultTitle = JaxoPreview.this.title;
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("page")) {
                    String value = (String)editorPane.getDocument().getProperty("title");
                    if (value == null) {
                        value = this.defaultTitle;
                    }
                    frame.setTitle(JaxoDialogs.translatedWindowTitle(value));
                }
            }
        });
        editorPane.setEditable(false);
        if (browsingAllowed) {
            editorPane.addHyperlinkListener(new HTMLLinkListener());
        } else {
            HTMLEditorKit k = (HTMLEditorKit)editorPane.getEditorKitForContentType("text/html");
            k.setLinkCursor(k.getDefaultCursor());
        }
        try {
            editorPane.setPage(u);
        }
        catch (IOException e) {
            String message = LANGUAGE.message("showURL%0.openError", u);
            JaxoLog.debug(e);
            JaxoDialogs.showErrorDialog(this.parent, message);
        }
        JScrollPane scroller = new JScrollPane(editorPane);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setPreferredSize(new Dimension(250, 145));
        scroller.setMinimumSize(new Dimension(10, 10));
        JButton closeButton = new JButton(LANGUAGE.value("/Close"));
        closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
        closeButton.addActionListener(disposeWindowAction);
        JPanel buttonPanel = JaxoDialogs.newLineBoxLayoutPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(new JLabel(LANGUAGE.value("customBrowser")));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(closeButton);
        buttonPanel.add(Box.createHorizontalGlue());
        frame.getContentPane().add((Component)scroller, "Center");
        frame.getContentPane().add((Component)buttonPanel, "Last");
        frame.setSize(1000, 800);
        this.showDefaultFrame(frame);
    }

    public boolean canShowPostscript() {
        return JaxoPrefs.getStringPref("prefPSVIEWER").length() > 0;
    }

    public void showMessageForPostscriptViewer() {
        JOptionPane.showMessageDialog(this.parent, LANGUAGE.value("choosePostscriptViewer"), JaxoDialogs.translatedWindowTitle(this.title), 1);
    }

    public void showPostscript(File f) {
        String prefPSVIEWER = JaxoPrefs.getStringPref("prefPSVIEWER");
        if (prefPSVIEWER.length() == 0) {
            this.showMessageForPostscriptViewer();
        } else {
            try {
                Runtime.getRuntime().exec(new String[]{prefPSVIEWER, f.toString()});
            }
            catch (IOException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.postscriptViewer%0", prefPSVIEWER));
            }
            catch (SecurityException x) {
                JaxoLog.debug(x);
                JaxoDialogs.showErrorDialog(this.parent, LANGUAGE.message("runError.securityException%0", prefPSVIEWER));
            }
        }
    }

    private void showDefaultFrame(JFrame f) {
        f.setIconImage(JaxoUtils.newImage("frame.png"));
        f.setDefaultCloseOperation(2);
        f.setLocationRelativeTo(this.parent);
        f.setVisible(true);
    }

    private static void installDisposeKeyStroke(JComponent c) {
        c.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "dispose");
        c.getActionMap().put("dispose", disposeWindowAction);
    }

    private static class HTMLLinkListener
    implements HyperlinkListener {
        private HTMLLinkListener() {
        }

        public final void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (IOException t) {
                        JaxoLog.debug(t);
                    }
                }
            }
        }
    }
}

