/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.imports;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectFactory;
import net.sf.jaxodraw.util.JaxoColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoAxodraw {
    protected static final String LINE = "\\Line";
    protected static final String COLOR = "color";
    protected static final String REL_WIDTH = "relativeWidth";
    protected static final String REL_HEIGHT = "relativeHeight";
    protected static final String PAINT_ARROW = "paintArrow";
    protected static final String STROKE_WIDTH = "strokeWidth";
    protected static final String FREQ_FROM_WIGGLES = "frequencyFromWiggles";
    protected static final String DOUBLE_LINE = "doubleLine";
    protected static final String DL_SEP = "dLSeparation";
    protected static final String AMP = "amp";
    protected static final String DASH = "dash";
    private static final String CTRI = "\\CTri";
    private static final String FILL_COLOR = "fillColor";
    private static final String FILLED = "filled";
    private static final String ARROW_POS = "arrowPosition";
    private static final String FLIP = "flip";
    private static final String ROT_ANGLE = "rotationAngle";
    private static final String[] KNOWN_COMMANDS = new String[]{"\\ArrowArcn", "\\ArrowArc", "\\ArrowLine", "\\CArc", "\\CBox", "\\CCirc", "\\COval", "\\CTri", "\\DashArrowArcn", "\\DashArrowArc", "\\DashArrowLine", "\\DashCArc", "\\DashLine", "\\GBox", "\\GCirc", "\\GlueArc", "\\Gluon", "\\GOval", "\\GTri", "\\Line", "\\LongArrowArcn", "\\LongArrowArc", "\\LongArrow", "\\PhotonArc", "\\Photon", "\\SetColor", "\\SetWidth", "\\Text", "\\Vertex", "\\ZigZag", "\\EBox", "\\Oval", "\\ETri"};
    private static final int N_OF_COMMANDS = KNOWN_COMMANDS.length;
    private static final String[] REQUIRED_COMMANDS = new String[]{"\\documentclass", "\\begin{document}", "\\begin{picture}"};
    private static final int N_OF_REQUIRED = REQUIRED_COMMANDS.length;
    private final boolean[] isValid = new boolean[3];
    private String string = "";
    private int index;
    private Color color = JaxoColor.BLACK;
    private float stroke = 0.5f;
    private float scaleFactor = 1.0f;
    private String comment = "";
    private float bBoxHeight;
    private final List<String> packageList = new ArrayList<String>(3);

    public JaxoAxodraw() {
        this.packageList.add("axodraw");
        this.packageList.add(COLOR);
    }

    public JaxoObject getJaxoObject(String newString) {
        this.string = newString;
        if (!this.isValidJaxoCommand(this.string)) {
            return null;
        }
        JaxoObject newOb = null;
        if (this.index == -5) {
            newOb = this.newVertexT2Unfilled();
        } else if (this.index == -4) {
            newOb = this.newVertexT2Gray();
        } else if (this.index == -3) {
            newOb = this.newVertexT6();
        } else if (this.index == -2) {
            newOb = this.newVertexT4();
        } else if (this.index == -1) {
            newOb = this.newVertexT2();
        } else if (this.index == this.getIndex("\\ArrowArcn")) {
            newOb = this.newFLoop(true, true, false);
        } else if (this.index == this.getIndex("\\ArrowArc")) {
            newOb = this.newFLoop(false, true, false);
        } else if (this.index == this.getIndex("\\ArrowLine")) {
            newOb = this.newLine(true, false);
        } else if (this.index == this.getIndex("\\CArc")) {
            newOb = this.newFLoop(false, false, false);
        } else if (this.index == this.getIndex("\\CBox")) {
            newOb = this.newCBox();
        } else if (this.index == this.getIndex("\\CCirc")) {
            newOb = this.newCCirc();
        } else if (this.index == this.getIndex("\\COval")) {
            newOb = this.newCOval();
        } else if (this.index == this.getIndex(CTRI)) {
            newOb = this.newCTri();
        } else if (this.index == this.getIndex("\\DashArrowArcn")) {
            newOb = this.newDashArc(true, true);
        } else if (this.index == this.getIndex("\\DashArrowArc")) {
            newOb = this.newDashArc(false, true);
        } else if (this.index == this.getIndex("\\DashArrowLine")) {
            newOb = this.newDashLine(true);
        } else if (this.index == this.getIndex("\\DashCArc")) {
            newOb = this.newDashArc(false, false);
        } else if (this.index == this.getIndex("\\DashLine")) {
            newOb = this.newDashLine(false);
        } else if (this.index == this.getIndex("\\GBox")) {
            newOb = this.newGBox();
        } else if (this.index == this.getIndex("\\GCirc")) {
            newOb = this.newGCirc();
        } else if (this.index == this.getIndex("\\GlueArc")) {
            newOb = this.newGlArc();
        } else if (this.index == this.getIndex("\\Gluon")) {
            newOb = this.newGlLine();
        } else if (this.index == this.getIndex("\\GOval")) {
            newOb = this.newGOval();
        } else if (this.index == this.getIndex("\\GTri")) {
            newOb = this.newGTri();
        } else if (this.index == this.getIndex(LINE)) {
            newOb = this.newLine(false, false);
        } else if (this.index == this.getIndex("\\LongArrowArcn")) {
            newOb = this.newFLoop(true, true, true);
        } else if (this.index == this.getIndex("\\LongArrowArc")) {
            newOb = this.newFLoop(false, true, true);
        } else if (this.index == this.getIndex("\\LongArrow")) {
            newOb = this.newLine(true, true);
        } else if (this.index == this.getIndex("\\PhotonArc")) {
            newOb = this.newPArc();
        } else if (this.index == this.getIndex("\\Photon")) {
            newOb = this.newPLine();
        } else if (this.index == this.getIndex("\\SetColor")) {
            this.color = JaxoColor.getColor(this.getOneCurl(this.string));
        } else if (this.index == this.getIndex("\\SetWidth")) {
            this.stroke = Float.parseFloat(this.getOneCurl(this.string));
        } else if (this.index == this.getIndex("\\Text")) {
            newOb = this.newText();
        } else if (this.index == this.getIndex("\\Vertex")) {
            newOb = this.newVertexT1();
        } else if (this.index == this.getIndex("\\ZigZag")) {
            newOb = this.newZigZagLine();
        } else if (this.index == this.getIndex("\\EBox")) {
            newOb = this.newEBox();
        } else if (this.index == this.getIndex("\\Oval")) {
            newOb = this.newOval();
        } else if (this.index == this.getIndex("\\ETri")) {
            newOb = this.newETri();
        }
        return newOb;
    }

    public final void checkRequired(String newString) {
        this.string = newString;
        if (this.string.startsWith("\\usepackage")) {
            this.addPackage(this.getOneCurl(this.string));
        } else if (this.string.startsWith("%%JaxoComment:")) {
            this.comment = this.string.replaceFirst("%%JaxoComment:", "").trim();
        } else if (this.string.startsWith("%%JaxoScale")) {
            this.scaleFactor = Float.parseFloat(this.getOneCurl(this.string));
        } else {
            int i;
            boolean isRequiredCommand = false;
            for (i = 0; !this.string.startsWith(REQUIRED_COMMANDS[i]) && i < N_OF_REQUIRED - 1; ++i) {
            }
            if (i == N_OF_REQUIRED - 1 && !this.string.startsWith(REQUIRED_COMMANDS[i])) {
                ++i;
            }
            boolean bl = isRequiredCommand = i < N_OF_REQUIRED;
            if (isRequiredCommand) {
                this.isValid[i] = true;
                if (i == 2) {
                    int[] pic = this.getTwoInts(this.string);
                    this.bBoxHeight = (float)pic[1] * this.getScaleFactor();
                }
            }
        }
    }

    public final boolean[] getValid() {
        int length = this.isValid.length;
        boolean[] newArray = new boolean[length];
        System.arraycopy(this.isValid, 0, newArray, 0, length);
        return newArray;
    }

    public final List<String> getPackages() {
        return this.packageList;
    }

    public final void addPackage(String pack) {
        if (!this.packageList.contains(pack)) {
            this.packageList.add(pack);
        }
    }

    public final boolean removePackage(String pack) {
        return this.packageList.remove(pack);
    }

    public final String getComment() {
        return this.comment;
    }

    public final float getScaleFactor() {
        return this.scaleFactor;
    }

    private boolean isValidJaxoCommand(String s) {
        int i;
        for (i = 0; !s.startsWith(KNOWN_COMMANDS[i]) && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (i == N_OF_COMMANDS - 1 && !s.startsWith(KNOWN_COMMANDS[i])) {
            ++i;
        }
        this.index = i;
        if (i == this.getIndex("\\COval")) {
            if (s.indexOf(LINE, 6) > 0) {
                this.index = -1;
            }
        } else if (i == this.getIndex("\\GOval")) {
            if (s.indexOf(LINE, 6) > 0) {
                this.index = -4;
            }
        } else if (i == this.getIndex(LINE)) {
            if (s.indexOf(LINE, 6) > 0 && s.indexOf(37) == -1) {
                this.index = -2;
            }
        } else if (i == this.getIndex(CTRI)) {
            if (s.indexOf(CTRI, 6) > 0) {
                this.index = -3;
            }
        } else if (i == this.getIndex("\\Oval") && s.indexOf(LINE, 6) > 0) {
            this.index = -5;
        }
        return i < N_OF_COMMANDS;
    }

    private int getIndex(String s) {
        int i;
        for (i = 0; KNOWN_COMMANDS[i].compareTo(s) != 0 && i < N_OF_COMMANDS - 1; ++i) {
        }
        if (KNOWN_COMMANDS[i].compareTo(s) == 0) {
            return i;
        }
        return N_OF_COMMANDS;
    }

    protected int[] getLineParams(int[] in, String st) {
        int[] out = new int[]{Math.round((float)in[0] * this.getScaleFactor()), Math.round(this.getBBoxHeight() - (float)in[1] * this.getScaleFactor()), Math.round((float)(in[2] - in[0]) * this.getScaleFactor()), Math.round((float)(in[1] - in[3]) * this.getScaleFactor())};
        if (st.indexOf(37) != -1) {
            double theta = Math.atan2((float)(in[1] - in[3]) * this.getScaleFactor(), (float)(in[2] - in[0]) * this.getScaleFactor());
            float dlSep = this.theDLSeparation(st);
            out[0] = Math.round((float)out[0] - (float)((double)dlSep * Math.sin(theta)));
            out[1] = Math.round((float)out[1] + (float)((double)dlSep * Math.cos(theta)));
        }
        return out;
    }

    private int[] getBoxParams(int[] in) {
        int[] out = new int[4];
        out[2] = Math.round((float)(in[2] - in[0]) * this.getScaleFactor());
        out[3] = Math.round((float)(in[3] - in[1]) * this.getScaleFactor());
        out[0] = Math.round((float)in[0] * this.getScaleFactor());
        out[1] = Math.round(this.getBBoxHeight() - (float)in[3] * this.getScaleFactor());
        return out;
    }

    private int[] getCircParams(int[] in, String rad) {
        int[] out = new int[]{Math.round((float)in[0] * this.getScaleFactor()), Math.round(this.getBBoxHeight() - (float)in[1] * this.getScaleFactor()), Math.round(Float.parseFloat(rad) * this.getScaleFactor())};
        return out;
    }

    private int[] getBlobParams(String[] in) {
        int[] out = new int[5];
        out[2] = Math.round(Float.parseFloat(in[2]) * this.getScaleFactor());
        out[3] = Math.round(Float.parseFloat(in[3]) * this.getScaleFactor());
        out[0] = Math.round(Float.parseFloat(in[0]) * this.getScaleFactor());
        out[1] = Math.round(this.getBBoxHeight() - Float.parseFloat(in[1]) * this.getScaleFactor());
        out[4] = Math.round(Float.parseFloat(in[4]));
        return out;
    }

    private int[] getT1Params(String[] st) {
        int[] out = new int[2];
        float x = Float.parseFloat(st[0]);
        float y = Float.parseFloat(st[1]);
        out[0] = Math.round(x * this.getScaleFactor());
        out[1] = Math.round(this.getBBoxHeight() - y * this.getScaleFactor());
        return out;
    }

    private int[] getT2Params(String[] st) {
        int[] out = new int[4];
        float radius = Float.parseFloat(st[2]) * this.getScaleFactor();
        float angle = (float)Math.toRadians(Float.parseFloat(st[4]));
        float cx = Float.parseFloat(st[0]) * this.getScaleFactor();
        float cy = Float.parseFloat(st[1]) * this.getScaleFactor();
        out[2] = (int)Math.round((double)radius * Math.sin(angle));
        out[3] = (int)Math.round((double)radius * Math.cos(angle));
        if (out[2] > 0 && out[3] >= 0) {
            out[0] = Math.round(cx);
            out[1] = Math.round(this.getBBoxHeight() - cy);
        } else if (out[2] >= 0 && out[3] < 0) {
            out[0] = Math.round(cx + (float)out[3]);
            out[1] = Math.round(this.getBBoxHeight() - cy);
        } else if (out[2] <= 0 && out[3] > 0) {
            out[0] = Math.round(cx);
            out[1] = Math.round(this.getBBoxHeight() + (float)out[2] - cy);
        } else if (out[2] < 0 && out[3] <= 0) {
            out[0] = Math.round(cx + (float)out[3]);
            out[1] = Math.round(this.getBBoxHeight() + (float)out[2] - cy);
        }
        return out;
    }

    private int[] getT3Params(int[] in) {
        int[] out = new int[]{Math.round((float)(in[2] + in[0]) / 2.0f), Math.round(this.getBBoxHeight() - (float)(in[3] + in[1]) / 2.0f), (int)Math.round((double)Math.abs(in[2] - in[0]) * Math.sin(Math.toRadians(45.0)) / 2.0), (int)Math.round((double)Math.abs(in[2] - in[0]) * Math.cos(Math.toRadians(45.0)) / 2.0)};
        return out;
    }

    protected int[] getT4Params(int[] firstl, int[] secondl) {
        int[] out = new int[4];
        out[2] = Math.round((float)(secondl[2] - secondl[0]) * this.getScaleFactor() / 2.0f);
        out[3] = Math.round((float)(secondl[1] - secondl[3]) * this.getScaleFactor() / 2.0f);
        if (secondl[2] - secondl[0] > 0 && firstl[2] - firstl[0] > 0) {
            out[0] = Math.round((float)secondl[0] * this.getScaleFactor() + (float)out[2]);
            out[1] = Math.round(this.getBBoxHeight() - (float)secondl[1] * this.getScaleFactor() + (float)out[3]);
        } else if (secondl[2] - secondl[0] > 0 && firstl[2] - firstl[0] < 0) {
            out[0] = Math.round((float)secondl[0] * this.getScaleFactor() + (float)out[2]);
            out[1] = Math.round(this.getBBoxHeight() - (float)secondl[1] * this.getScaleFactor() + (float)(2 * out[3]));
        } else if (secondl[2] - secondl[0] < 0 && firstl[2] - firstl[0] < 0) {
            out[0] = Math.round((float)secondl[0] * this.getScaleFactor() + (float)(2 * out[2]));
            out[1] = Math.round(this.getBBoxHeight() - (float)secondl[1] * this.getScaleFactor() + (float)(2 * out[3]));
        } else if (secondl[2] - secondl[0] < 0 && firstl[2] - firstl[0] > 0) {
            out[0] = Math.round((float)secondl[0] * this.getScaleFactor() + (float)(2 * out[2]));
            out[1] = Math.round(this.getBBoxHeight() - (float)secondl[1] * this.getScaleFactor() + (float)out[3]);
        }
        return out;
    }

    protected Point2D[] getArcPoints(String[] st, boolean clock) {
        double cx = Double.parseDouble(st[0]) * (double)this.getScaleFactor();
        double cy = (double)this.getBBoxHeight() - Double.parseDouble(st[1]) * (double)this.getScaleFactor();
        double radius = Double.parseDouble(st[2]) * (double)this.getScaleFactor();
        double phi1 = Double.parseDouble(st[3]);
        double phi2 = Double.parseDouble(st[4]);
        Point2D.Double cp = new Point2D.Double(cx, cy);
        Point2D.Double fpt = new Point2D.Double(cx + radius * Math.cos(Math.toRadians(-phi1)), cy + radius * Math.sin(Math.toRadians(-phi1)));
        Point2D.Double tpt = new Point2D.Double(cx + radius * Math.cos(Math.toRadians(-phi2)), cy + radius * Math.sin(Math.toRadians(-phi2)));
        Point2D.Double spt = this.getSecondArcPoint(cp, fpt, tpt, clock);
        return new Point2D[]{fpt, spt, tpt};
    }

    private Point2D.Double getSecondArcPoint(Point2D.Double cp, Point2D.Double p1, Point2D.Double p3, boolean clock) {
        boolean cl;
        double px2;
        double px1;
        double py2;
        double py1;
        double rsq = (p1.x - cp.x) * (p1.x - cp.x) + (p1.y - cp.y) * (p1.y - cp.y);
        double x13 = (p3.x + p1.x) / 2.0;
        double y13 = (p3.y + p1.y) / 2.0;
        if (Math.round(p1.x) == Math.round(p3.x)) {
            py1 = y13;
            py2 = y13;
            px1 = cp.x - Math.sqrt(rsq - (y13 - cp.y) * (y13 - cp.y));
            px2 = cp.x + Math.sqrt(rsq - (y13 - cp.y) * (y13 - cp.y));
        } else if (Math.round(p1.y) == Math.round(p3.y)) {
            px1 = x13;
            px2 = x13;
            py1 = cp.y - Math.sqrt(rsq - (x13 - cp.x) * (x13 - cp.x));
            py2 = cp.y + Math.sqrt(rsq - (x13 - cp.x) * (x13 - cp.x));
        } else {
            double ma = (p3.y - p1.y) / (p3.x - p1.x);
            double a = 1.0 + 1.0 / ma / ma;
            double b = 2.0 * cp.y / ma - 2.0 * cp.x - 2.0 * y13 / ma - 2.0 * x13 / ma / ma;
            double c = cp.x * cp.x + x13 * x13 / ma / ma + y13 * y13 + 2.0 * y13 * x13 / ma - 2.0 * cp.y * x13 / ma - 2.0 * cp.y * y13 + cp.y * cp.y - rsq;
            double rad = Math.sqrt(b * b - 4.0 * a * c);
            px1 = (-b + rad) / 2.0 / a;
            px2 = (-b - rad) / 2.0 / a;
            py1 = -(px1 - x13) / ma + y13;
            py2 = -(px2 - x13) / ma + y13;
        }
        double px = px1;
        double py = py1;
        double cross = (p1.x - cp.x) * (py1 - cp.y) - (p1.y - cp.y) * (px1 - cp.x);
        boolean bl = cl = cross < 0.0;
        if (cl == clock) {
            px = px2;
            py = py2;
        }
        return new Point2D.Double(px, py);
    }

    protected int[] getLoopPars(String[] st, String st1, boolean cntrclk) {
        int[] out = new int[4];
        float x = Float.parseFloat(st[0]);
        float y = Float.parseFloat(st[1]);
        float r = Float.parseFloat(st[2]);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        int phi2 = Math.round(Float.parseFloat(st[4]));
        if (st1.indexOf(37) != -1) {
            r -= this.theDLSeparation(st1);
        }
        double alpha = 0.0;
        alpha = cntrclk ? (phi1 > phi2 ? Math.toRadians(-phi1 + 180) : Math.toRadians(-phi2 + 180)) : (phi1 > phi2 ? Math.toRadians(-phi2 + 180) : Math.toRadians(-phi1 + 180));
        out[0] = (int)(x * this.getScaleFactor());
        out[1] = (int)(this.getBBoxHeight() - y * this.getScaleFactor());
        out[2] = (int)Math.round((double)(r * this.getScaleFactor()) * Math.cos(alpha));
        out[3] = (int)Math.round((double)(r * this.getScaleFactor()) * Math.sin(alpha));
        return out;
    }

    private String[] getOvalBrackets(String str) {
        String[] st = new String[5];
        int start = str.indexOf(40);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        int offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        st[2] = str.substring(start + 1, comma);
        st[3] = str.substring(comma + 1, stop);
        offset = stop + 1;
        start = str.indexOf(40, offset);
        stop = str.indexOf(41, offset);
        st[4] = str.substring(start + 1, stop);
        return st;
    }

    protected int[] getFourInts(String str) {
        return this.getFourInts(str, 0);
    }

    protected int[] getTwoInts(String str) {
        int[] ints = new int[2];
        int start = str.indexOf(40);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    protected int[] getFourInts(String str, int fromIndex) {
        int[] ints = new int[4];
        int start = str.indexOf(40, fromIndex);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    protected int[] getSixInts(String str) {
        int[] ints = new int[6];
        int start = str.indexOf(40);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        ints[0] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[1] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        int offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[2] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[3] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        offset = stop + 1;
        start = str.indexOf(40, offset);
        comma = str.indexOf(44, offset);
        stop = str.indexOf(41, offset);
        ints[4] = Math.round(Float.parseFloat(str.substring(start + 1, comma)));
        ints[5] = Math.round(Float.parseFloat(str.substring(comma + 1, stop)));
        return ints;
    }

    private int[] getTriangleParameters(int[] coords) {
        int[] out = new int[]{0, 0, 0, 0, 0, 0};
        out[0] = Math.round((float)coords[0] * this.getScaleFactor());
        out[1] = Math.round(this.getBBoxHeight() - (float)coords[1] * this.getScaleFactor());
        out[2] = Math.round((float)coords[2] * this.getScaleFactor());
        out[3] = Math.round(this.getBBoxHeight() - (float)coords[3] * this.getScaleFactor());
        out[4] = Math.round((float)coords[4] * this.getScaleFactor());
        out[5] = Math.round(this.getBBoxHeight() - (float)coords[5] * this.getScaleFactor());
        return out;
    }

    private int getTeXAllign(String str) {
        ArrayList<String> possible = new ArrayList<String>(9);
        possible.add("lt");
        possible.add("l");
        possible.add("lb");
        possible.add("t");
        possible.add("");
        possible.add("b");
        possible.add("rt");
        possible.add("r");
        possible.add("rb");
        return possible.indexOf(str);
    }

    private Color getTeXColor(String str) {
        int offset = str.indexOf("{\\");
        int start = str.indexOf(92, offset);
        int stop = str.indexOf(36);
        if (stop > start && start != -1) {
            return JaxoColor.getColor(str.substring(start + 1, stop - 1));
        }
        return JaxoColor.BLACK;
    }

    private int getTeXSize(String str) {
        int start = str.indexOf(92);
        int stop = str.indexOf(123, start);
        if (stop > start && start != -1) {
            String st = str.substring(start + 1, stop);
            ArrayList<String> possible = new ArrayList<String>(10);
            possible.add("tiny");
            possible.add("scriptsize");
            possible.add("footnotesize");
            possible.add("small");
            possible.add("normalsize");
            possible.add("large");
            possible.add("Large");
            possible.add("LARGE");
            possible.add("huge");
            possible.add("Huge");
            if (possible.indexOf(st) == -1) {
                return 4;
            }
            return possible.indexOf(st);
        }
        return 4;
    }

    private String getTeXText(String str) {
        int start = str.indexOf(36);
        int stop = str.lastIndexOf(36);
        return str.substring(start + 1, stop);
    }

    private int getTexRotangle(String str) {
        int start = str.indexOf(123);
        int stop = str.indexOf(125, start + 1);
        return Math.round(Float.parseFloat(str.substring(start + 1, stop)));
    }

    private String getRotatedTexText(String str, String fullstr) {
        int start = str.indexOf(123);
        int stop = str.indexOf(125, start + 1);
        int offset = fullstr.indexOf(36);
        int stop1 = fullstr.indexOf(36, offset + 1);
        return fullstr.substring(offset + stop + 3, stop1 - 1);
    }

    protected String[] getOneBracket(String str) {
        String[] st = new String[2];
        int start = str.indexOf(40);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        return st;
    }

    protected String getOneBrace(String str) {
        int start = str.indexOf(91);
        int stop = str.indexOf(93, start);
        return str.substring(start + 1, stop);
    }

    protected String getOneCurl(String str) {
        int start = str.indexOf(123);
        int stop = str.indexOf(125, start);
        return str.substring(start + 1, stop);
    }

    protected String[] getTwoCurls(String str) {
        String[] st = new String[2];
        int start = str.indexOf(123);
        int stop = str.indexOf(125, start);
        st[0] = str.substring(start + 1, stop);
        int offset = stop + 1;
        start = str.indexOf(123, offset);
        stop = str.indexOf(125, offset);
        st[1] = str.substring(start + 1, stop);
        return st;
    }

    protected String[] getThreeCurls(String str) {
        String[] st = new String[3];
        int start = str.indexOf(123);
        int stop = str.indexOf(125);
        st[0] = str.substring(start + 1, stop);
        int offset = stop + 1;
        start = str.indexOf(123, offset);
        stop = str.indexOf(125, offset);
        st[1] = str.substring(start + 1, stop);
        offset = stop + 1;
        start = str.indexOf(123, offset);
        stop = str.indexOf(125, offset);
        st[2] = str.substring(start + 1, stop);
        return st;
    }

    protected String[] getArcBrackets(String str) {
        String[] st = new String[5];
        int start = str.indexOf(40);
        int comma = str.indexOf(44, start);
        int stop = str.indexOf(41, start);
        st[0] = str.substring(start + 1, comma);
        st[1] = str.substring(comma + 1, stop);
        int offset = stop + 1;
        start = str.indexOf(40, offset);
        int comma1 = str.indexOf(44, offset);
        int comma2 = str.indexOf(44, comma1 + 1);
        stop = str.indexOf(41, offset);
        st[2] = str.substring(start + 1, comma1);
        st[3] = str.substring(comma1 + 1, comma2);
        st[4] = str.substring(comma2 + 1, stop);
        return st;
    }

    private float theDLSeparation(String str) {
        int offset = str.indexOf(37) + 1;
        int start = str.indexOf(40, offset);
        int stop = str.indexOf(41, offset);
        return Float.parseFloat(str.substring(start + 1, stop));
    }

    private void setDoubleLine(JaxoObject newOb) {
        if (this.string.indexOf(37) == -1) {
            newOb.setParameter(DOUBLE_LINE, false);
            newOb.setParameter(DL_SEP, 2.0f);
        } else {
            newOb.setParameter(DOUBLE_LINE, true);
            newOb.setParameter(DL_SEP, Math.abs(this.theDLSeparation(this.string)));
        }
    }

    private JaxoObject newVertexT4() {
        int[] firstl = this.getFourInts(this.string);
        int[] secondl = this.getFourInts(this.string, this.string.lastIndexOf(LINE));
        int[] pars = this.getT4Params(firstl, secondl);
        JaxoObject newOb = JaxoObjectFactory.newObject(339);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        return newOb;
    }

    private JaxoObject newVertexT2() {
        int[] pars = this.getT2Params(this.getOvalBrackets(this.string));
        String[] colors = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(337);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(FILL_COLOR, JaxoColor.getColor(colors[1]));
        return newOb;
    }

    private JaxoObject newVertexT2Unfilled() {
        int[] pars = this.getT2Params(this.getOvalBrackets(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(337);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, JaxoColor.getColor("Black"));
        newOb.setParameter(FILL_COLOR, JaxoColor.WHITE);
        newOb.setParameter(FILLED, false);
        return newOb;
    }

    private JaxoObject newVertexT2Gray() {
        int[] pars = this.getT2Params(this.getOvalBrackets(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(337);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, JaxoColor.getColor("Black"));
        newOb.setParameter(FILL_COLOR, JaxoColor.getGrayScaleColor(Float.parseFloat(this.getOneCurl(this.string))));
        return newOb;
    }

    private JaxoObject newFLoop(boolean arcn, boolean arrow, boolean atend) {
        int phi2;
        JaxoObject newOb = null;
        String[] st = this.getArcBrackets(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, arcn);
            newOb = JaxoObjectFactory.newObject(4);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, pars[2]);
            newOb.setParameter(REL_HEIGHT, pars[3]);
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(PAINT_ARROW, arrow);
            if (arrow) {
                newOb.setParameter(ARROW_POS, 0.5f);
            }
            newOb.setParameter(FLIP, arcn);
            this.setDoubleLine(newOb);
        } else {
            Point2D[] pts = this.getArcPoints(st, arcn);
            Point2D p0 = pts[0];
            Point2D p1 = pts[1];
            Point2D p2 = pts[2];
            newOb = JaxoObjectFactory.newObject(5);
            newOb.setParameter("x", (int)Math.round(p0.getX()));
            newOb.setParameter("y", (int)Math.round(p0.getY()));
            newOb.setParameter("x2", (int)Math.round(p1.getX()));
            newOb.setParameter("y2", (int)Math.round(p1.getY()));
            newOb.setParameter("x3", (int)Math.round(p2.getX()));
            newOb.setParameter("y3", (int)Math.round(p2.getY()));
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(PAINT_ARROW, arrow);
            newOb.setParameter(FLIP, false);
            if (atend) {
                newOb.setParameter(ARROW_POS, 1.0f);
            } else {
                newOb.setParameter(ARROW_POS, 0.5f);
            }
            this.setDoubleLine(newOb);
        }
        return newOb;
    }

    private JaxoObject newLine(boolean arrow, boolean atend) {
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(3);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(PAINT_ARROW, arrow);
        if (atend) {
            newOb.setParameter(ARROW_POS, 1.0f);
        } else {
            newOb.setParameter(ARROW_POS, 0.5f);
        }
        newOb.setParameter(FLIP, false);
        this.setDoubleLine(newOb);
        return newOb;
    }

    private JaxoObject newCBox() {
        JaxoObject newOb = null;
        if (this.string.indexOf(37) == -1) {
            int[] pars = this.getBoxParams(this.getFourInts(this.string));
            String[] colors = this.getTwoCurls(this.string);
            newOb = JaxoObjectFactory.newObject(230);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, pars[2]);
            newOb.setParameter(REL_HEIGHT, pars[3]);
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
            newOb.setParameter(FILL_COLOR, JaxoColor.getColor(colors[1]));
        } else {
            int[] pars = this.getT3Params(this.getFourInts(this.string));
            String[] colors = this.getTwoCurls(this.string);
            newOb = JaxoObjectFactory.newObject(338);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, pars[2]);
            newOb.setParameter(REL_HEIGHT, pars[3]);
            newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
        }
        return newOb;
    }

    private JaxoObject newCCirc() {
        String[] radcol = this.getThreeCurls(this.string);
        int[] pars = this.getCircParams(this.getTwoInts(this.string), radcol[0]);
        JaxoObject newOb = JaxoObjectFactory.newObject(231);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(ROT_ANGLE, 0);
        newOb.setParameter(COLOR, JaxoColor.getColor(radcol[1]));
        newOb.setParameter(FILL_COLOR, JaxoColor.getColor(radcol[2]));
        return newOb;
    }

    private JaxoObject newCOval() {
        int[] pars = this.getBlobParams(this.getOvalBrackets(this.string));
        String[] colors = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(231);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(ROT_ANGLE, -pars[4]);
        newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
        newOb.setParameter(FILL_COLOR, JaxoColor.getColor(colors[1]));
        return newOb;
    }

    private JaxoObject newCTri() {
        String[] colors = this.getTwoCurls(this.string);
        int[] pars = this.getTriangleParameters(this.getSixInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(340);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("x2", pars[2]);
        newOb.setParameter("y2", pars[3]);
        newOb.setParameter("x3", pars[4]);
        newOb.setParameter("y3", pars[5]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
        newOb.setParameter(FILL_COLOR, JaxoColor.getColor(colors[1]));
        return newOb;
    }

    private JaxoObject newDashArc(boolean arcn, boolean arrow) {
        int phi2;
        int phi1;
        String[] st = this.getArcBrackets(this.string);
        float dash = Float.parseFloat(this.getOneCurl(this.string)) * this.getScaleFactor();
        JaxoObject newOb = null;
        if (!arrow && this.string.indexOf(37) != -1) {
            float r = Float.parseFloat(st[2]);
            dash = Math.round(dash * r / (r + this.theDLSeparation(this.string)));
        }
        if (Math.abs((phi1 = Math.round(Float.parseFloat(st[3]))) - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, arcn);
            newOb = dash > 5.0f ? JaxoObjectFactory.newObject(7) : JaxoObjectFactory.newObject(10);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, pars[2]);
            newOb.setParameter(REL_HEIGHT, pars[3]);
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(PAINT_ARROW, arrow);
            if (arrow) {
                newOb.setParameter(ARROW_POS, 0.5f);
            }
            newOb.setParameter(FLIP, arcn);
            newOb.setParameter(DASH, dash);
            this.setDoubleLine(newOb);
        } else {
            Point2D[] pts = this.getArcPoints(st, arcn);
            Point2D p0 = pts[0];
            Point2D p1 = pts[1];
            Point2D p2 = pts[2];
            newOb = dash > 5.0f ? JaxoObjectFactory.newObject(8) : JaxoObjectFactory.newObject(11);
            newOb.setParameter("x", (int)Math.round(p0.getX()));
            newOb.setParameter("y", (int)Math.round(p0.getY()));
            newOb.setParameter("x2", (int)Math.round(p1.getX()));
            newOb.setParameter("y2", (int)Math.round(p1.getY()));
            newOb.setParameter("x3", (int)Math.round(p2.getX()));
            newOb.setParameter("y3", (int)Math.round(p2.getY()));
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(PAINT_ARROW, arrow);
            if (arrow) {
                newOb.setParameter(ARROW_POS, 0.5f);
            }
            newOb.setParameter(FLIP, arcn);
            newOb.setParameter(DASH, dash);
            this.setDoubleLine(newOb);
        }
        return newOb;
    }

    private JaxoObject newDashLine(boolean arrow) {
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        float dash = Float.parseFloat(this.getOneCurl(this.string)) * this.getScaleFactor();
        JaxoObject newOb = null;
        newOb = dash > 5.0f ? JaxoObjectFactory.newObject(6) : JaxoObjectFactory.newObject(9);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(PAINT_ARROW, arrow);
        if (arrow) {
            newOb.setParameter(ARROW_POS, 0.5f);
        }
        newOb.setParameter(FLIP, false);
        newOb.setParameter(DASH, dash);
        this.setDoubleLine(newOb);
        return newOb;
    }

    private JaxoObject newGBox() {
        int[] pars = this.getBoxParams(this.getFourInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(230);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.getGrayScaleColor(Float.parseFloat(this.getOneCurl(this.string))));
        return newOb;
    }

    private JaxoObject newEBox() {
        int[] pars = this.getBoxParams(this.getFourInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(230);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.WHITE);
        newOb.setParameter(FILLED, false);
        return newOb;
    }

    private JaxoObject newGCirc() {
        String[] radcol = this.getTwoCurls(this.string);
        int[] pars = this.getCircParams(this.getTwoInts(this.string), radcol[0]);
        JaxoObject newOb = JaxoObjectFactory.newObject(231);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(ROT_ANGLE, 0);
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.getGrayScaleColor(Float.parseFloat(radcol[1])));
        return newOb;
    }

    private JaxoObject newGlArc() {
        int phi2;
        JaxoObject newOb = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, false);
            newOb = JaxoObjectFactory.newObject(16);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, -pars[2]);
            newOb.setParameter(REL_HEIGHT, -pars[3]);
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
            float nOfWiggles = Float.parseFloat(ampwig[1]) * this.getScaleFactor();
            newOb.setParameter(FREQ_FROM_WIGGLES, Math.round(nOfWiggles));
            this.setDoubleLine(newOb);
        } else {
            Point2D[] pts = this.getArcPoints(st, false);
            Point2D p0 = pts[0];
            Point2D p1 = pts[1];
            Point2D p2 = pts[2];
            newOb = JaxoObjectFactory.newObject(17);
            newOb.setParameter("x", (int)Math.round(p0.getX()));
            newOb.setParameter("y", (int)Math.round(p0.getY()));
            newOb.setParameter("x2", (int)Math.round(p1.getX()));
            newOb.setParameter("y2", (int)Math.round(p1.getY()));
            newOb.setParameter("x3", (int)Math.round(p2.getX()));
            newOb.setParameter("y3", (int)Math.round(p2.getY()));
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(AMP, -Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
            float nOfWiggles = Float.parseFloat(ampwig[1]) * this.getScaleFactor();
            newOb.setParameter(FREQ_FROM_WIGGLES, Math.round(nOfWiggles));
            this.setDoubleLine(newOb);
        }
        return newOb;
    }

    private JaxoObject newGlLine() {
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(15);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]) * this.getScaleFactor();
        newOb.setParameter(FREQ_FROM_WIGGLES, Math.round(nOfWiggles));
        this.setDoubleLine(newOb);
        return newOb;
    }

    private JaxoObject newOval() {
        int[] pars = this.getBlobParams(this.getOvalBrackets(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(231);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(ROT_ANGLE, -pars[4]);
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.WHITE);
        newOb.setParameter(FILLED, false);
        return newOb;
    }

    private JaxoObject newGOval() {
        int[] pars = this.getBlobParams(this.getOvalBrackets(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(231);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[3]);
        newOb.setParameter(REL_HEIGHT, pars[2]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(ROT_ANGLE, -pars[4]);
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.getGrayScaleColor(Float.parseFloat(this.getOneCurl(this.string))));
        return newOb;
    }

    private JaxoObject newGTri() {
        int[] pars = this.getTriangleParameters(this.getSixInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(340);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("x2", pars[2]);
        newOb.setParameter("y2", pars[3]);
        newOb.setParameter("x3", pars[4]);
        newOb.setParameter("y3", pars[5]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.getGrayScaleColor(Float.parseFloat(this.getOneCurl(this.string))));
        return newOb;
    }

    private JaxoObject newETri() {
        int[] pars = this.getTriangleParameters(this.getSixInts(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(340);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter("x2", pars[2]);
        newOb.setParameter("y2", pars[3]);
        newOb.setParameter("x3", pars[4]);
        newOb.setParameter("y3", pars[5]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(FILL_COLOR, JaxoColor.WHITE);
        newOb.setParameter(FILLED, false);
        return newOb;
    }

    private JaxoObject newPArc() {
        int phi2;
        JaxoObject newOb = null;
        String[] st = this.getArcBrackets(this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        int phi1 = Math.round(Float.parseFloat(st[3]));
        if (Math.abs(phi1 - (phi2 = Math.round(Float.parseFloat(st[4])))) >= 360) {
            int[] pars = this.getLoopPars(st, this.string, false);
            newOb = JaxoObjectFactory.newObject(13);
            newOb.setParameter("x", pars[0]);
            newOb.setParameter("y", pars[1]);
            newOb.setParameter(REL_WIDTH, -pars[2]);
            newOb.setParameter(REL_HEIGHT, -pars[3]);
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
            float nOfWiggles = Float.parseFloat(ampwig[1]);
            newOb.setParameter(FREQ_FROM_WIGGLES, Math.round(nOfWiggles));
            this.setDoubleLine(newOb);
        } else {
            Point2D[] pts = this.getArcPoints(st, false);
            Point2D p0 = pts[0];
            Point2D p1 = pts[1];
            Point2D p2 = pts[2];
            newOb = JaxoObjectFactory.newObject(14);
            newOb.setParameter("x", (int)Math.round(p0.getX()));
            newOb.setParameter("y", (int)Math.round(p0.getY()));
            newOb.setParameter("x2", (int)Math.round(p1.getX()));
            newOb.setParameter("y2", (int)Math.round(p1.getY()));
            newOb.setParameter("x3", (int)Math.round(p2.getX()));
            newOb.setParameter("y3", (int)Math.round(p2.getY()));
            newOb.setParameter(STROKE_WIDTH, this.getStroke());
            newOb.setParameter(COLOR, this.getColor());
            newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
            float nOfWiggles = Float.parseFloat(ampwig[1]);
            boolean symmetric = (double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001;
            newOb.setParameter("symmetric", symmetric);
            newOb.setParameter(FREQ_FROM_WIGGLES, (int)Math.floor(nOfWiggles));
            this.setDoubleLine(newOb);
        }
        return newOb;
    }

    protected JaxoObject newPLine() {
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(12);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]);
        boolean symmetric = (double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001;
        newOb.setParameter("symmetric", symmetric);
        newOb.setParameter(FREQ_FROM_WIGGLES, (int)Math.floor(nOfWiggles));
        this.setDoubleLine(newOb);
        return newOb;
    }

    private JaxoObject newText() {
        int[] pos = this.getT1Params(this.getOneBracket(this.string));
        int allign = this.getTeXAllign(this.getOneBrace(this.string));
        int size = this.getTeXSize(this.getOneCurl(this.string));
        int rotangle = 0;
        String text = this.getTeXText(this.string);
        if (text.indexOf("\\rput", 0) == 0) {
            rotangle = -this.getTexRotangle(text);
            text = this.getRotatedTexText(text, this.string);
        }
        Color txtcolor = this.getTeXColor(this.getOneCurl(this.string));
        JaxoObject newOb = JaxoObjectFactory.newObject(235);
        newOb.setParameter("x", pos[0]);
        newOb.setParameter("y", pos[1]);
        newOb.setParameter(COLOR, txtcolor);
        newOb.setParameter("textString", text);
        newOb.setParameter("allign", allign);
        newOb.setParameter("latexTextSize", size);
        newOb.setParameter(ROT_ANGLE, rotangle);
        return newOb;
    }

    private JaxoObject newVertexT1() {
        int[] center = this.getT1Params(this.getOneBracket(this.string));
        String radius = this.getOneCurl(this.string);
        int relwh = (int)Math.round((double)(Float.parseFloat(radius) * this.getScaleFactor()) / Math.sqrt(2.0));
        JaxoObject newOb = JaxoObjectFactory.newObject(336);
        newOb.setParameter("x", center[0]);
        newOb.setParameter("y", center[1]);
        newOb.setParameter(REL_WIDTH, relwh);
        newOb.setParameter(REL_HEIGHT, relwh);
        newOb.setParameter(COLOR, this.getColor());
        return newOb;
    }

    private JaxoObject newVertexT6() {
        int[] pars = this.getTriangleParameters(this.getSixInts(this.string));
        String[] colors = this.getTwoCurls(this.string);
        double length = (double)(pars[4] - pars[0]) / 2.0;
        JaxoObject newOb = JaxoObjectFactory.newObject(341);
        newOb.setParameter("x", (int)Math.round((double)pars[0] + length));
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, (int)Math.round(length * 0.5));
        newOb.setParameter(REL_HEIGHT, (int)Math.round(length * 0.5));
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, JaxoColor.getColor(colors[0]));
        return newOb;
    }

    private JaxoObject newZigZagLine() {
        int[] pars = this.getLineParams(this.getFourInts(this.string), this.string);
        String[] ampwig = this.getTwoCurls(this.string);
        JaxoObject newOb = JaxoObjectFactory.newObject(233);
        newOb.setParameter("x", pars[0]);
        newOb.setParameter("y", pars[1]);
        newOb.setParameter(REL_WIDTH, pars[2]);
        newOb.setParameter(REL_HEIGHT, pars[3]);
        newOb.setParameter(STROKE_WIDTH, this.getStroke());
        newOb.setParameter(COLOR, this.getColor());
        newOb.setParameter(AMP, Math.round(Float.parseFloat(ampwig[0]) * 2.0f * this.getScaleFactor()));
        float nOfWiggles = Float.parseFloat(ampwig[1]);
        boolean symmetric = (double)((float)Math.round(nOfWiggles) - nOfWiggles) > 0.001;
        newOb.setParameter("symmetric", symmetric);
        newOb.setParameter(FREQ_FROM_WIGGLES, (int)Math.floor(nOfWiggles));
        this.setDoubleLine(newOb);
        return newOb;
    }

    protected Color getColor() {
        return this.color;
    }

    protected float getStroke() {
        return this.stroke;
    }

    protected float getBBoxHeight() {
        return this.bBoxHeight;
    }
}

