/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import net.sf.jaxodraw.object.JaxoExtendedObject;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.object.arrow.JaxoDefaultArrow;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoParticleObject
extends JaxoExtendedObject {
    public static final float PHOTON_FREQ = 0.05f;
    public static final float GLUON_FREQ = 0.08f;
    public static final float SCALAR_DASH = 10.0f;
    public static final float GHOST_DASH = 2.0f;
    private static final long serialVersionUID = 2L;
    private float dash;
    private int amp;
    private int wiggles;
    private boolean paintArrow;
    private boolean flip;
    private float arrowPosition;
    private boolean doubleLine;
    private float dlSeparation;
    private JaxoArrow arrow = new JaxoDefaultArrow();

    public JaxoParticleObject() {
        this.addPropertyChangeListener(this.arrow);
    }

    public JaxoObject copy() {
        JaxoParticleObject copy = (JaxoParticleObject)super.copy();
        copy.arrow = this.arrow.copy();
        copy.addPropertyChangeListener(copy.arrow);
        return copy;
    }

    public final int getWiggles() {
        return this.wiggles;
    }

    public final void setWiggles(int newWiggles) {
        Integer old = this.wiggles;
        this.wiggles = newWiggles;
        this.firePropertyChange("wiggles", old, this.wiggles);
    }

    public final float getDash() {
        return this.dash;
    }

    public final void setDash(float newDash) {
        Float old = Float.valueOf(this.dash);
        this.dash = newDash;
        this.firePropertyChange("arrowPosition", old, Float.valueOf(this.dash));
        this.resetStroke();
    }

    public final int getAmp() {
        return this.amp;
    }

    public final void setAmp(int newAmp) {
        Integer old = this.amp;
        this.amp = newAmp;
        this.firePropertyChange("amp", old, this.amp);
    }

    public final boolean isPaintArrow() {
        return this.paintArrow;
    }

    public final void setPaintArrow(boolean arr) {
        Boolean old = this.paintArrow;
        this.paintArrow = arr;
        this.firePropertyChange("paintArrow", old, this.paintArrow);
    }

    public final boolean isFlip() {
        return this.flip;
    }

    public final void setFlip(boolean newFlip) {
        Boolean old = this.flip;
        this.flip = newFlip;
        this.firePropertyChange("flip", old, this.flip);
    }

    public final float getArrowPosition() {
        return this.arrowPosition;
    }

    public final void setArrowPosition(float newArrowPosition) {
        if (newArrowPosition < -1.0E-4f || newArrowPosition > 1.0001f) {
            throw new IllegalArgumentException();
        }
        Float old = Float.valueOf(this.arrowPosition);
        this.arrowPosition = newArrowPosition;
        if (this.arrowPosition < 0.0f) {
            this.arrowPosition = 0.0f;
        }
        if (this.arrowPosition > 1.0f) {
            this.arrowPosition = 1.0f;
        }
        this.firePropertyChange("arrowPosition", old, Float.valueOf(this.arrowPosition));
    }

    public final void setDoubleLine(boolean dline) {
        Boolean old = this.doubleLine;
        this.doubleLine = dline;
        this.firePropertyChange("doubleLine", old, this.doubleLine);
    }

    public final boolean isDoubleLine() {
        return this.doubleLine;
    }

    public final void setDLSeparation(float dlsep) {
        Float old = Float.valueOf(this.dlSeparation);
        this.dlSeparation = dlsep;
        this.firePropertyChange("dlSeparation", old, Float.valueOf(this.dlSeparation));
    }

    public final float getDLSeparation() {
        return this.dlSeparation;
    }

    public final JaxoArrow getArrow() {
        return this.arrow;
    }

    public final void setArrow(JaxoArrow newArrow) {
        this.removePropertyChangeListener(this.arrow);
        JaxoArrow old = this.arrow;
        this.arrow = newArrow;
        this.firePropertyChange("arrow", old, this.arrow);
        this.addPropertyChangeListener(this.arrow);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoParticleObject tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoParticleObject && (tmp = (JaxoParticleObject)comp).dashIs(this.getDash()) && tmp.getAmp() == this.getAmp() && tmp.getWiggles() == this.getWiggles() && tmp.isPaintArrow() == this.isPaintArrow() && tmp.isFlip() == this.isFlip() && tmp.arrowPositionIs(this.getArrowPosition()) && tmp.isDoubleLine() == this.isDoubleLine() && tmp.getArrow().isCopy(this.arrow) && tmp.dlSepIs(this.getDLSeparation()) && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoParticleObject temp) {
        super.copyFrom(temp);
        this.setDash(temp.getDash());
        this.setAmp(temp.getAmp());
        this.setWiggles(temp.getWiggles());
        this.setPaintArrow(temp.isPaintArrow());
        this.setFlip(temp.isFlip());
        this.setArrowPosition(temp.getArrowPosition());
        this.setArrow(temp.getArrow());
        this.setDoubleLine(temp.isDoubleLine());
        this.setDLSeparation(temp.getDLSeparation());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoParticleObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoParticleObject)o);
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(JaxoPrefs.getBooleanPref("prefARROW"));
        this.setFlip(false);
        this.setArrowPosition(JaxoPrefs.getFloatPref("prefARROWPOSITION"));
        this.setAmp(JaxoPrefs.getIntPref("prefAMPLITUDE"));
        this.setDoubleLine(false);
        this.setDLSeparation(JaxoPrefs.getFloatPref("prefDLSEP"));
    }

    public final boolean dashIs(float comp) {
        return JaxoUtils.equal(comp, this.dash);
    }

    public final boolean dlSepIs(float comp) {
        return JaxoUtils.equal(comp, this.dlSeparation);
    }

    public final boolean arrowPositionIs(float comp) {
        return JaxoUtils.equal(comp, this.arrowPosition);
    }

    protected void paintArrow(JaxoGraphics2D g2) {
        this.arrow.paint(g2, this.arrowCoordinates());
    }

    public abstract JaxoArrow.Coordinates arrowCoordinates();
}

