/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.arc.JaxoArcObject;
import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoFArc
extends JaxoArcObject {
    private static final long serialVersionUID = 314159L;
    private transient Arc2D arc = new Arc2D.Double();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.arc = new Arc2D.Double();
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoFArc) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            return;
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(gp);
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        Rectangle bb;
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            bb = new Rectangle(this.getX(), this.getY(), 0, 0);
            bb.add(this.getX2(), this.getY2());
            bb.add(this.getX3(), this.getY3());
        } else {
            bb = this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
        }
        if (this.isPaintArrow()) {
            Rectangle arrowBB = this.getArrow().getBounds(this.arrowCoordinates());
            bb.add(arrowBB);
        }
        return bb;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (this.isSingular()) {
            return "% Singular FArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        if (this.isOneLine()) {
            JaxoFLine line = new JaxoFLine();
            line.setLocation(this.getX(), this.getY(), this.getX3(), this.getY3());
            line.setStrokeWidth(this.getStrokeWidth());
            line.setArrow(this.getArrow().copy());
            line.setArrowPosition(this.getArrowPosition());
            line.setPaintArrow(this.isPaintArrow());
            line.setFlip(this.isFlip());
            line.setDoubleLine(this.isDoubleLine());
            line.setDLSeparation(this.getDLSeparation());
            return line.latexCommand(scale, canvasDim);
        }
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double sa = par[4];
        double ea = par[3] + par[4];
        boolean clockwise = par[3] < 0.0;
        String options = this.getOptionsCommand(scale, clockwise);
        return "\\Arc" + options + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")" + "(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + ")";
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add3PointsPanel(this.getPoints(), 0, 0, 2);
        editPanel.addArrowPanel(this.isPaintArrow(), this.isFlip(), this.getArrowPosition(), 2, 0);
        editPanel.addArrowOptionsEditPanel(this.getArrow(), 3, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 1, 1);
        editPanel.addLineColorPanel(this.getColor(), 2, 1);
        editPanel.setTitleAndIcon("Fermion_arc_parameters", "farc.png");
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (this.isSingular()) {
            return null;
        }
        if (this.isOneLine()) {
            return this.getFLine(gp);
        }
        double[] par = this.getArcParameters();
        if (this.isDoubleLine()) {
            this.arc.setArcByCenter(par[0], par[1], par[2] + (double)(this.getDLSeparation() / 2.0f), par[4], par[3], 0);
            gp.append(this.arc, false);
            this.arc.setArcByCenter(par[0], par[1], par[2] - (double)(this.getDLSeparation() / 2.0f), par[4], par[3], 0);
            gp.append(this.arc, false);
        } else {
            this.arc.setArcByCenter(par[0], par[1], par[2], par[4], par[3], 0);
            gp.append(this.arc, false);
        }
        return gp;
    }

    private GeneralPath getFLine(GeneralPath gp) {
        if (this.isDoubleLine()) {
            float length = (float)Math.sqrt((this.getX() - this.getX3()) * (this.getX() - this.getX3()) + (this.getY() - this.getY3()) * (this.getY() - this.getY3()));
            float sepx = (float)(this.getY3() - this.getY()) / length * this.getDLSeparation() / 2.0f;
            float sepy = (float)(this.getX3() - this.getX()) / length * this.getDLSeparation() / 2.0f;
            gp.moveTo((float)this.getX() - sepx, (float)this.getY() + sepy);
            gp.lineTo((float)this.getX3() - sepx, (float)this.getY3() + sepy);
            gp.moveTo((float)this.getX() + sepx, (float)this.getY() - sepy);
            gp.lineTo((float)this.getX3() + sepx, (float)this.getY3() - sepy);
        } else {
            gp.moveTo(this.getX(), this.getY());
            gp.lineTo(this.getX3(), this.getY3());
        }
        return gp;
    }

    private String getOptionsCommand(float scale, boolean clockwise) {
        StringBuffer optioncmd = new StringBuffer(128);
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            optioncmd.append(this.getArrow().latexCommand(arpos, scale));
            if (this.isFlip()) {
                optioncmd.append(",flip");
            }
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
            if (clockwise) {
                optioncmd.append(",clock");
            }
            optioncmd.insert(0, "[").append("]");
        } else if (this.isDoubleLine()) {
            optioncmd.append("double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            if (clockwise) {
                optioncmd.append(",clock");
            }
            optioncmd.insert(0, "[").append("]");
        } else if (clockwise) {
            optioncmd.append("[clock]");
        }
        return optioncmd.toString();
    }
}

