/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoSymmetricObject;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.arc.JaxoArcObject;
import net.sf.jaxodraw.object.line.JaxoPLine;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoPArc
extends JaxoArcObject
implements JaxoWiggleObject,
JaxoSymmetricObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;
    private boolean symmetric = true;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public final boolean isSymmetric() {
        return this.symmetric;
    }

    public final void setSymmetric(boolean newSymm) {
        Boolean old = this.symmetric;
        this.symmetric = newSymm;
        this.firePropertyChange("symmetric", old, this.symmetric);
    }

    public void copyFrom(JaxoPArc temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
        this.symmetric = temp.isSymmetric();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoPArc)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoPArc)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        JaxoPArc arc;
        boolean isCopy = false;
        if (comp instanceof JaxoPArc && (arc = (JaxoPArc)comp).isSymmetric() == this.isSymmetric() && super.isCopy(arc)) {
            isCopy = true;
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        if (gp != null) {
            g2.setColor(this.getColor());
            g2.setStroke(this.getStroke());
            g2.draw(gp);
        }
    }

    public Rectangle getBounds() {
        GeneralPath gp = this.getObjectPath();
        if (gp == null) {
            Rectangle r = new Rectangle(this.getX(), this.getY(), 0, 0);
            r.add(this.getX2(), this.getY2());
            r.add(this.getX3(), this.getY3());
            return r;
        }
        return this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (this.isSingular()) {
            return "% Singular PhotonArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        double nwin = this.getWiggles();
        if (nwin > 1000.0) {
            return "% Enormous PhotonArc, ignored!" + JaxoUtils.LINE_SEPARATOR;
        }
        if (this.isOneLine()) {
            JaxoPLine line = new JaxoPLine();
            line.setLocation(this.getX(), this.getY(), this.getX3(), this.getY3());
            line.setStrokeWidth(this.getStrokeWidth());
            line.setAmp(this.getAmp());
            line.setWiggles(this.getWiggles());
            line.setDoubleLine(this.isDoubleLine());
            line.setDLSeparation(this.getDLSeparation());
            line.setSymmetric(this.isSymmetric());
            return line.latexCommand(scale, canvasDim);
        }
        double[] par = this.getArcParameters();
        double cx = par[0] / (double)scale;
        double cy = ((double)canvasDim.height - par[1]) / (double)scale;
        double r = par[2] / (double)scale;
        double ea = par[3] + par[4];
        double sa = par[4];
        boolean clockwise = par[3] < 0.0;
        double amp = (double)this.getAmp() / (2.0 * (double)scale);
        double nwig = this.getWiggles();
        if (this.isSymmetric()) {
            nwig += 0.5;
        }
        String options = this.getOptionsCommand(clockwise);
        return "\\PhotonArc" + options + "(" + D_FORMAT.format(cx) + "," + D_FORMAT.format(cy) + ")" + "(" + D_FORMAT.format(r) + "," + D_FORMAT.format(sa) + "," + D_FORMAT.format(ea) + ")" + "{" + D_FORMAT.format(amp) + "}" + "{" + D_FORMAT.format(nwig) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.getArcLength() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.getArcLength());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setWigglesFromFrequency(0.05f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add3PointsPanel(this.getPoints(), 0, 0, 2);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 1);
        editPanel.addSymmPanel(this.isSymmetric(), 2, 1);
        editPanel.addLineColorPanel(this.getColor(), 3, 1);
        editPanel.setTitleAndIcon("Photon_arc_parameters", "photonarc.png");
    }

    private GeneralPath getObjectPath() {
        if (this.isSingular()) {
            return null;
        }
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        if (this.isOneLine()) {
            this.appendPhotonLine(gp);
            return gp;
        }
        if (this.getWiggles() > 1000) {
            return null;
        }
        if (this.isDoubleLine()) {
            float ds = this.getDLSeparation() / 2.0f;
            this.appendFullArc(gp, ds);
            this.appendFullArc(gp, -ds);
        } else {
            this.appendFullArc(gp, 0.0f);
        }
        return gp;
    }

    private void appendFullArc(GeneralPath gp, float sep) {
        double[] par = this.getArcParameters();
        float cx = (float)par[0];
        float cy = (float)par[1];
        float r = (float)par[2] + sep;
        float oa = (float)(-Math.toRadians(par[3]));
        float sa = (float)(-Math.toRadians(par[4]));
        int n = 2 * this.getWiggles();
        if (this.isSymmetric()) {
            ++n;
        }
        float amp = -0.5f * (float)this.getAmp();
        float cos = (float)Math.cos(sa);
        float sin = (float)Math.sin(sa);
        float delta = oa / (float)n;
        float cp = (float)Math.cos(delta);
        float sp = (float)Math.sin(delta);
        float cp2 = (float)Math.cos(delta / 2.0f);
        float sp2 = (float)Math.sin(delta / 2.0f);
        gp.moveTo(this.getX(), this.getY());
        for (int j = 1; j <= n; ++j) {
            float thetaj = (float)(j - 1) * delta;
            amp = -amp;
            float cs = (float)Math.cos(thetaj);
            float sn = (float)Math.sin(thetaj);
            float beta = (float)((double)(r * oa) / Math.PI / (double)amp / (double)n);
            float tt = (sp - cp * beta) / (cp + sp * beta);
            float amp1 = (8.0f * (r + amp) * (beta * cp2 - sp2) - (beta * (4.0f + cp) + 3.0f * tt * cp - 4.0f * sp) * r) / (3.0f * (beta - tt));
            float x1 = (8.0f * (r + amp) * cp2 - (1.0f + cp) * r) / 3.0f - amp1;
            float y1 = (x1 - r) * beta;
            float x2 = amp1;
            float y2 = (amp1 - r * cp) * tt + r * sp;
            float x3 = r * cp;
            float y3 = r * sp;
            this.curveTo(gp, x1 * cs - y1 * sn, x1 * sn + y1 * cs, x2 * cs - y2 * sn, x2 * sn + y2 * cs, x3 * cs - y3 * sn, x3 * sn + y3 * cs, cos, sin, cx, cy);
        }
    }

    private void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3, float cos, float sin, float cx, float cy) {
        gp.curveTo(x1 * cos - y1 * sin + cx, x1 * sin + y1 * cos + cy, x2 * cos - y2 * sin + cx, x2 * sin + y2 * cos + cy, x3 * cos - y3 * sin + cx, x3 * sin + y3 * cos + cy);
    }

    private void appendPhotonLine(GeneralPath gp) {
        if (this.isDoubleLine()) {
            float dlsep = this.getDLSeparation() / 2.0f;
            this.appendFullLine(gp, dlsep);
            this.appendFullLine(gp, -dlsep);
        } else {
            this.appendFullLine(gp, 0.0f);
        }
    }

    private void appendFullLine(GeneralPath gp, float sep) {
        float length = (float)Math.sqrt((this.getX3() - this.getX()) * (this.getX3() - this.getX()) + (this.getY3() - this.getY()) * (this.getY3() - this.getY()));
        int n = 2 * this.getWiggles();
        if (this.isSymmetric()) {
            ++n;
        }
        float ts = length / (float)n;
        float sin = (float)(this.getY3() - this.getY()) / length;
        float cos = (float)(this.getX3() - this.getX()) / length;
        float c = 1.3333334f * ts / (float)Math.PI;
        float amp = -0.6666667f * (float)this.getAmp();
        gp.moveTo(this.getX(), (float)this.getY() + sep);
        for (int i = 1; i <= n; ++i) {
            float x0 = (float)(i - 1) * ts;
            this.curveTo(gp, x0 + c, amp + sep, x0 + ts - c, amp + sep, x0 + ts, sep, cos, sin, this.getX(), this.getY());
            amp = -amp;
        }
    }

    private String getOptionsCommand(boolean clockwise) {
        StringBuffer buffer = new StringBuffer(128);
        if (this.isDoubleLine()) {
            String dlsep = D_FORMAT.format(this.getDLSeparation());
            buffer.append("double,sep=").append(dlsep);
        }
        if (clockwise) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append("clock");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, '[');
            buffer.append(']');
        }
        return buffer.toString();
    }
}

