/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoSymmetricObject;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.line.JaxoLineObject;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoZigZagLine
extends JaxoLineObject
implements JaxoWiggleObject,
JaxoSymmetricObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;
    private boolean symmetric;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public final boolean isSymmetric() {
        return this.symmetric;
    }

    public final void setSymmetric(boolean newSymm) {
        Boolean old = this.symmetric;
        this.symmetric = newSymm;
        this.firePropertyChange("symmetric", old, this.symmetric);
    }

    public void copyFrom(JaxoZigZagLine temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
        this.symmetric = temp.isSymmetric();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoZigZagLine)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoZigZagLine)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        JaxoZigZagLine line;
        boolean isCopy = false;
        if (comp instanceof JaxoZigZagLine && (line = (JaxoZigZagLine)comp).isSymmetric() == this.isSymmetric() && super.isCopy(line)) {
            isCopy = true;
        }
        return isCopy;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            return "%";
        }
        if (this.isDoubleLine()) {
            Point2D offSet = this.getLatexDLOffSet(scale);
            String command1 = this.latexString(startPoint, endPoint, offSet, scale, 1.0f);
            String command2 = this.latexString(startPoint, endPoint, offSet, scale, -1.0f);
            return command1.concat(command2.concat("%%JaxoDrawID:DoubleLine(" + D_FORMAT.format(this.getDLSeparation()) + ")"));
        }
        return this.latexString(startPoint, endPoint, endPoint, scale, 0.0f);
    }

    private String latexString(Point2D startPoint, Point2D endPoint, Point2D offSet, float scale, float sign) {
        float amplitude = (float)this.getAmp() / (2.0f * scale);
        float wiggles = this.getLaTexWiggleNumber();
        StringBuffer command = new StringBuffer(32);
        command.append("\\ZigZag(").append(D_FORMAT.format(startPoint.getX() + (double)sign * offSet.getX())).append(',').append(D_FORMAT.format(startPoint.getY() + (double)sign * offSet.getY())).append(")(").append(D_FORMAT.format(endPoint.getX() + (double)sign * offSet.getX())).append(',').append(D_FORMAT.format(endPoint.getY() + (double)sign * offSet.getY())).append("){").append(D_FORMAT.format(amplitude)).append("}{").append(D_FORMAT.format(wiggles)).append('}');
        return command.toString();
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.length() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.length());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(false);
        this.setSymmetric(false);
        this.setWigglesFromFrequency(0.05f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add2PointsPanel(this.getPoints(), 0, 0);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 0);
        editPanel.addSymmPanel(this.isSymmetric(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 1, 1);
        editPanel.addColorPanel(this.getColor(), 2, 2, 1);
        editPanel.setTitleAndIcon("Zigzag_line_parameters", "zigzag.png");
    }

    private float getLaTexWiggleNumber() {
        float n = this.getWiggles();
        if (this.isSymmetric()) {
            n += 0.5f;
        }
        return n;
    }

    protected GeneralPath getObjectPath() {
        float length;
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        float a = Math.round((float)this.getAmp() / 1.5f);
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        int n = 2 * this.getWiggles();
        if (this.isSymmetric()) {
            ++n;
        }
        if (JaxoUtils.zero(length = (float)this.getRadius())) {
            length = 1.0f;
        }
        float sin = (float)this.getRelh() / length;
        float cos = (float)this.getRelw() / length;
        float ts = length / (float)n;
        if (this.isDoubleLine()) {
            float y;
            float x;
            int i;
            float dlsep = this.getDLSeparation() / 2.0f;
            gp.moveTo(this.getX(), (float)this.getY() + dlsep);
            for (i = 1; i <= n; ++i) {
                x = (float)(2 * i - 1) * ts / 2.0f;
                y = -a + dlsep;
                gp.lineTo(x * cos - y * sin + (float)this.getX(), x * sin + y * cos + (float)this.getY());
                x = (float)i * ts;
                y = dlsep;
                gp.lineTo(x * cos - y * sin + (float)this.getX(), x * sin + y * cos + (float)this.getY());
                a = -a;
            }
            gp.moveTo(this.getX(), (float)this.getY() - dlsep);
            a = Math.round((float)this.getAmp() / 1.5f);
            for (i = 1; i <= n; ++i) {
                x = (float)(2 * i - 1) * ts / 2.0f;
                y = -a - dlsep;
                gp.lineTo(x * cos - y * sin + (float)this.getX(), x * sin + y * cos + (float)this.getY());
                x = (float)i * ts;
                y = -dlsep;
                gp.lineTo(x * cos - y * sin + (float)this.getX(), x * sin + y * cos + (float)this.getY());
                a = -a;
            }
        } else {
            gp.moveTo(this.getX(), this.getY());
            for (int i = 1; i <= n; ++i) {
                float x = (float)(2 * i - 1) * ts / 2.0f;
                float y = -a;
                gp.lineTo(x * cos - y * sin + (float)this.getX(), x * sin + y * cos + (float)this.getY());
                x = (float)i * ts;
                gp.lineTo(x * cos + (float)this.getX(), x * sin + (float)this.getY());
                a = -a;
            }
        }
        return gp;
    }

    protected String getAxo4JOptions(float scale) {
        return "";
    }
}

