/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.loop;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.loop.JaxoLoopObject;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoDashLoop
extends JaxoLoopObject {
    private static final long serialVersionUID = 314159L;
    private transient BasicStroke innerStroke;
    private transient BasicStroke outerStroke;
    private transient Ellipse2D loop = new Ellipse2D.Double();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.loop = new Ellipse2D.Double();
        this.resetStroke();
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        if (this.isDoubleLine()) {
            this.resetStroke();
            g2.setStroke(this.innerStroke);
            g2.draw(this.getInnerPath());
            g2.setStroke(this.outerStroke);
            g2.draw(this.getOuterPath());
        } else {
            g2.setStroke(this.getStroke());
            g2.draw(this.getObjectPath());
        }
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        Rectangle bb;
        if (this.isDoubleLine()) {
            bb = this.innerStroke.createStrokedShape(this.getInnerPath()).getBounds();
            bb.add(this.outerStroke.createStrokedShape(this.getOuterPath()).getBounds());
        } else {
            bb = this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
        }
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    protected void resetStroke() {
        if (JaxoUtils.zero(this.getStrokeWidth()) || JaxoUtils.zero(this.getDash())) {
            return;
        }
        float length = (float)this.getRadius();
        if (JaxoUtils.zero(length)) {
            length = 1.0f;
        }
        this.setStroke(new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f));
        this.innerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.innerStrokeDashes(length), 0.0f);
        this.outerStroke = new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.outerStrokeDashes(length), 0.0f);
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = this.getRadius();
        this.loop.setFrame(-length + (double)this.getX(), -length + (double)this.getY(), 2.0 * length, 2.0 * length);
        gp.append(this.loop, false);
        return gp;
    }

    private GeneralPath getOuterPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        float length = (float)this.getRadius();
        float dlsep = this.getDLSeparation() / 2.0f;
        this.loop.setFrame(-length - dlsep + (float)this.getX(), -length - dlsep + (float)this.getY(), 2.0f * (length + dlsep), 2.0f * (length + dlsep));
        gp.append(this.loop, false);
        return gp;
    }

    private GeneralPath getInnerPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        float length = (float)this.getRadius();
        float dlsep = this.getDLSeparation() / 2.0f;
        this.loop.setFrame(-length + dlsep + (float)this.getX(), -length + dlsep + (float)this.getY(), 2.0f * (length - dlsep), 2.0f * (length - dlsep));
        gp.append(this.loop, false);
        return gp;
    }

    protected String getAxo4JOptions(float scale) {
        float dashSize = this.getDash() / scale;
        StringBuffer optioncmd = new StringBuffer("dash,dashsize=").append(D_FORMAT.format(dashSize));
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            StringBuffer arrowcmd = new StringBuffer(this.getArrow().latexCommand(arpos, scale));
            if (this.isFlip()) {
                arrowcmd.append(",flip");
            }
            optioncmd.append(',').append(arrowcmd);
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
        } else if (this.isDoubleLine()) {
            optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
        }
        optioncmd.insert(0, '[').append(']');
        return optioncmd.toString();
    }

    protected abstract float[] strokeDashes();

    protected abstract float[] innerStrokeDashes(double var1);

    protected abstract float[] outerStrokeDashes(double var1);
}

