/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.loop;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.loop.JaxoLoopObject;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoPLoop
extends JaxoLoopObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public void copyFrom(JaxoPLoop temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoPLoop)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoPLoop)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = super.isCopy(comp);
        if (comp instanceof JaxoPLoop) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D angles = this.getLaTexAngles();
        float amplitude = (float)this.getAmp() / (2.0f * scale);
        float wiggles = this.getWiggles();
        String options = this.getAxo4JOptions(scale);
        return "\\PhotonArc" + options + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(radius) + "," + D_FORMAT.format(angles.getX() - 180.0) + "," + D_FORMAT.format(angles.getY() - 180.0) + ")" + "{" + D_FORMAT.format(amplitude) + "}" + "{" + D_FORMAT.format(wiggles) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        double r = this.getRadius();
        int n = (int)Math.round(2.0 * r * Math.PI * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        double r = this.getRadius();
        this.freq = (float)((double)wiggles / (2.0 * r * Math.PI));
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(false);
        this.setArrowPosition(0.0f);
        this.setWigglesFromFrequency(0.05f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 0);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addColorPanel(this.getColor(), 2, 1, 1);
        editPanel.setTitleAndIcon("Photon_loop_parameters", "photonloop.png");
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        float radius = (float)this.getRadius();
        if (radius <= 1.0f) {
            return null;
        }
        if (this.isDoubleLine()) {
            float ds = this.getDLSeparation() / 2.0f;
            this.appendFullLoop(gp, radius, ds);
            this.appendFullLoop(gp, radius, -ds);
        } else {
            this.appendFullLoop(gp, radius, 0.0f);
        }
        return gp;
    }

    private void appendFullLoop(GeneralPath gp, float radius, float sep) {
        int n = 2 * this.getWiggles();
        float delta = (float)(Math.PI * 2 / (double)n);
        float amp = 0.5f * (float)this.getAmp();
        float r = radius + sep;
        float cos = (float)this.getRelw() / radius;
        float sin = (float)this.getRelh() / radius;
        float cp = (float)Math.cos(delta);
        float sp = (float)Math.sin(delta);
        float cp2 = (float)Math.cos(delta / 2.0f);
        float sp2 = (float)Math.sin(delta / 2.0f);
        gp.moveTo(r * cos + (float)this.getX(), r * sin + (float)this.getY());
        for (int j = 1; j <= n; ++j) {
            float thetaj = (float)(j - 1) * delta;
            amp = -amp;
            float cs = (float)Math.cos(thetaj);
            float sn = (float)Math.sin(thetaj);
            float beta = r * 2.0f / amp / (float)n;
            float tt = (sp - cp * beta) / (cp + sp * beta);
            float amp1 = (8.0f * (r + amp) * (beta * cp2 - sp2) - (beta * (4.0f + cp) + 3.0f * tt * cp - 4.0f * sp) * r) / (3.0f * (beta - tt));
            float x1 = (8.0f * (r + amp) * cp2 - (1.0f + cp) * r) / 3.0f - amp1;
            float y1 = (x1 - r) * beta;
            float x2 = amp1;
            float y2 = (amp1 - r * cp) * tt + r * sp;
            float x3 = r * cp;
            float y3 = r * sp;
            this.curveTo(gp, x1 * cs - y1 * sn, x1 * sn + y1 * cs, x2 * cs - y2 * sn, x2 * sn + y2 * cs, x3 * cs - y3 * sn, x3 * sn + y3 * cs, cos, sin);
        }
    }

    private void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3, float cos, float sin) {
        gp.curveTo(x1 * cos - y1 * sin + (float)this.getX(), x1 * sin + y1 * cos + (float)this.getY(), x2 * cos - y2 * sin + (float)this.getX(), x2 * sin + y2 * cos + (float)this.getY(), x3 * cos - y3 * sin + (float)this.getX(), x3 * sin + y3 * cos + (float)this.getY());
    }

    protected String getAxo4JOptions(float scale) {
        String optioncmd = "";
        if (this.isDoubleLine()) {
            optioncmd = "[double,sep=" + D_FORMAT.format(this.getDLSeparation()) + "]";
        }
        return optioncmd;
    }
}

