/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoExtendedObject;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoRotationObject;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoVertex
extends JaxoExtendedObject
implements JaxoRotationObject {
    private static final long serialVersionUID = 2L;
    private static final int LP4 = 12;

    public final int getRotationAngle() {
        double theta = Math.atan2(this.getRelh(), this.getRelw());
        return (int)Math.round(Math.toDegrees(theta));
    }

    public final void setRotationAngle(int angle) {
        double radAngle = Math.toRadians(angle);
        double length = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        int newRelW = (int)Math.round(length * Math.cos(radAngle));
        int newRelH = (int)Math.round(length * Math.sin(radAngle));
        this.setRelWAndH(newRelW, newRelH);
    }

    public final JaxoObject copy(JaxoVertex temp) {
        temp.copyFrom(this);
        return temp;
    }

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertex) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paintVisualAid(JaxoGraphics2D g2) {
        int x = this.getX();
        int y = this.getY();
        g2.drawLine(x - 12, y, x + 12, y);
        g2.drawLine(x, y - 12, x, y + 12);
    }

    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        this.setLocation((int)Math.round(newP.getX()), (int)Math.round(newP.getY()));
        this.setX2(this.getX() + newRelWidth);
        this.setY2(this.getY() + newRelHeight);
    }

    protected Point2D getLaTexCenter(float scaleFactor, int canvasHeight) {
        return this.getLaTexLocation(scaleFactor, canvasHeight);
    }

    protected float getLaTexRadius(float scaleFactor) {
        return (float)Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight()) / scaleFactor;
    }

    public void setPreferences() {
        super.setPreferences();
        int size = JaxoPrefs.getIntPref("prefVERTEXSIZE");
        if (size > 0) {
            this.setRelWAndH(size, size);
        }
    }

    protected void prepareGenericPanel(JaxoObjectEditPanel editPanel, String iconName) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addColorPanel(this.getColor(), 2, 1, 0);
        editPanel.setTitleAndIcon("Vertex_parameters", iconName);
    }
}

