/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.vertex.JaxoVertex;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT6
extends JaxoVertex {
    private static final long serialVersionUID = 314159L;
    private transient Rectangle2D square = new Rectangle2D.Float();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.square = new Rectangle2D.Float();
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT6) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        g2.setColor(this.getColor());
        g2.fill(gp);
        g2.draw(gp);
    }

    public Rectangle getBounds() {
        return this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale) * (float)Math.sqrt(2.0);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D.Float p1 = new Point2D.Float((float)(center.getX() - (double)radius), (float)center.getY());
        Point2D.Float p2 = new Point2D.Float((float)center.getX(), (float)(center.getY() + (double)radius));
        Point2D.Float p3 = new Point2D.Float((float)(center.getX() + (double)radius), (float)center.getY());
        Point2D.Float p4 = new Point2D.Float((float)center.getX(), (float)(center.getY() - (double)radius));
        String tlc = JaxoColor.getColorName(this.getColor());
        return "\\CTri(" + D_FORMAT.format(((Point2D)p1).getX()) + "," + D_FORMAT.format(((Point2D)p1).getY()) + ")" + "(" + D_FORMAT.format(((Point2D)p2).getX()) + "," + D_FORMAT.format(((Point2D)p2).getY()) + ")" + "(" + D_FORMAT.format(((Point2D)p3).getX()) + "," + D_FORMAT.format(((Point2D)p3).getY()) + ")" + "{" + tlc + "}" + "{" + tlc + "}" + "\\CTri" + "(" + D_FORMAT.format(((Point2D)p1).getX()) + "," + D_FORMAT.format(((Point2D)p1).getY()) + ")" + "(" + D_FORMAT.format(((Point2D)p4).getX()) + "," + D_FORMAT.format(((Point2D)p4).getY()) + ")" + "(" + D_FORMAT.format(((Point2D)p3).getX()) + "," + D_FORMAT.format(((Point2D)p3).getY()) + ")" + "{" + tlc + "}" + "{" + tlc + "}";
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        this.prepareGenericPanel(editPanel, "vertexT6.png");
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        this.square.setFrame(-length + (double)this.getX(), -length + (double)this.getY(), 2.0 * length, 2.0 * length);
        gp.append(this.square, false);
        AffineTransform at = new AffineTransform();
        at.rotate(0.7853981633974483, this.getX(), this.getY());
        gp.transform(at);
        return gp;
    }
}

