/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoGeometry {
    private JaxoGeometry() {
    }

    public static void add(Rectangle2D r, Rectangle2D s) {
        if (!s.isEmpty()) {
            if (r.isEmpty()) {
                r.setRect(s);
            } else {
                r.add(s);
            }
        }
    }

    public static void add(Rectangle r, int x, int y, int width, int height) {
        if (width > 0 && height > 0) {
            JaxoGeometry.add(r, new Rectangle(x, y, width, height));
        }
    }

    public static void clear(Rectangle2D r) {
        r.setRect(0.0, 0.0, 0.0, 0.0);
    }

    public static void grow(Rectangle r, Insets n) {
        r.x -= n.left;
        r.y -= n.top;
        r.width += n.left + n.right;
        r.height += n.top + n.bottom;
    }

    public static void shrink(Rectangle r, Insets n) {
        r.x += n.left;
        r.y += n.top;
        r.width -= n.left + n.right;
        r.height -= n.top + n.bottom;
    }

    public static void grow(Dimension d, Insets n) {
        d.width += n.left + n.right;
        d.height += n.top + n.bottom;
    }

    public static void shrink(Dimension d, Insets n) {
        d.width -= n.left + n.right;
        d.height -= n.top + n.bottom;
    }

    public static Rectangle getBounds(Collection<?> objects) {
        Iterator<?> i = objects.iterator();
        Rectangle bBox = null;
        Object o = null;
        while (i.hasNext()) {
            o = i.next();
            if (!(o instanceof Shape)) continue;
            if (bBox == null) {
                bBox = ((Shape)o).getBounds();
                continue;
            }
            bBox.add(((Shape)o).getBounds());
        }
        return bBox;
    }

    public static Point2D scaledPoint(double orx, double ory, double scale, double px, double py) {
        Point2D.Double newP = new Point2D.Double(scale * (px - orx) + orx, scale * (py - ory) + ory);
        return newP;
    }

    public static double bezierLength(Point2D[] p, double error) {
        double l1 = p[0].distance(p[1]) + p[1].distance(p[2]) + p[2].distance(p[3]);
        double l0 = p[0].distance(p[3]);
        double err = l1 - l0;
        double length = 0.5 * (l0 + l1);
        if (err > error) {
            Point2D[] left = new Point2D.Double[4];
            Point2D[] right = new Point2D.Double[4];
            JaxoGeometry.bezierSplit(p, left, right);
            length = JaxoGeometry.bezierLength(left, error) + JaxoGeometry.bezierLength(right, error);
        }
        return length;
    }

    public static void bezierSplit(Point2D[] controlPoints, Point2D[] left, Point2D[] right) {
        int i;
        for (i = 0; i <= 3; ++i) {
            left[i] = new Point2D.Double();
            right[i] = new Point2D.Double();
            left[i].setLocation(controlPoints[i]);
        }
        for (i = 1; i <= 3; ++i) {
            right[4 - i].setLocation(left[3]);
            for (int j = 3; j >= i; --j) {
                left[j].setLocation((left[j - 1].getX() + left[j].getX()) / 2.0, (left[j - 1].getY() + left[j].getY()) / 2.0);
            }
        }
        right[0].setLocation(left[3]);
    }

    public static Point2D bezierPoint(Point2D[] p, double u) {
        double t = JaxoGeometry.curveParameter(u);
        double s = 1.0 - t;
        double x = s * s * s * p[0].getX() + 3.0 * t * s * s * p[1].getX() + 3.0 * t * t * s * p[2].getX() + t * t * t * p[3].getX();
        double y = s * s * s * p[0].getY() + 3.0 * t * s * s * p[1].getY() + 3.0 * t * t * s * p[2].getY() + t * t * t * p[3].getY();
        return new Point2D.Double(x, y);
    }

    public static double bezierSlope(Point2D[] p, double u) {
        double t = JaxoGeometry.curveParameter(u);
        double s = 1.0 - t;
        double x = -3.0 * s * s * p[0].getX() + 3.0 * (s * s - 2.0 * t * s) * p[1].getX() + 3.0 * (2.0 * t * s - t * t) * p[2].getX() + 3.0 * t * t * p[3].getX();
        double y = -3.0 * s * s * p[0].getY() + 3.0 * (s * s - 2.0 * t * s) * p[1].getY() + 3.0 * (2.0 * t * s - t * t) * p[2].getY() + 3.0 * t * t * p[3].getY();
        return Math.atan2(y, x);
    }

    public static double curveParameter(double u) {
        if (u < -1.0E-5 || u > 1.00001) {
            throw new IllegalArgumentException("Curve-Parameter out of range: " + u);
        }
        double t = u;
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        return t;
    }

    public static void translate(Point2D p, double dx, double dy) {
        p.setLocation(p.getX() + dx, p.getY() + dy);
    }

    public static void setLocationRelativeToAvoiding(Window w, Component comp, Rectangle avoidme) {
        Component c = comp;
        Rectangle avoid = avoidme;
        int width = w.getWidth();
        int height = w.getHeight();
        Rectangle screen = w.getGraphicsConfiguration().getBounds();
        JaxoGeometry.shrink(screen, w.getToolkit().getScreenInsets(w.getGraphicsConfiguration()));
        Point location = new Point();
        if (c != null) {
            if (c.isShowing()) {
                Component root = SwingUtilities.getRoot(c);
                if (root == null) {
                    c = null;
                }
            } else {
                c = null;
            }
        }
        if (c == null) {
            location.x = screen.x + (screen.width - width) / 2;
            location.y = screen.y + (screen.height - height) / 2;
        } else {
            Point p = c.getLocationOnScreen();
            location.x = p.x + (c.getWidth() - width) / 2;
            location.y = p.y + (c.getHeight() - height) / 2;
            location.x = Math.min(location.x + width, screen.x + screen.width) - width;
            location.y = Math.min(location.y + width, screen.y + screen.width) - width;
            location.x = Math.max(location.x, screen.x);
            location.y = Math.max(location.y, screen.y);
        }
        if (avoid != null) {
            avoid = avoid.intersection(screen);
            if (location.y + height >= avoid.y && location.y <= avoid.y + avoid.height) {
                int spaceAbove = avoid.y - screen.y;
                int spaceBelow = screen.y + screen.height - avoid.y - avoid.height;
                location.y = spaceAbove > spaceBelow ? screen.y + Math.max(0, spaceAbove - height) : screen.y + Math.max(0, screen.height - Math.max(spaceBelow, height));
            }
        }
        w.setLocation(location);
    }
}

