/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic;

import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.log4j.*;
import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.Cache;
import com.bluedragontavern.albumgrabber.allmusic.pages.*;
import com.bluedragontavern.albumgrabber.util.*;

/**
 *
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2002</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class AlbumSearch
{
	private static Logger logger = Logger.getLogger(AlbumSearch.class);

	public static final String OPT1_NAME = "1";
	public static final String OPT1_ALBUM = "2";
	public static final String OPT1_SONG = "3";
	public static final String OPT1_CLASSICAL_WORK = "55";

	/**
	 * Search both ways, then decide which is the best match
	 */
	public static Album search(Album album)
		throws Exception
	{
		System.out.println("Searching for... " + album.toStringSearch());

		//Skip the artist search if artist name contains "Various"
		RE findVariousRE = new RE("various", RE.MATCH_CASEINDEPENDENT);
		Album album1 = album;

		if (findVariousRE.match(album.getSearchArtistName()) == false)
		{
			album1 = searchArtistThenAlbum(album);
		}

		//Now search for Album first, no restrictions here (so far)
		Album album2 = searchAlbum(album);

		//Decide which is closest
		Album bestMatchingAlbum;

		if (album1.isFound() == true && album2.isFound() == true)
		{
			bestMatchingAlbum = CompareStrings.compareAlbumSearchResults(album1,
				album2);
		}
		else if (album1.isFound() == true && album2.isFound() == false)
		{
			bestMatchingAlbum = album1;
		}
		else
		{
			bestMatchingAlbum = album2;
		}

		//If album found, get the bytes for the image
		if (bestMatchingAlbum.isFound())
		{
			bestMatchingAlbum.getImageBytes();
			System.out.println("Searched for: " +
									 bestMatchingAlbum.getSearchArtistName() + " - " +
									 bestMatchingAlbum.getSearchAlbumName() +
									 " and found: " +
									 bestMatchingAlbum.getFoundArtistName() + " - " +
									 bestMatchingAlbum.getFoundAlbumName());

			//If DEBUG, report which method won out
			if (Constants.DEBUG)
			{
				if (bestMatchingAlbum == album1)
				{
					System.out.println("Artist/Album combination matched best");
				}
				else
				{
					System.out.println("Album only search matched best");
				}
			}

			//Increment num albums sucessfully located
			Report.getInstance().incNumAlbumsLocated();
		}
		else
		{
			System.out.println("Could not find album for " +
									 bestMatchingAlbum.getSearchArtistName() + " - " +
									 bestMatchingAlbum.getSearchAlbumName());
		}

		return bestMatchingAlbum;
	}

	/**
	 * Returns the best matching Album
	 * @param album DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static Album searchArtistThenAlbum(Album album)
		throws Exception
	{
		//First check the cache
		String html = Cache.getInstance().getArtistSearchResult(
			album.getSearchArtistName());

		if (html == null)
		{
			String uriArtist = URLEncoder.encode(album.getSearchArtistName(),
															 "UTF-8");

			Properties props = new Properties();
			props.put("P", "amg");
			props.put("SQL", uriArtist);
			props.put("OPT1", OPT1_NAME);
			props.put("Submit", "Go");

			URL url = new URL("http://www.allmusic.com/cg/amg.dll?p=amg");
			html = NetUtil.doPost(url, props, null);

			//Cache the artist search result for performance reasons
			Cache.getInstance().addArtistSearchResult(album.getSearchArtistName(),
				html);
		}

		//Check if we got lucky(found artist on first try)
		ArtistPage artistPage = new ArtistPage(html);
		album = artistPage.getDiscography().getAlbum(album);

		if (album.isFound() == false)
		{
			//Perhaps we got multiple hits
			MultipleArtistsPage multipleArtistsPage = new MultipleArtistsPage(
				html);
			album = multipleArtistsPage.getAlbum(album);
		}

		return album;
	}

	/**
	 * Returns the best matching Album
	 * @param album DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static Album searchAlbum(Album album)
		throws Exception
	{
		String uriAlbum = URLEncoder.encode(album.getSearchAlbumName(), "UTF-8");

		Properties props = new Properties();
		props.put("P", "amg");
		props.put("SQL", uriAlbum);
		props.put("OPT1", OPT1_ALBUM);
		props.put("Submit", "Go");

		URL url = new URL("http://www.allmusic.com/cg/amg.dll?p=amg");
		String html = NetUtil.doPost(url, props, null);
		//logger.debug("searchAlbum album = " + album + ", HTML = " + html);

		//Check if we got lucky(found album on first try)
		AlbumPage albumPage = new AlbumPage(html);
		album = albumPage.getAlbum(album);

		if (album.isFound() == false)
		{
			//Perhaps we got multiple hits
			MultipleAlbumsPage multipleAlbumsPage = new MultipleAlbumsPage(html);
			album = multipleAlbumsPage.getAlbum(album);
		}

		return album;
	}

	//Test main
	public static void main(String[] argv)
	{
		try
		{
			search(new Album(new File("P:/pub/MP3z/Aerosmith/Draw The Line")));
		}
		catch (Exception ex)
		{
			System.out.println(ex);
		}
	}
}
