package com.bluedragontavern.albumgrabber.allmusic.pages;

import com.bluedragontavern.albumgrabber.Album;
import org.apache.regexp.RE;
import com.bluedragontavern.albumgrabber.util.IndexScore;
import com.bluedragontavern.albumgrabber.util.CompareStrings;
import java.net.URL;
import com.bluedragontavern.albumgrabber.util.NetUtil;
import java.util.Iterator;
import java.util.Vector;
import com.bluedragontavern.albumgrabber.Constants;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2002</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class DiscographyPage
{
	private String html = null;

	/**
	 * Constructor
	 */
	public DiscographyPage(String html)
		throws Exception
	{
		this.html = html;
	}

	/**
	 * Find the best matching album
	 * @param album DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Album getAlbum(Album album)
		throws Exception
	{
		Vector albumNames = new Vector();
		Vector albumUrls = new Vector();

		/*
			<td class="cell" style="width:160px;word-wrap:break-word;">
		 <a href="/cg/amg.dll?p=amg&sql=10:r1uk6jah71l0">Get Your Wings</a>
			</td>
		 */
		RE hits = new RE(
			"class=\"album-stars\".*?<td class=\"cell\" style=\".*?\"><a href=\"(.*?)\">(.*?)</a></td>");

		String albumName;
		String albumUrl;
		int index = 0;

		while (hits.match(html, index))
		{
			albumNames.add(hits.getParen(2));
			albumUrls.add(hits.getParen(1));
			index = hits.getParenEnd(2);

			if (Constants.DEBUG)
			{
				System.out.println("DiscographyPage:albumName = " +
										 albumNames.lastElement());
				System.out.println("DiscographyPage:albumUrl = " +
										 albumUrls.lastElement());
			}
		}

		//If no hits found, just return
		if (albumNames.size() == 0)
		{
			return album;
		}

		//Now we have to decide which is the CORRECT album!
		Vector indexScores = CompareStrings.findBestMatchingOrder(albumNames,
			album.getSearchAlbumName());
		Iterator iter = indexScores.iterator();

		while (iter.hasNext())
		{
			int bestMatch = ( (IndexScore) iter.next()).getIndex();
			Album bestMatchAlbum = new Album(album.getAlbumDir());
			bestMatchAlbum.setFoundAlbumName( (String) albumNames.elementAt(
				bestMatch));
			bestMatchAlbum.setAlbumUrl( (String) albumUrls.elementAt(bestMatch));

			//Get the URL to the album page
			URL url = new URL("http://www.allmusic.com" +
									bestMatchAlbum.getAlbumUrl());
			html = NetUtil.doGet(url, null);

			AlbumPage albumPage = new AlbumPage(html);
			bestMatchAlbum = albumPage.getAlbum(bestMatchAlbum);

			if (bestMatchAlbum.isFound())
			{
				return bestMatchAlbum;
			}
		}

		return album;
	}
}
