/**
 * Album Cover Grabber - Grabs album covers automatically off the internet
 * Copyright (C) 2002  Kevin M Schmidt     This program is free software; you
 * can redistribute it and/or modify     it under the terms of the GNU
 * General Public License as published by     the Free Software Foundation;
 * either version 2 of the License, or     (at your option) any later
 * version.     This program is distributed in the hope that it will be
 * useful,     but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     GNU
 * General Public License for more details.     You should have received a
 * copy of the GNU General Public License     along with this program; if
 * not, write to the Free Software     Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.google;

import javax.swing.*;

import com.bluedragontavern.albumgrabber.util.*;

public class Thumbnail
{
	String fullImageUrl = null;
	String thumbnailUrl = null;
	String sizeDescription = null;
	byte[] thumbnailBytes = null;
	byte[] fullImageBytes = null;

	/**
	 * Constructor
	 */
	public Thumbnail(String fullImageUrl, String thumbnailUrl,
						  String sizeDescription)
		throws Exception
	{
		this.fullImageUrl = fullImageUrl;
		this.thumbnailUrl = thumbnailUrl;
		this.sizeDescription = sizeDescription;

		//Get the thumbnail bytes right away
		thumbnailBytes = NetUtil.getImageBytes(thumbnailUrl);
	}

	/**
	 * Get the URL to the full image for this thumbnail
	 * @return
	 */
	public String getFullImageUrl()
	{
		return fullImageUrl;
	}

	/**
	 *
	 * @return
	 */
	public String getThumbnailUrl()
	{
		return thumbnailUrl;
	}

	/**
	 *
	 * @return
	 */
	public String getSizeDescription()
	{
		return sizeDescription;
	}

	/**
	 *
	 * @return
	 */
	public byte[] getThumbnailBytes()
	{
		return thumbnailBytes;
	}

	/**
	 *
	 * @return
	 * @throws Exception
	 */
	public byte[] getFullImageBytes()
		throws Exception
	{
		try
		{
			if (fullImageBytes == null)
			{
				fullImageBytes = NetUtil.getImageBytes(fullImageUrl);
			}
		}
		catch (Exception ex)
		{
			JOptionPane.showMessageDialog(null,
													"Full image not found: " +
													fullImageUrl, "Warning",
													JOptionPane.WARNING_MESSAGE);
		}

		return fullImageBytes;
	}
}