package com.bluedragontavern.albumgrabber.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.bluedragontavern.albumgrabber.google.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */
public class FullImageFrame
	extends JFrame implements ActionListener
{
	public FullImageFrame(Thumbnail thumbnail)
		throws Exception
	{
		setTitle("Full Image Display");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setLocation(300, 200);

		Image image = Toolkit.getDefaultToolkit().createImage(
			thumbnail.getFullImageBytes());
		ImagePanel ip = new ImagePanel(image);
		Container cp = getContentPane();
		cp.setLayout(new BorderLayout());
		cp.add(ip, BorderLayout.CENTER);

		JButton closeButton = new JButton("Close");
		closeButton.addActionListener(this);
		cp.add(closeButton, BorderLayout.SOUTH);
		pack();
		show();
	}

	public void actionPerformed(ActionEvent e)
	{
		dispose();
	}
}