/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.gui;

import java.awt.*;
import javax.swing.*;

/**
 * Panel containing an image
 */
public class ImagePanel
	extends JPanel
{
	Image image = null;

	/**
	 * Default Constructor
	 */
	public ImagePanel()
	{
	}

	/**
	 * Constructor
	 */
	public ImagePanel(Image image)
	{
		this.image = image;
		updateSize();
	}

	/**
	 * Set the current image
	 *
	 * @param image DOCUMENT ME!
	 */
	public void setImage(Image image)
	{
		this.image = image;
		updateSize();
	}

	/**
	 * Update the size
	 */
	private void updateSize()
	{
		ImageIcon ic = new ImageIcon(image);
		setPreferredSize(new Dimension(ic.getIconWidth(), ic.getIconHeight()));
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param g DOCUMENT ME!
	 */
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		g.clearRect(0, 0, 600, 600);
		g.drawImage(image, 0, 0, Color.white, this);
	}
}
