/**
 Album Cover Grabber - Grabs album covers automatically off the internet
 Copyright (C) 2002  Kevin M Schmidt

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.util;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Net Utilities
 */
public class NetUtil
{
	//User agent and pause time prevent us from being detected as a bot! ;v)
	private static String userAgent =
		"Mozilla/4.0 (compatible; MSIE 5.0; Windows 2000) Opera 6.03  [en]";
	private static long pauseTime = 500;

	/**
	 * Given a URL, return a String representation of the response
	 * @param url DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public static String doGet(URL url, Properties headers)
		throws Exception
	{
		URLConnection conn = url.openConnection();

		//Always set the User-Agent header, otherwise, we are detected as a bot
		conn.setRequestProperty("User-Agent", userAgent);

		//Set any requested headers
		if (headers != null)
		{
			Enumeration keys = headers.keys();

			while (keys.hasMoreElements())
			{
				String name = (String) keys.nextElement();
				String value = (String) headers.get(name);
				conn.setRequestProperty(name, value);
			}
		}

		StringBuffer sb = new StringBuffer();
		String line;
		BufferedReader in = new BufferedReader(new InputStreamReader(
			conn.getInputStream()));

		while ( (line = in.readLine()) != null)
		{
			sb.append(line);
		}

		in.close();

		//Delay so that we dont get detected as a bot
		Thread.sleep(pauseTime);

		return sb.toString();
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param url DOCUMENT ME!
	 * @param props DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public static String doPost(URL url, Properties props, Properties headers)
		throws Exception
	{
		URLConnection conn = url.openConnection();

		//Always set the User-Agent header, otherwise, we are detected as a bot
		conn.setRequestProperty("User-Agent", userAgent);

		//Set any requested headers
		if (headers != null)
		{
			Enumeration keys = headers.keys();

			while (keys.hasMoreElements())
			{
				String name = (String) keys.nextElement();
				String value = (String) headers.get(name);
				conn.setRequestProperty(name, value);
			}
		}

		conn.setDoOutput(true);

		PrintWriter out = new PrintWriter(conn.getOutputStream());
		Enumeration keys = props.keys();

		while (keys.hasMoreElements())
		{
			String name = (String) keys.nextElement();
			out.print(name + "=" + props.get(name));

			if (keys.hasMoreElements())
			{
				out.print("&");
			}
		}

		out.close();

		StringBuffer sb = new StringBuffer();
		String line;
		BufferedReader in = new BufferedReader(new InputStreamReader(
			conn.getInputStream()));

		while ( (line = in.readLine()) != null)
		{
			sb.append(line);
		}

		in.close();

		//Delay so that we dont get detected as a bot
		Thread.sleep(pauseTime);

		return sb.toString();
	}

	/**
	 * Given an URL to an image, get the bytes for it
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public static byte[] getImageBytes(String imageUrl)
		throws Exception
	{
		return getImageBytes(new URL(imageUrl));
	}

	/**
	 * Given an URL to an image, get the bytes for it
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public static byte[] getImageBytes(URL imageUrl)
		throws Exception
	{
		//Get the bytes from the url
		URLConnection conn = imageUrl.openConnection();

		//Always set the User-Agent header, otherwise, we are detected as a bot
		conn.setRequestProperty("User-Agent", userAgent);

		BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		//Read in the image bytes
		int bytesRead;
		byte[] buff = new byte[1024];

		while ( -1 != (bytesRead = bis.read(buff, 0, buff.length)))
		{
			baos.write(buff, 0, bytesRead);
		}

		//Delay so that we dont get detected as a bot
		Thread.sleep(pauseTime);

		return baos.toByteArray();
	}
}
