package dks.src.shadowEditor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;

import dks.src.utils.editor.CAbstractEditor;

/**
 * This class implement a PropertySheetTable editor for modifying a shadow <br> date : 4 sept. 07
 * @author   DarK Sidious
 */
public class JdksShadowEditorPane extends CAbstractEditor {

	private static final long serialVersionUID = -5658942756373271684L;

	public static final String SIZE_PROPERTY_NAME = "SizeProperty";
	public static final String DISTANCE_PROPERTY_NAME = "DistanceProperty";
	public static final String COLOR_PROPERTY_NAME = "ColorProperty";
	public static final String ANGLE_PROPERTY_NAME = "AngleProperty";
	public static final String OPACITY_PROPERTY_NAME = "OpacityProperty";
	public static final String VISIBLE_PROPERTY_NAME = "VisibleProperty";

	protected CShadow _shadowEditor;

	protected transient PropertyChange _propertyChangeListener;

	/**
	 * @param shadow the shadow to use
	 */
	public JdksShadowEditorPane(CShadow shadow) {
		_shadowEditor = shadow;
		_propertyChangeListener = new PropertyChange();
		init();
	}

	protected final void init() {
		addPropertySheetChangeListener(_propertyChangeListener);
		reloadModel();
	}

	/**
	 * @return the shadow to use
	 */
	public CShadow getEditor() {
		return _shadowEditor;
	}

	/**
	 * @param shadowEditor the shadow to use
	 */
	public void setEditor(CShadow shadowEditor) {
		_shadowEditor = shadowEditor;
	}

	/**
	 * Reload the properties of the table with the properties of the shadow
	 */
	public void reloadModel() {
		setProperties(new DefaultProperty[0]);
		final DefaultProperty visibleProperty = (DefaultProperty) createProperty("Visible", "Visibilit de l'ombre", Boolean.class, _shadowEditor.isVisible(), VISIBLE_PROPERTY_NAME);
		addProperty(visibleProperty);
		final DefaultProperty sizeProperty = (DefaultProperty) createProperty("Taille", "Taille de l'ombre", Integer.class, _shadowEditor.getSize(), SIZE_PROPERTY_NAME);
		addProperty(sizeProperty);
		final DefaultProperty distanceProperty = (DefaultProperty) createProperty("Distance", "Distance de l'ombre", Integer.class, _shadowEditor.getDistance(), DISTANCE_PROPERTY_NAME);
		addProperty(distanceProperty);
		final DefaultProperty colorProperty = (DefaultProperty) createProperty("Couleur", "Couleur de l'ombre", Color.class, _shadowEditor.getColor(), COLOR_PROPERTY_NAME);
		addProperty(colorProperty);
		final DefaultProperty angleProperty = (DefaultProperty) createProperty("Angle", "Angle de l'ombre", Integer.class, _shadowEditor.getAngle(), ANGLE_PROPERTY_NAME);
		addProperty(angleProperty);
		final DefaultProperty opacityProperty = (DefaultProperty) createProperty("Opacit", "Opacit de l'ombre", Float.class, _shadowEditor.getOpacity(), OPACITY_PROPERTY_NAME);
		addProperty(opacityProperty);
	}

	protected void change(Property property) {
		final String name = property.getName();
		if (SIZE_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setSize((Integer) property.getValue());
		} else if (DISTANCE_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setDistance((Integer) property.getValue());
		} else if (ANGLE_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setAngle((Integer) property.getValue());
		} else if (OPACITY_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setOpacity((Float) property.getValue());
		} else if (COLOR_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setColor((Color) property.getValue());
		} else if (VISIBLE_PROPERTY_NAME.equals(name)) {
			_shadowEditor.setVisible((Boolean) property.getValue());
		}
		for (PropertyChangeListener listener : _listeners) {
			if (!(listener instanceof PropertyChange)) {
				listener.propertyChange(new PropertyChangeEvent(property, property.getName(), property.getValue(), property.getValue()));
			}
		}
	}

	protected class PropertyChange implements PropertyChangeListener {
		public void propertyChange(PropertyChangeEvent arg0) {
			if (arg0.getSource() instanceof Property) {
				change((Property) arg0.getSource());
			}
		}
	}

	public String toString() {
		return "src.dks.shadowEditor.JdksShadowEditorPane[shadow=" + _shadowEditor + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_propertyChangeListener = new PropertyChange();
		return this;
	}
}
