package dks.src.textureEditor;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;

//$ANALYSIS-IGNORE,codereview.java.rules.cloneable.RuleCloneableOverrideClone
/** 
 * This class implements a filter for renderer the transparence of an image
 * <br>
 * date : 4 sept. 07
 * @author DarK Sidious
 */
public class CMaskFilter extends RGBImageFilter implements Serializable {
	private static final long serialVersionUID = 6883540200855485662L;

	/** 
	 * @see java.awt.image.RGBImageFilter#filterRGB(int,int,int)
	 * @param x the x position of the pixel
	 * @param y the y position of the pixel
	 * @param rgb the color of the pixel
	 * @return the rgba of the pixel
	 */
	public int filterRGB(int x, int y, int rgb) {
		final int r = (rgb & 0x00FF0000) >> 16;
		final int g = (rgb & 0x0000FF00) >> 8;
		final int b = (rgb & 0x000000FF) >> 0;
		final int a = r;
		return (a << 24 | (r << 16) | (g << 8) | (b));
	}

	@Override
	public CMaskFilter clone() {
		return (CMaskFilter) super.clone();
	}

	public String toString() {
		return "dks.src.textureEditor.CMaskFilter[]";
	}
}
