/**
 * @author DarK Sidious
 * @version 1.0.0
 */
package dks.src.utils.listener;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * This class is an adaptor for the ChangeListener : facilitate the development of a class which implements Changeable
 * <br>
 * date : 2 dc. 07
 * @author DarK Sidious
 */
public class CChangeListenerDelegate extends CListenerDelegate<ChangeListener> {
	/**
	 * Notify the listeners that the object have changed
	 *
	 */
	public void notifyChanged() {
		if (_listeners != null) {
			for (ChangeListener listener : _listeners) {
				if (listener != null) {
					listener.stateChanged(new ChangeEvent(this));
				}
			}
		}
	}
}
