/**
 * @author DarK Sidious
 * @version 1.0.0
 */
package dks.src.utils.listener;



/**
 * This interface represent an object which implement a listener
 * <br>
 * date : 2 dc. 07
 * @author DarK Sidious
 */
public interface Listenable<T> {
	/**
	 * Add a listener to the list
	 * @param listener the listener to add
	 */
	public void addListener(T listener);
	
	/**
	 * Remove a listener to the list
	 * @param listener the listener to remove
	 */
	public void removeListener(T listener);
}
