package dks.src.warpEditor;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jdom.Element;

import dks.src.utils.XML.XMLWritable;
import dks.src.utils.listener.CChangeListenerDelegate;

//$ANALYSIS-IGNORE,codereview.java.rules.cloneable.RuleCloneableOverrideClone
/**
 * This class implements a list of CPoint which can be saved in a XML format <br> date : 5 sept. 07
 * @author   DarK Sidious
 */
public class CPoints extends ArrayList<CPoint> implements XMLWritable {

	private static final long serialVersionUID = -994320310227251842L;

	public static final String XML_POINTS_PROPERTY = "point";

	protected transient Change _changeListener;
	protected transient CChangeListenerDelegate _changeListenerDelegate;

	public CPoints() {
		super();
		_changeListener = new Change();
		_changeListenerDelegate = new CChangeListenerDelegate();
	}

	/**
	 * @param size the size of the list
	 */
	public CPoints(int size) {
		this();
		init(size);
	}

	protected void init(int size) {
		for (int i = 0; i < size; i++) {
			CPoint point = new CPoint();
			point.addChangeListener(_changeListener);
			add(point);
		}
	}

	/* (non-Javadoc)
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	@Override
	public boolean add(CPoint point) {
		point.addChangeListener(_changeListener);
		return super.add(point);
	}

	/* (non-Javadoc)
	 * @see java.util.ArrayList#add(int, java.lang.Object)
	 */
	@Override
	public void add(int index, CPoint point) {
		point.addChangeListener(_changeListener);
		super.add(index, point);
	}

	/* (non-Javadoc)
	 * @see java.util.ArrayList#addAll(java.util.Collection)
	 */
	@Override
	public boolean addAll(Collection<? extends CPoint> points) {
		for(CPoint point : points) {
			point.addChangeListener(_changeListener);
		}
		return super.addAll(points);
	}

	/* (non-Javadoc)
	 * @see java.util.ArrayList#addAll(int, java.util.Collection)
	 */
	@Override
	public boolean addAll(int index, Collection<? extends CPoint> points) {
		for(CPoint point : points) {
			point.addChangeListener(_changeListener);
		}
		return super.addAll(index, points);
	}

	/* (non-Javadoc)
	 * @see java.util.ArrayList#set(int, java.lang.Object)
	 */
	@Override
	public CPoint set(int index, CPoint point) {
		point.addChangeListener(_changeListener);
		return super.set(index, point);
	}

	/**
	 * @param listener
	 * @see dks.src.utils.listener.CListenerDelegate#addListener(java.lang.Object)
	 */
	public void addListener(ChangeListener listener) {
		_changeListenerDelegate.addListener(listener);
	}

	/**
	 *
	 * @see dks.src.utils.listener.CChangeListenerDelegate#notifyChanged()
	 */
	public void notifyChanged() {
		_changeListenerDelegate.notifyChanged();
	}

	/**
	 * @see dks.src.utils.XML.XMLWritable#XMLload(org.jdom.Element)
	 * @param root the XML DOM Element used to load the list of points
	 */
	@SuppressWarnings("unchecked")
	public void XMLload(Element root) {
		int i = 0;
		for (Element element : (List<Element>) root
				.getChildren(XML_POINTS_PROPERTY)) {
			get(i).XMLload(element);
			i++;
		}
	}

	/**
	 * @see dks.src.utils.XML.XMLWritable#XMLsave(org.jdom.Element)
	 * @param root the XML DOM Element used to save the list of points
	 */
	public void XMLsave(Element root) {
		for (CPoint points : this) {
			Element pointsElement = new Element(XML_POINTS_PROPERTY);
			root.addContent(pointsElement);
			points.XMLsave(pointsElement);
		}
	}

	public CPoints clone() {
		return (CPoints) super.clone();
	}

	public String toString() {
		String result;
		result = "dks.src.warpEditor.CPoints[";
		int index = 0;
		for (final CPoint point : this) {
			if (index > 0) {
				result += ",";
			}
			result += "point" + index + "=" + point;
			index++;
		}
		result += "]";
		return result;
	}

	protected class Change implements ChangeListener {
		public void stateChanged(ChangeEvent arg0) {
			_changeListenerDelegate.notifyChanged();
		}
	}

	protected Object readResolve() throws ObjectStreamException {
		_changeListener = new Change();
		_changeListenerDelegate = new CChangeListenerDelegate();
		return this;
	}
}
