package dks.src.warpEditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;

import dks.src.utils.editor.CAbstractEditor;

/**
 * This class implements a PropertySheetTable editor for modifying a warp object <br> date : 5 sept. 07
 * @author   DarK Sidious
 */
public class JdksWarpEditorPane extends CAbstractEditor {

	private static final long serialVersionUID = 7451025342876519301L;

	public static final String PROPERTY_POINTS_NUMBER_X = "propertyPointsNumberX";
	public static final String PROPERTY_POINTS_NUMBER_Y = "propertyPointsNumberY";
	public static final String PROPERTY_ACTIVE_NAME = "propertyActive";

	protected CWarp _warpEditor;
	protected transient PropertyChange _propertyChangeListener;

	/**
	 * @param warp
	 *            the warp to use
	 */
	public JdksWarpEditorPane(CWarp warp) {
		_warpEditor = warp;
		_propertyChangeListener = new PropertyChange();
		init();
	}

	protected final void init() {
		reloadModel();
		addPropertySheetChangeListener(_propertyChangeListener);
	}

	/**
	 * @return the warp to use
	 */
	public CWarp getWarpEditor() {
		return _warpEditor;
	}

	/**
	 * @param warpEditor
	 *            the warp to use
	 */
	public void setWarpEditor(CWarp warpEditor) {
		_warpEditor = warpEditor;
	}

	/**
	 * Reload the PropertySheetTable with the properties of the warp
	 */
	public void reloadModel() {
		setProperties(new DefaultProperty[0]);
		Property active = createProperty("Activ", "Activit du warp", Boolean.class, _warpEditor.isActive(), PROPERTY_ACTIVE_NAME);
		addProperty(active);
		final Property pointsNumberPropertyX = createProperty("Nombre de points d'attaches X", "Nombre de points d'attaches sur l'axe horizontal", Integer.class, _warpEditor.getColNumber(), PROPERTY_POINTS_NUMBER_X);
		((DefaultProperty) pointsNumberPropertyX).setEditable(false);
		addProperty(pointsNumberPropertyX);
		final Property pointsNumberPropertyY = createProperty("Nombre de points d'attaches Y", "Nombre de points d'attaches sur l'axe vertical", Integer.class, _warpEditor.getLineNumber(), PROPERTY_POINTS_NUMBER_Y);
		((DefaultProperty) pointsNumberPropertyY).setEditable(false);
		addProperty(pointsNumberPropertyY);
	}

	/**
	 * Change the warp with the modified property
	 *
	 * @param property
	 *            the property which has changed
	 */
	protected void change(Property property) {
		final String name = property.getName();
		if (PROPERTY_ACTIVE_NAME.equals(name)) {
			_warpEditor.setActive((Boolean) property.getValue());
		}
		for (PropertyChangeListener listener : _listeners) {
			if (!(listener instanceof PropertyChange)) {
				listener.propertyChange(new PropertyChangeEvent(property, property.getName(), property.getValue(), property.getValue()));
			}
		}
	}

	protected class PropertyChange implements PropertyChangeListener {
		public void propertyChange(PropertyChangeEvent arg0) {
			if (arg0.getSource() instanceof Property) {
				change((Property) arg0.getSource());
			}
		}
	}

	public String toString() {
		return "dks.src.warpEditor.JdksWarpEditorPane[warp=" + _warpEditor + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_propertyChangeListener = new PropertyChange();
		return this;
	}
}
