package typecontrol.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

import typecontrol.CTypeControl;
import typecontrol.IdksTypeControl;
import typecontrol.tools.AutoCompletion;

public class JdksComboBox extends JComponent implements IdksTypeControl {

	private static final long serialVersionUID = -4795761055230567364L;
	
	private GUI _gui;
	
	private Action _action;
	private Change _change;
	private Focus _focus;
	
	private boolean _numericValue;
	private Color _normalBackground;
	private CTypeControl _typeControl;
	
	public JdksComboBox(String label, String info) {
		super();
		initialize(label, info);
	}
	
	public JdksComboBox(String label) {
		super();
		initialize(label, "");
	}
	
	private void initialize(String label, String info) {
		_typeControl = new CTypeControl();
		setFocusBackground(CTypeControl.FOCUS_COLOR);
		_typeControl.setInfo(info);
		_typeControl.setLabel(label);
		_focus = new Focus();
		_action = new Action();
		_change = new Change();
		_gui = new GUI();
		
		new AutoCompletion(_gui.getCmbControl());
	}
		
	public void setNumericValue(boolean numericValue) {
		_numericValue = numericValue;
	}
	
	public void setValue(String value) {
		if (!_numericValue) {
			_gui.getCmbControl().setSelectedItem(value);
		} else {
			_gui.getCmbControl().setSelectedIndex(Integer.parseInt(value));
		}
	}
	
	public String getValue() {
		if (_gui.getCmbControl().getItemCount() > 0) {
			if (!_numericValue) {
				return (String) _gui.getCmbControl().getSelectedItem().toString();
			}
			else {
				return ((Integer) _gui.getCmbControl().getSelectedIndex()).toString();
			}
		}
		return "";
	}
				
	public void setInfo(String info) {
		_typeControl.setInfo(info);
		_gui.rebuildGUI();
	}
	
	public void setLabel(String label) {
		_typeControl.setLabel(label);
		_gui.rebuildGUI();
	}
	
	public void setNormalBackground(Color background) {
		_normalBackground = background;
		_gui.getCmbControl().setBackground(background);
	}
	
	public void addItem(String item) {
		Item newItem = new Item(item, "");
		_gui.getCmbControl().addItem(newItem);
	}
	
	public void addItem(String item, String data) {
		Item newItem = new Item(item, data);
		_gui.getCmbControl().addItem(newItem);
	}
	
	public void removeItem(Integer item) {
		_gui.getCmbControl().remove(item);
	}
		
	public void clear() {
		_gui.getCmbControl().removeAllItems();
	}
	
	public Item getItem(Integer item) {
		return (Item) _gui.getCmbControl().getItemAt(item);
	}
	
	public Item getSelectedItem() {
		return (Item) _gui.getCmbControl().getSelectedItem();
	}
		
	public void setEditable(Boolean editable) {
		_gui.getCmbControl().setEditable(editable);
	}
		
	public void loadFromResultSet(ResultSet result, String field, String idField) {
		try {
			result.first();
			Boolean id = idField != null && !idField.equals("");
			while (!result.isAfterLast()) {
				try {
					String value = result.getObject(field).toString();
					String item = "";
					if (id) {
						item = result.getObject(idField).toString();
					}
					Item newItem = new Item(value, item);
					_gui.getCmbControl().addItem(newItem);
					result.next();
				} catch (SQLException e) {}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	public void setEnabled(Boolean enabled) {
		_gui.getCmbControl().setEnabled(enabled);
	}
	
	public boolean isEnabled() {
		if (_gui != null) {
			return _gui.getCmbControl().isEnabled();
		} else {
			return true;
		}
	}
	
	public JComboBox getControl() {
		return _gui.getCmbControl();
	}
	
	private void cmbControl_Click() {
		raiseChangeListener(this);
	}
	
	private class GUI {
		protected static final String CMB_CONTROL = "cmbControl";
		
		private final Dimension TXT_DEFAULT_SIZE = new Dimension(100, 20);
		
		private JComboBox _cmbControl;
		private JPanel _panButtons;
		
		public GUI() {
			rebuildGUI();
		}
		
		protected void rebuildGUI() {
			setLayout(new BorderLayout());
			removeAll();
			if (_typeControl.getLabel() != null && !_typeControl.getLabel().equals("")) {
				add(getLabLabel(), BorderLayout.WEST);
			}
			
			add(getCmbControl(), BorderLayout.CENTER);
			getCmbControl().addFocusListener(_focus);

			_panButtons = null;
			add(getPanButtons(), BorderLayout.EAST);
			updateUI();
		}
						
		protected JComboBox getCmbControl() {
			if (_cmbControl == null) {
				_cmbControl = new JComboBox();
				_cmbControl.setPreferredSize(TXT_DEFAULT_SIZE);
				_cmbControl.setEditable(true);
				_cmbControl.setName(CMB_CONTROL);
				_cmbControl.addActionListener(_action);
				_cmbControl.addItemListener(_change);
			}
			return _cmbControl;
		}
		
		protected JPanel getPanButtons() {
			if (_panButtons == null) {
				_panButtons = new JPanel();
				_panButtons.setLayout(new BorderLayout());
				if (_typeControl.getInfo() != null && !_typeControl.getInfo().equals("")) {
					_panButtons.add(getBtnInfo(), BorderLayout.EAST);
				}
			}
			return _panButtons;
		}
	
	}
	
	private class Change implements ItemListener {
		public void itemStateChanged(ItemEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(GUI.CMB_CONTROL)) {
				if (arg0.getStateChange() == ItemEvent.SELECTED) {
					cmbControl_Click();
				}
			}
		}
	}
	
	private class Action implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(GUI.CMB_CONTROL)) {
				cmbControl_Click();
			}
		}
	}
	
	private class Focus implements FocusListener {		
		public Focus() {
			super();
		}
		
		public void focusGained(FocusEvent arg0) {
			if (_typeControl.getFocusBackground() != null) {
				_gui.getCmbControl().setBackground(_typeControl.getFocusBackground());
			}
		}

		public void focusLost(FocusEvent arg0) {
			if (_typeControl.getFocusBackground() != null) {
				_gui.getCmbControl().setBackground(_normalBackground);
			}
		}
	}

	public class Item {
		private String _value;
		private String _data;
		
		public Item(String value, String data) {
			_value = value;
			_data = data;
		}
		
		public void setValue(String value) {
			_value = value;
		}
		
		public String getValue() {
			return _value;
		}
		
		public void setData(String data) {
			_data = data;
		}
		
		public String getData() {
			return _data;
		}
	
		public String toString() {
			return _value;
		}
	}

	public void addChangeListener(ChangeListener changeListener) {
		_typeControl.addChangeListener(changeListener);
	}

	public JButton getBtnInfo() {
		return _typeControl.getBtnInfo();
	}

	public Color getFocusBackground() {
		return _typeControl.getFocusBackground();
	}

	public String getInfo() {
		return _typeControl.getInfo();
	}

	public String getLabel() {
		return _typeControl.getLabel();
	}

	public JLabel getLabLabel() {
		return _typeControl.getLabLabel();
	}

	public boolean isLabelled() {
		return _typeControl.isLabelled();
	}

	public void raiseChangeListener(IdksTypeControl source) {
		_typeControl.raiseChangeListener(source);
	}

	public void removeChangeListener(ChangeListener changeListener) {
		_typeControl.removeChangeListener(changeListener);
	}

	public void setFocusBackground(Color focusBackground) {
		_typeControl.setFocusBackground(focusBackground);
	}

	public void setLabelAlignment(int alignment) {
		_typeControl.setLabelAlignment(alignment);
	}

	public void setLabelWidth(int width) {
		_typeControl.setLabelWidth(width);
	}
}
