package typecontrol.tools;

import java.awt.Color;
import java.util.Date;
import java.util.GregorianCalendar;

public class CCommon {

	public static Date getDateFromString(String date) {
		GregorianCalendar calendar = new GregorianCalendar();
		String dates[] = date.split("/");
		if (dates.length != 3) {
			return null;
		}
		calendar.set(GregorianCalendar.DAY_OF_MONTH, Integer.parseInt(dates[0]));
		calendar.set(GregorianCalendar.MONTH, Integer.parseInt(dates[1]) - 1);
		if (dates[2].length() < 4) {
			calendar.set(GregorianCalendar.YEAR, Integer.parseInt(dates[2]) + 2000);
		} else {
			calendar.set(GregorianCalendar.YEAR, Integer.parseInt(dates[2]));
		}
		return calendar.getTime();
	}
	
	public static Color getColorFromString(String color) {
		String temp = color.replace("RGB(", "");
		temp = temp.replace(")", "");
		String composantes[] = temp.split(",");
		return new Color(Integer.parseInt(composantes[0]), Integer.parseInt(composantes[1]), Integer.parseInt(composantes[2]), Integer.parseInt(composantes[3]));
	}
}
