/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.helpers;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.helpers.NumericDocument;
import java.text.DecimalFormatSymbols;

public class DecimalDocument
extends NumericDocument {
    private boolean _allowExponentialValue = false;
    private boolean _useFractionDigits = true;

    public DecimalDocument(boolean useErrorSound) {
        super(useErrorSound, -1);
        this.setAllowExponentialValue(false);
    }

    public DecimalDocument(boolean useErrorSound, short whiteSpaceType) {
        this(useErrorSound);
        this._whiSpaType = whiteSpaceType;
        this.setAllowExponentialValue(false);
    }

    public void parse(String proposedResult) throws NumberFormatException {
        double value = 0.0;
        if (proposedResult.endsWith("d") || proposedResult.endsWith("f")) {
            throw new NumberFormatException();
        }
        char groupingSeparator = this.getDecimalSymbols().getGroupingSeparator();
        if (!StringUtil.checkDistance((String)proposedResult, (char)groupingSeparator, (int)4)) {
            throw new NumberFormatException();
        }
        if ((proposedResult = TextTools.convertNumbersToNative((String)proposedResult, (DecimalFormatSymbols)this.getDecimalSymbols())).length() != 0) {
            if (this.isIntDocument() && this.getTotalDigit() >= 0 && proposedResult.length() > this.getTotalDigit()) {
                throw new NumberFormatException();
            }
            if (!this.useFractionDigits() && proposedResult.lastIndexOf(".") != -1) {
                throw new NumberFormatException();
            }
            if (proposedResult.equals(".") || this.getMinValue() < 0.0 && proposedResult.equals("-") || this.getMaxValue() >= 0.0 && proposedResult.equals("+")) {
                return;
            }
            if (this.allowExponentialValue() && proposedResult != null && (proposedResult.toLowerCase().endsWith("e") || proposedResult.toLowerCase().endsWith("e-"))) {
                proposedResult = proposedResult + "1";
            }
            if (Double.isInfinite(value = Double.parseDouble(proposedResult))) {
                throw new NumberFormatException();
            }
        }
    }

    protected boolean allowExponentialValue() {
        return this._allowExponentialValue;
    }

    protected void setAllowExponentialValue(boolean allowExponentialValue) {
        this._allowExponentialValue = allowExponentialValue;
    }

    protected boolean useFractionDigits() {
        return this._useFractionDigits;
    }

    protected void setUseFractionDigits(boolean useFractionDigits) {
        this._useFractionDigits = useFractionDigits;
    }
}

