/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.helpers;

import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.helpers.JAXFrontDocument;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class StringDocument
extends PlainDocument
implements JAXFrontDocument {
    private boolean _bypass = false;
    private boolean _useErrorSound = true;
    private long _maxLengthOfCharacter = -1L;
    private int _whiSpaType = -1;

    public StringDocument(boolean useErrorSound, long maxLengthOfCharacter) {
        this._useErrorSound = useErrorSound;
        this._maxLengthOfCharacter = maxLengthOfCharacter;
    }

    public StringDocument(boolean useErrorSound, long maxLengthOfCharacter, int whiteSpaceType) {
        this(useErrorSound, maxLengthOfCharacter);
        this._whiSpaType = whiteSpaceType;
    }

    public void insertString(int offset, String string, AttributeSet attributeSet) throws BadLocationException {
        block10: {
            if (this.isBypassing()) {
                super.insertString(offset, string, attributeSet);
                return;
            }
            try {
                if (this._maxLengthOfCharacter == -1L) {
                    super.insertString(offset, string, attributeSet);
                } else if (string != null) {
                    String textContent = this.getText(0, this.getLength());
                    int contLength = this.getLength();
                    if (textContent != null) {
                        contLength = TextTools.applyWhiteSpaceRestriction((String)textContent, (int)this._whiSpaType).length();
                    }
                    if ((long)(contLength + string.length()) <= this._maxLengthOfCharacter) {
                        super.insertString(offset, string, attributeSet);
                    } else if (this._useErrorSound) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
            catch (Exception ex) {
                if (!this._useErrorSound) break block10;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean isBypassing() {
        return this._bypass;
    }

    public void setBypassing(boolean bypass) {
        this._bypass = bypass;
    }
}

