/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class SimplePrintableArea
implements Printable {
    private MediaPrintableArea defaultPrintableArea = new MediaPrintableArea(15.0f, 15.0f, 187.0f, 267.0f, 1000);
    private JComponent _printComponent = null;

    public SimplePrintableArea(JComponent printComponent) {
        this._printComponent = printComponent;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.simplePrint(graphics, pageFormat, pageIndex);
    }

    public int simplePrint(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this.getPrintComponent()).setDoubleBufferingEnabled(false);
        Dimension d = this.getPrintComponent().getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.getPrintComponent().paint(g2);
        return 0;
    }

    private JComponent getPrintComponent() {
        return this._printComponent;
    }
}

