/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.swing.ui.editor.EditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.JPanel;

public class EditorPanelBean
extends JPanel
implements Visualizer {
    protected URL _xsdUrl;
    protected URL _xmlUrl;
    protected URL _xuiUrl;
    protected String _root;
    private Type _model;
    private Document _dom;
    private EditorPanel _editorPanel;
    private boolean _uiReleased;

    public EditorPanelBean() {
        this((Document)null);
    }

    public EditorPanelBean(Document dom) {
        this._dom = dom;
        this.populateView();
    }

    public EditorPanelBean(URL xsdUrl) {
        this(xsdUrl, null);
    }

    public EditorPanelBean(URL xsdUrl, URL xmlUrl) {
        this(xsdUrl, xmlUrl, null);
    }

    public EditorPanelBean(URL xsdUrl, URL xmlUrl, URL xuiUrl) {
        this(xsdUrl, xmlUrl, xuiUrl, null);
    }

    public EditorPanelBean(URL xsdUrl, URL xmlUrl, URL xuiUrl, String root) {
        this._xsdUrl = xsdUrl;
        this._xmlUrl = xmlUrl;
        this._xuiUrl = xuiUrl;
        this._root = root;
        if (this._xsdUrl != null) {
            this.populateView();
        }
    }

    public EditorPanelBean(String xsdPath, String xmlPath, String xuiPath, String root) {
        try {
            this._xsdUrl = URLHelper.getUserURL((String)xsdPath);
            if (xmlPath != null && xmlPath.length() > 0) {
                this._xmlUrl = URLHelper.getUserURL((String)xmlPath);
            }
            if (xuiPath != null && xuiPath.length() > 0) {
                this._xuiUrl = URLHelper.getUserURL((String)xuiPath);
            }
            if (root != null && root.length() > 0) {
                this._root = root;
            }
            if (this._xsdUrl != null) {
                this.populateView();
            }
        }
        catch (Exception ex) {
            LogRegistry.getInstance().error(this.getClass(), ex);
        }
    }

    public URL getXsdUrl() {
        return this._xsdUrl;
    }

    public URL getXmlUrl() {
        return this._xmlUrl;
    }

    public URL getXuiUrl() {
        return this._xuiUrl;
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    public void setXsdUrl(URL xsdUrl) {
        this._xsdUrl = xsdUrl;
    }

    public void setXmlUrl(URL xmlUrl) {
        this._xmlUrl = xmlUrl;
    }

    public void setXuiUrl(URL xuiUrl) {
        this._xuiUrl = xuiUrl;
    }

    public Document getDom() {
        if (this._dom == null) {
            this.initializeDom();
        }
        return this._dom;
    }

    public int getRendererType() {
        return 1;
    }

    public void initializeDom() {
        if (this.getXsdUrl() != null) {
            try {
                this._dom = DOMBuilder.getInstance().build(null, this.getXsdUrl(), this.getXmlUrl(), this.getXuiUrl(), this.getRoot());
            }
            catch (DocumentCreationException ex) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)((Object)ex));
            }
        }
    }

    public String getLabelText() {
        return null;
    }

    public Type getModel() {
        return this._model;
    }

    public void jumpTo() {
    }

    public void markError() {
    }

    public void populateModel() {
    }

    public void populateView() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.getDom() != null) {
            this._editorPanel = new EditorPanel(this.getDom().getRootType(), null);
            if (this.getModel() != null) {
                this._editorPanel.setPreferredSize(this.getModel().getDOM().getGlobalDefinition().getScreenSize());
            }
            this._editorPanel.setBorder(null);
            this._editorPanel.getWorkspace().setBorder(null);
            this._editorPanel.getNavigationTree().setBorder(null);
            this.add((Component)this._editorPanel, "Center");
        }
    }

    public void removeWorkspace() {
        if (this._editorPanel != null) {
            this._editorPanel.removeWorkspace();
        }
    }

    public void postInitialization() {
    }

    public void release() {
        this.removeAll();
        this._model = null;
        this._xsdUrl = null;
        this._xmlUrl = null;
        this._xuiUrl = null;
        this._root = null;
        this._dom = null;
    }

    public void removeLabel() {
    }

    public void resetError() {
    }

    public void setApplicationRequired(boolean required) {
    }

    public void setEditable(boolean enabled) {
        if (this.getDom() != null) {
            this.getDom().setImmutable(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setLabelColor(Color color) {
    }

    public void setModel(Type type) {
        if (this._model != type && type != null) {
            this._model = type;
            this.populateView();
        }
    }

    public void setRequired(boolean required) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void showLabel(boolean show) {
    }

    public Visualizer getImplementation() {
        return this;
    }

    public Type getContext() {
        return null;
    }

    public void setContext(Type type) {
    }

    public void setLabelText(String text) {
    }

    public void doUserSerialization(boolean show) {
    }

    public boolean isViewReleased() {
        return this._uiReleased;
    }
}

