/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.BrowserControl;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeStringView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class HelpLauncherView
extends AbstractSimpleTypeView
implements ActionListener {
    private SimpleTypeStringView _simpleTypeStringView;
    private String _baseURL;

    public HelpLauncherView() {
        this((String)null);
    }

    public HelpLauncherView(String baseURL) {
        this._baseURL = baseURL;
    }

    protected JComponent createEditorComponent() {
        String baseURL;
        this._simpleTypeStringView = new SimpleTypeStringView((SimpleType)this.getModel(), this.getModel());
        if (this._baseURL != null && (baseURL = (String)this.getModel().getDOM().getApplicationProperty(this._baseURL)) != null) {
            this._baseURL = baseURL;
        }
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.setFirstFocusableComponent(this._simpleTypeStringView.getEditorComponent());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        JButton launchButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_open", "Open"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/openFile_16x16.gif"));
        launchButton.addActionListener(this);
        buttonPanel.add((Component)launchButton, "North");
        editorPanel.add((Component)this._simpleTypeStringView.getEditorComponent(), "Center");
        editorPanel.add((Component)buttonPanel, "East");
        this._editorComponent = editorPanel;
        this.setEditorField(this._simpleTypeStringView.getEditorField());
        return this._editorComponent;
    }

    public String getText() {
        return ((JTextComponent)this._simpleTypeStringView.getEditorField()).getText();
    }

    public void populateView() {
        String value = this.getValue();
        if (value == null) {
            value = "";
        }
        this.setText(value);
    }

    private void setText(String value) {
        if (value != null) {
            ((JTextComponent)this._simpleTypeStringView.getEditorField()).setText(value);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String url = this.getText();
        if (this._baseURL != null) {
            url = !this._baseURL.endsWith("/") && this.getText() != null && !this.getText().startsWith("/") ? this._baseURL + "/" + this.getText() : this._baseURL + this.getText();
        }
        BrowserControl.displayURL((String)url);
    }

    private String getValue() {
        if (this.getModel() != null) {
            return ((SimpleType)this.getModel()).getValue();
        }
        return null;
    }
}

