/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.swing.ui.beans.JDayChooser;
import com.jaxfront.swing.ui.beans.JMonthChooser;
import com.jaxfront.swing.ui.beans.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendar
extends JPanel
implements PropertyChangeListener {
    private JYearChooser _yearChooser = null;
    private JMonthChooser _monthChooser = null;
    private JDayChooser _dayChooser = null;
    private Calendar _calendar;
    private Locale _locale = Locale.getDefault();
    private boolean _initialized = false;

    public JCalendar() {
        this._calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new GridLayout(1, 2));
        this._monthChooser = new JMonthChooser();
        myPanel.add(this._monthChooser);
        this._yearChooser = new JYearChooser();
        myPanel.add(this._yearChooser);
        this._dayChooser = new JDayChooser();
        this._dayChooser.addPropertyChangeListener(this);
        this._monthChooser.setDayChooser(this._dayChooser);
        this._monthChooser.addPropertyChangeListener(this);
        this._yearChooser.setDayChooser(this._dayChooser);
        this._yearChooser.addPropertyChangeListener(this);
        this.add((Component)myPanel, "North");
        this.add((Component)this._dayChooser, "Center");
        this._initialized = true;
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public JMonthChooser getMonthChooser() {
        return this._monthChooser;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getName() {
        return "JCalendar";
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JCalendar");
        frame.getContentPane().add(new JCalendar());
        frame.pack();
        frame.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this._calendar != null) {
            Calendar c = (Calendar)this._calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                if ((Integer)evt.getOldValue() != 0) {
                    this.setCalendar(c, true, true);
                } else {
                    this.setCalendar(c, false, true);
                }
            } else if (evt.getPropertyName().equals("month")) {
                c.set(2, (Integer)evt.getNewValue());
                this.setCalendar(c, true, false);
            } else if (evt.getPropertyName().equals("year")) {
                c.set(1, (Integer)evt.getNewValue());
                this.setCalendar(c, true, false);
            }
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this._dayChooser != null) {
            this._dayChooser.setBackground(bg);
        }
    }

    public void setCalendar(Calendar c) {
        this.setCalendar(c, true, true);
    }

    private void setCalendar(Calendar c, boolean update, boolean closeWindow) {
        if (c != null) {
            Calendar oldCalendar = this._calendar;
            this._calendar = c;
            if (update) {
                this._yearChooser.setYear(c.get(1));
                this._monthChooser.setMonth(c.get(2));
                this._dayChooser.setDay(c.get(5), false);
            }
            this.firePropertyChange("calendar", new Boolean(closeWindow), this._calendar);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._dayChooser != null) {
            this._dayChooser.setFont(font);
            this._monthChooser.setFont(font);
            this._yearChooser.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this._dayChooser != null) {
            this._dayChooser.setForeground(fg);
            this._monthChooser.setForeground(fg);
            this._yearChooser.setForeground(fg);
        }
    }

    public void setLocale(Locale l) {
        if (!this._initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this._locale;
            this._locale = l;
            this._dayChooser.setLocale(this._locale);
            this._monthChooser.setLocale(this._locale);
            this.firePropertyChange("locale", oldLocale, this._locale);
        }
    }

    public void release() {
        if (this._dayChooser != null) {
            this._dayChooser.removePropertyChangeListener(this);
        }
        if (this._monthChooser != null) {
            this._monthChooser.removePropertyChangeListener(this);
        }
        if (this._yearChooser != null) {
            this._yearChooser.removePropertyChangeListener(this);
        }
    }
}

