/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJList;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ListSelectionComponent
extends JPanel
implements ActionListener,
FocusListener,
MouseListener {
    private JAXJList _unassignedValuesList;
    private JAXJList _assignedValuesList;
    private JAXJButton _moveFromLeftToRightButton;
    private JAXJButton _moveFromRightToLeftButton;
    private JAXJButton _editButton;
    private JAXJButton _okButton;
    private JAXJButton _cancelButton;
    private JPanel _listSelectionView;
    private JTextField _textField;
    private JComponent _editorComponent;

    public ListSelectionComponent() {
        this.defaultBuild();
    }

    public ListSelectionComponent(Vector assignedValues, Vector unAssignedValues) {
        this();
        int i;
        for (i = 0; i < unAssignedValues.size(); ++i) {
            this.getUnassignedListModel().addElement(unAssignedValues.get(i));
        }
        for (i = 0; i < assignedValues.size(); ++i) {
            this.getAssignedListModel().addElement(assignedValues.get(i));
        }
    }

    public ListSelectionComponent(ListEntry[] assignedValues, ListEntry[] unAssignedValues) {
        this();
        int i;
        for (i = 0; i < unAssignedValues.length; ++i) {
            this.getUnassignedListModel().addElement(unAssignedValues[i]);
        }
        for (i = 0; i < assignedValues.length; ++i) {
            this.getAssignedListModel().addElement(assignedValues[i]);
        }
    }

    public ListSelectionComponent(Vector assignedValues) {
        this();
        for (int i = 0; i < assignedValues.size(); ++i) {
            this.getAssignedListModel().addElement(assignedValues.get(i));
        }
    }

    public ListSelectionComponent(ListEntry[] assignedValues) {
        this();
        for (int i = 0; i < assignedValues.length; ++i) {
            this.getAssignedListModel().addElement(assignedValues[i]);
        }
    }

    public void markError() {
    }

    public DefaultListModel getUnassignedListModel() {
        return (DefaultListModel)this.getUnassignedValuesList().getModel();
    }

    public DefaultListModel getAssignedListModel() {
        return (DefaultListModel)this.getAssignedValuesList().getModel();
    }

    public void setUnassignedListModel(DefaultListModel model) {
        this.getUnassignedValuesList().setModel(model);
    }

    public void setAssignedListModel(DefaultListModel model) {
        this.getAssignedValuesList().setModel(model);
    }

    public void clearAssignedList() {
        this.getAssignedListModel().removeAllElements();
    }

    public void clearUnAssignedList() {
        this.getUnassignedListModel().removeAllElements();
    }

    public void setAssignedModelValues(Object[] newValues) {
        for (int a = 0; a < newValues.length; ++a) {
            Object newValue = newValues[a];
            this.getAssignedListModel().addElement(newValue);
        }
    }

    public void setUnAssignedModelValues(Object[] newValues) {
        for (int a = 0; a < newValues.length; ++a) {
            Object newValue = newValues[a];
            this.getUnassignedListModel().addElement(newValue);
        }
    }

    public void removeUnAssignedModelValues(Object[] valuesToRemove) {
        for (int a = 0; a < valuesToRemove.length; ++a) {
            if (valuesToRemove[a] == null) continue;
            this.getUnassignedListModel().removeElement(valuesToRemove[a]);
        }
    }

    public void removeAssignedModelValues(Object[] valuesToRemove) {
        for (int a = 0; a < valuesToRemove.length; ++a) {
            if (valuesToRemove[a] == null) continue;
            this.getAssignedListModel().removeElement(valuesToRemove[a]);
        }
    }

    public void populateView() {
        if (this._textField != null) {
            String text = "";
            this._textField.setText(text);
            this._textField.setToolTipText(text);
            this._textField.setCaretPosition(0);
        }
    }

    public void resetError() {
        if (this._editorComponent != null) {
            this._editorComponent.setBorder(null);
        }
    }

    private void cancelDialog() {
        this.populateView();
    }

    private void commitDialog() {
    }

    private JComponent createListSelectionView(boolean forDialog) {
        String language = "en";
        if (this._listSelectionView != null) {
            return this._listSelectionView;
        }
        this._listSelectionView = new JPanel();
        this._listSelectionView.setName("listSelectionView");
        this._listSelectionView.setBorder(BorderFactory.createEtchedBorder());
        this._listSelectionView.setFocusable(false);
        String columnSpecInnerPanelConstraints = "50px:g(0.4),10px,50px,10px,50px:g(0.4)";
        String rowSpecInnerPanelConstraints = "93px";
        String columnSpecInnerPanelConstraintsDialog = "100px:g(0.4),10px,50px,10px,100px:g(0.4)";
        String rowSpecInnerPanelConstraintsDialog = "100px:g(100)";
        if (forDialog) {
            String columnSpec = "20px,p:g,20px";
            String rowSpec = "20px,p:g,20px";
            FormLayout tableLayoutOuterPanel = new FormLayout(columnSpec, rowSpec);
            this._listSelectionView.setLayout(tableLayoutOuterPanel);
            columnSpecInnerPanelConstraints = columnSpecInnerPanelConstraintsDialog;
            rowSpecInnerPanelConstraints = rowSpecInnerPanelConstraintsDialog;
        }
        FormLayout tableLayoutInnerPanel = new FormLayout(columnSpecInnerPanelConstraints, rowSpecInnerPanelConstraints);
        JPanel innerPanel = new JPanel(tableLayoutInnerPanel);
        innerPanel.setName("innerPanel");
        this.getUnassignedValuesList().addFocusListener(this);
        if (!forDialog) {
            this.setFirstFocusableComponent(this.getUnassignedValuesList());
        }
        JScrollPane scrollPane1 = new JScrollPane(this.getUnassignedValuesList());
        scrollPane1.setVerticalScrollBarPolicy(20);
        scrollPane1.setFocusable(false);
        scrollPane1.getViewport().setFocusable(false);
        scrollPane1.getHorizontalScrollBar().setFocusable(false);
        scrollPane1.getVerticalScrollBar().setFocusable(false);
        JPanel unassignedPanel = new JPanel(new BorderLayout());
        unassignedPanel.setName("unassignedPanel");
        JLabel unassignedLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText(language, "label_unassigned", "Unassigned"));
        unassignedPanel.add((Component)unassignedLabel, "North");
        unassignedPanel.add((Component)scrollPane1, "Center");
        this._moveFromLeftToRightButton = new JAXJButton(">>");
        this._moveFromRightToLeftButton = new JAXJButton("<<");
        this._moveFromLeftToRightButton.addFocusListener(this);
        this._moveFromRightToLeftButton.addFocusListener(this);
        this._moveFromLeftToRightButton.addActionListener(this);
        this._moveFromRightToLeftButton.addActionListener(this);
        String rowSpec = "0:g(0.2),p,0:g(0.2),p,0:g(0.2)";
        FormLayout buttonTableLayout = new FormLayout("fill:default:grow", rowSpec);
        JPanel innerButtonPanel = new JPanel(buttonTableLayout);
        innerButtonPanel.setName("innerButtonPanel");
        innerButtonPanel.add((Component)this._moveFromLeftToRightButton, "1,2");
        innerButtonPanel.add((Component)this._moveFromRightToLeftButton, "1,4");
        innerButtonPanel.setFocusable(false);
        JPanel buttonHolderPanel = new JPanel(new BorderLayout());
        buttonHolderPanel.setName("buttonHolderPanel");
        buttonHolderPanel.add((Component)new JLabel(" "), "North");
        buttonHolderPanel.add((Component)innerButtonPanel, "Center");
        this.getAssignedValuesList().addFocusListener(this);
        ListCellRenderer simpleTypeListCellRenderer = new ListCellRenderer();
        this.getAssignedValuesList().setCellRenderer(simpleTypeListCellRenderer);
        this.getUnassignedValuesList().setCellRenderer(simpleTypeListCellRenderer);
        JScrollPane scrollPane2 = new JScrollPane(this.getAssignedValuesList());
        scrollPane2.setVerticalScrollBarPolicy(20);
        scrollPane2.setFocusable(false);
        scrollPane2.getViewport().setFocusable(false);
        scrollPane2.getHorizontalScrollBar().setFocusable(false);
        scrollPane2.getVerticalScrollBar().setFocusable(false);
        JPanel assignedPanel = new JPanel(new BorderLayout());
        assignedPanel.setName("assignedPanel");
        JLabel assignedLabel = new JLabel(GUIComponentNLS.getInstance().getNLSText(language, "label_assigned", "Assigned"));
        assignedPanel.add((Component)assignedLabel, "North");
        assignedPanel.add((Component)scrollPane2, "Center");
        innerPanel.add((Component)unassignedPanel, "1,1");
        innerPanel.add((Component)buttonHolderPanel, "3,1");
        innerPanel.add((Component)assignedPanel, "5,1");
        innerPanel.setFocusable(false);
        if (forDialog) {
            this._listSelectionView.add((Component)innerPanel, "2,2");
        } else {
            this._listSelectionView = innerPanel;
        }
        this._listSelectionView.setBorder(null);
        JScrollPane outerScrollPane = new JScrollPane(this._listSelectionView);
        outerScrollPane.setBorder(null);
        outerScrollPane.setVerticalScrollBarPolicy(20);
        outerScrollPane.setFocusable(false);
        outerScrollPane.getViewport().setFocusable(false);
        outerScrollPane.getViewport().setBorder(null);
        outerScrollPane.getHorizontalScrollBar().setFocusable(false);
        outerScrollPane.getVerticalScrollBar().setFocusable(false);
        return outerScrollPane;
    }

    public boolean isListInDialogMode() {
        return false;
    }

    public void defaultBuild() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createEditorComponent(), "Center");
    }

    protected JComponent createEditorComponent() {
        if (this.isListInDialogMode()) {
            FormLayout tableLayout = new FormLayout("fill:default:grow,85px", "20px");
            this._editorComponent = new JPanel(tableLayout);
            this._editorComponent.setName("editorComponent");
            this._textField = new JTextField();
            this._textField.setEnabled(false);
            this._textField.setColumns(1);
            this._textField.setFocusable(false);
            this.setEditorField(this._textField);
            this._editButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText("en", "button_edit", "Edit"));
            this._editButton.addActionListener(this);
            this._editButton.addFocusListener(this);
            this.setFirstFocusableComponent(this._editButton);
            this._editorComponent.add((Component)this._textField, "1,1");
            this._editorComponent.add((Component)this._editButton, "2,1");
        } else {
            this._editorComponent = this.createListSelectionView(false);
        }
        return this._editorComponent;
    }

    public void setEditorField(JComponent editorField) {
    }

    public void setFirstFocusableComponent(JComponent component) {
    }

    public JComponent getEditorComponent() {
        return this._editorComponent;
    }

    public void setEditorComponent(JComponent editorComponent) {
        this._editorComponent = editorComponent;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._moveFromLeftToRightButton) {
            this.actionPerformedAssign();
        } else if (event.getSource() == this._moveFromRightToLeftButton) {
            this.actionPerformedUnassign();
        } else if (event.getSource() == this._editButton) {
            this.showDialog(true);
        } else if (event.getSource() == this._cancelButton) {
            this.cancelDialog();
        } else if (event.getSource() == this._okButton) {
            this.commitDialog();
        }
    }

    public void actionPerformedUnassign() {
        int s;
        Object[] selection = this.getAssignedValuesList().getSelectedValues();
        for (s = 0; s < selection.length; ++s) {
            this.getUnassignedListModel().addElement(selection[s]);
        }
        for (s = selection.length - 1; s >= 0; --s) {
            this.getAssignedListModel().removeElement(selection[s]);
        }
        this.populateView();
    }

    public void actionPerformedAssign() {
        int s;
        Object[] selection = this.getUnassignedValuesList().getSelectedValues();
        for (s = 0; s < selection.length; ++s) {
            this.getAssignedListModel().addElement(selection[s]);
        }
        for (s = selection.length - 1; s >= 0; --s) {
            this.getUnassignedListModel().removeElement(selection[s]);
        }
        this.populateView();
    }

    private void showDialog(boolean show) {
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void release() {
        if (this.getUnassignedValuesList() != null) {
            this.getUnassignedValuesList().removeFocusListener(this);
        }
        if (this.getAssignedValuesList() != null) {
            this.getAssignedValuesList().removeFocusListener(this);
        }
        if (this._moveFromLeftToRightButton != null) {
            this._moveFromLeftToRightButton.removeFocusListener(this);
        }
        if (this._moveFromRightToLeftButton != null) {
            this._moveFromRightToLeftButton.removeFocusListener(this);
        }
        if (this._editButton != null) {
            this._editButton.removeFocusListener(this);
        }
        this.setUnassignedValuesList(null);
        this.setAssignedValuesList(null);
        this._moveFromLeftToRightButton = null;
        this._moveFromRightToLeftButton = null;
        this._editButton = null;
        this._okButton = null;
        this._cancelButton = null;
        this._textField = null;
        this._listSelectionView = null;
    }

    public void setBackground(Color color) {
        if (color != null && this._textField != null) {
            this._textField.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (color != null && this._textField != null) {
            this._textField.setForeground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._editButton != null) {
            this._editButton.setEnabled(enabled);
        }
        this.getUnassignedValuesList().setEnabled(enabled);
        this.getAssignedValuesList().setEnabled(enabled);
    }

    public String getText() {
        return null;
    }

    public void setEditable(boolean editable) {
        this.getUnassignedValuesList().setEditable(editable);
        this.getAssignedValuesList().setEditable(editable);
        this._moveFromLeftToRightButton.setEditable(editable);
        this._moveFromRightToLeftButton.setEditable(editable);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public static void main(String[] args) {
        Vector<String> data = new Vector<String>();
        data.add("a");
        data.add("aa");
        data.add("aaa");
        data.add("aaaa");
        data.add("aaaaaa");
        ListSelectionComponent listview = new ListSelectionComponent(data);
        listview.add(listview.createEditorComponent());
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)listview, "Center");
        f.setSize(500, 500);
        f.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (e.getSource() == this.getAssignedValuesList()) {
                this.actionPerformedUnassign();
            } else if (e.getSource() == this.getUnassignedValuesList()) {
                this.actionPerformedAssign();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void setUnassignedValuesList(JAXJList unassignedValuesList) {
        this._unassignedValuesList = unassignedValuesList;
    }

    private JAXJList getUnassignedValuesList() {
        if (this._unassignedValuesList == null) {
            this._unassignedValuesList = new JAXJList((ListModel)new DefaultListModel());
            this._unassignedValuesList.addMouseListener(this);
        }
        return this._unassignedValuesList;
    }

    private void setAssignedValuesList(JAXJList _assignedValuesList) {
        this._assignedValuesList = _assignedValuesList;
    }

    private JAXJList getAssignedValuesList() {
        if (this._assignedValuesList == null) {
            this._assignedValuesList = new JAXJList((ListModel)new DefaultListModel());
            this._assignedValuesList.addMouseListener(this);
        }
        return this._assignedValuesList;
    }

    public class ListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel defaultListCellRenderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof ListEntry) {
                String newValue = ((ListEntry)value).getValue();
                String text = " ";
                if (newValue != null) {
                    text = newValue;
                }
                defaultListCellRenderer.setText(text);
            }
            return defaultListCellRenderer;
        }
    }

    public class ListEntry {
        Object _key;
        Object[] _value;

        public ListEntry(Object key, Object value) {
            this._key = key;
            this._value = new Object[]{value};
        }

        public ListEntry(Object key, Object[] values) {
            this._key = key;
            this._value = values;
        }

        public ListEntry(String[] values) {
            if (values.length == 1) {
                this._key = values[0];
            } else if (values.length > 1) {
                this._key = values[0];
                this._value = new Object[values.length - 1];
                for (int i = 1; i < values.length; ++i) {
                    this._value[i - 1] = values[i];
                }
            }
        }

        public ListEntry(Object key) {
            this._key = key;
        }

        public String getKey() {
            return this._key.toString();
        }

        public String getValue() {
            if (this._value == null) {
                return this._key.toString();
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < this._value.length; ++i) {
                result.append(this._value[i]);
                if (i + 1 >= this._value.length) continue;
                result.append(", ");
            }
            return result.toString();
        }

        public boolean equals(Object obj) {
            if (this._key == obj) {
                return true;
            }
            return obj instanceof ListEntry && this._key.toString().equals(((ListEntry)obj)._key);
        }

        public String toString() {
            return this._key.toString();
        }
    }
}

