/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.error.Error;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.type.ValidationChangeEvent;
import com.jaxfront.core.type.ValidationChangeListener;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.Sortable;
import com.jaxfront.core.util.TreeSort;
import com.jaxfront.core.util.ValidationErrorSorter;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.TypeWorkspace;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.MessageTableCellRenderer;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class MessageTable
extends JTable
implements ValidationChangeListener {
    private final int COLUMN_COUNT = 3;
    private String[] columnNames = new String[3];
    private Error[] _validationError;
    private TypeWorkspace _workspace;
    private int _lastRowIndex = -1;
    private ValidationErrorSorter _sorter;
    private Error _lastSelectedError;
    private AbstractTableModel tableModel = new AbstractTableModel(){

        public Object getValueAt(int row, int col) {
            if (MessageTable.this._validationError != null && row >= 0 && row <= MessageTable.this._validationError.length) {
                if (MessageTable.this._validationError[row].getErrorHolder().getSchemaElement() == null) {
                    return null;
                }
                try {
                    switch (col) {
                        case 0: {
                            return MessageTable.this._validationError[row];
                        }
                        case 1: {
                            return MessageTable.this._validationError[row].getMessageText();
                        }
                        case 2: {
                            return MessageTable.this._validationError[row];
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return null;
        }

        public int getRowCount() {
            if (MessageTable.this._validationError != null) {
                return MessageTable.this._validationError.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int columnIndex) {
            return MessageTable.this.columnNames[columnIndex];
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    };

    public MessageTable(TypeWorkspace workspace, AbstractEditorPanel editor) {
        this._workspace = workspace;
        this.setFocusable(false);
        this.columnNames[0] = GUIComponentNLS.getInstance().getNLSText(this._workspace.getDOM(), "message_table_category", "Category");
        this.columnNames[1] = GUIComponentNLS.getInstance().getNLSText(this._workspace.getDOM(), "message_table_description", "Description");
        this.columnNames[2] = GUIComponentNLS.getInstance().getNLSText(this._workspace.getDOM(), "message_table_context", "Navigation Tree Context");
        this.initGUI();
    }

    public void updateTable(Error[] validationError) {
        int i;
        if (validationError != null) {
            Vector<Error> filteredErrors = new Vector<Error>();
            for (i = 0; i < validationError.length; ++i) {
                Error error = validationError[i];
                boolean hasPageLayoutParent = this.hasPagelayoutParent(error.getErrorHolder());
                if (hasPageLayoutParent) {
                    Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(error.getErrorHolder());
                    if (visualizers.size() <= 0) continue;
                    filteredErrors.add(error);
                    continue;
                }
                filteredErrors.add(error);
            }
            validationError = new Error[filteredErrors.size()];
            filteredErrors.copyInto(validationError);
        }
        this._validationError = validationError;
        if (this._validationError != null && this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        if (this._validationError == null) {
            this.revalidate();
        }
        if (this._lastSelectedError != null && validationError != null) {
            int index = -1;
            for (i = 0; i < validationError.length; ++i) {
                if (!validationError[i].equals(this._lastSelectedError)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.getSelectionModel().setValueIsAdjusting(true);
                this.getSelectionModel().setLeadSelectionIndex(index);
            }
        }
    }

    private boolean hasPagelayoutParent(Type type) {
        if (type.getXUIDefinition().getStyle().isPagingLayout()) {
            return true;
        }
        if (type.getParent() != null) {
            return this.hasPagelayoutParent(type.getParent());
        }
        return false;
    }

    private void initGUI() {
        this.setModel(this.tableModel);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        TableCellRenderer cellRenderer = null;
        String rendererClass = JAXFrontProperties.getInstance().getMessageTableCellRenderer();
        cellRenderer = rendererClass != null && !rendererClass.equals("") ? (TableCellRenderer)IntroSpectionHelper.createObject((String)rendererClass, (Class[])null, null) : new MessageTableCellRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
        cellRenderer = (TableCellRenderer)IntroSpectionHelper.createObject((String)rendererClass, (Class[])null, null);
        this.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
        cellRenderer = (TableCellRenderer)IntroSpectionHelper.createObject((String)rendererClass, (Class[])null, null);
        this.getColumnModel().getColumn(2).setCellRenderer(cellRenderer);
        this.getColumnModel().getColumn(0).setMinWidth(180);
        this.getColumnModel().getColumn(0).setMaxWidth(250);
        this.getColumnModel().getColumn(1).setMinWidth(230);
        this.getColumnModel().getColumn(1).setMaxWidth(230);
        this.getColumnModel().getColumn(2).setMinWidth(200);
        this.getColumnModel().getColumn(2).setMaxWidth(3000);
        this.setRowHeight(this.getRowHeight() + 15);
        this._workspace.getDOM().getController().getErrorController().addValidationChangeListener((ValidationChangeListener)this);
        this.updateMessageTable();
    }

    private void focusError() {
        int rowIndex = this.getSelectionModel().getLeadSelectionIndex();
        if (this._validationError != null && rowIndex != -1 && this._validationError.length > rowIndex) {
            AbstractView view;
            Type sourceType;
            Error error;
            this._lastSelectedError = error = this._validationError[rowIndex];
            boolean isNewError = true;
            if (rowIndex == this._lastRowIndex && (sourceType = error.getErrorHolder()) != null && (view = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(sourceType, false)) != null && view.getFirstFocusableComponent() != null && view.getFirstFocusableComponent().hasFocus()) {
                isNewError = false;
            }
            if (isNewError) {
                FocusHelper.focus(error.getErrorHolder());
                if (error.isNeedingUserAcceptance()) {
                    error.resetError();
                    error.getErrorHolder().getDOM().getController().getErrorController().removeError(error);
                }
                this._lastRowIndex = rowIndex;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
        ListSelectionModel model = this.getSelectionModel();
        if (event.getSource() == model && !event.getValueIsAdjusting() && !model.isSelectionEmpty()) {
            int rowIndex = model.getLeadSelectionIndex();
            this.focusError();
        }
    }

    public void validationChanged(ValidationChangeEvent event) {
        if (event.isOccuring() || event.isResolved() || event.isFullDOMValidation() || event.isResolvedAll()) {
            this.updateMessageTable();
        }
    }

    private void updateMessageTable() {
        Error[] validationErrors = this.getSortedValidationErrors(this.getErrors());
        this.updateTable(validationErrors);
    }

    private Error[] getSortedValidationErrors(Error[] validationErrors) {
        if (validationErrors != null) {
            Vector<Error> tempVector = new Vector<Error>();
            for (int i = 0; i < validationErrors.length; ++i) {
                tempVector.add(validationErrors[i]);
            }
            Vector sortedVector = new Vector();
            sortedVector = TreeSort.sort(tempVector, (Sortable)this.getValidationErrorSorter());
            for (int j = 0; j < sortedVector.size(); ++j) {
                validationErrors[j] = (Error)sortedVector.get(j);
            }
            tempVector = null;
            return validationErrors;
        }
        return null;
    }

    private Error[] getErrors() {
        if (this._workspace.getDOM() == null) {
            return null;
        }
        TypeController controller = this._workspace.getDOM().getController();
        if (controller.getErrorController().hasValidationErrors()) {
            Enumeration typeErrors = controller.getErrorController().getErrors().elements();
            int size = controller.getErrorController().getErrors().size();
            boolean i = false;
            Vector validationErrors = new Vector();
            while (typeErrors.hasMoreElements()) {
                Vector errors = (Vector)typeErrors.nextElement();
                validationErrors.addAll(errors);
            }
            Error[] foundErrors = new Error[validationErrors.size()];
            for (int j = 0; j < validationErrors.size(); ++j) {
                foundErrors[j] = (Error)validationErrors.get(j);
            }
            return foundErrors;
        }
        return null;
    }

    public void release() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().removeListSelectionListener(this);
        }
        if (this._workspace != null && this._workspace.getDOM() != null) {
            this._workspace.getDOM().getController().getErrorController().removeValidationChangeListener((ValidationChangeListener)this);
        }
        this._validationError = null;
        this._workspace = null;
    }

    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
    }

    public ValidationErrorSorter getValidationErrorSorter() {
        if (this._sorter == null) {
            this._sorter = new ValidationErrorSorter();
        }
        return this._sorter;
    }
}

