/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.swing.ui.editor.FileLocationChooser;
import com.jaxfront.swing.ui.editor.XMLFilter;
import com.jaxfront.swing.ui.editor.XSDFilter;
import com.jaxfront.swing.ui.editor.XUIFilter;
import com.jaxfront.swing.ui.layout.PercentLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class FileNameChooser
extends JPanel
implements ActionListener,
FocusListener,
FileLocationChooser {
    public static final String SUFFIX_XSD = "xsd";
    public static final String SUFFIX_XML = "xml";
    public static final String SUFFIX_XUI = "xui";
    private String _oldFileName;
    private String _suffix;
    private JComboBox _comboField;
    private JCheckBox _fileDeselectorCheckBox;
    private JButton _button;
    private PropertyChangeSupport _propertyChangeSupport;
    private JFileChooser _fileChooser;
    private File _defaultDirectory;

    public FileNameChooser(String name, String fileName, Vector lastFiles, String suffix, boolean useFileDeselector) {
        this._suffix = suffix;
        if (fileName != null) {
            if (!lastFiles.contains(fileName)) {
                lastFiles.add(fileName);
            }
        } else if (lastFiles != null && lastFiles.size() > 0) {
            fileName = (String)lastFiles.get(0);
        }
        this.init(lastFiles, fileName, name, useFileDeselector);
    }

    public void actionPerformed(ActionEvent e) {
        String newValue;
        if (e.getSource() == this._button) {
            int result = this.getFileChooser().showOpenDialog(this);
            if (result != 1) {
                try {
                    String fileName = this.getFileChooser().getSelectedFile().toURL().getFile();
                    if (fileName != null) {
                        this._comboField.addItem(fileName);
                        this._comboField.setSelectedItem(fileName);
                        this._comboField.requestFocus();
                        this.getPropertyChangeSupport().firePropertyChange("property", "", fileName);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (e.getSource() == this._fileDeselectorCheckBox) {
            if (this._fileDeselectorCheckBox.isSelected()) {
                this.setEnabled(true);
                this._comboField.getEditor().selectAll();
            } else {
                this.setEnabled(false);
            }
        } else if (this._comboField.getItemCount() > 0 && (newValue = (String)this._comboField.getSelectedItem()) != null) {
            this.getPropertyChangeSupport().firePropertyChange("property", "", newValue);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this._comboField != null) {
            this._comboField.setEnabled(enabled);
            this._comboField.setEditable(enabled);
        }
        if (this._button != null) {
            this._button.setEnabled(enabled);
        }
        if (this._fileDeselectorCheckBox != null) {
            this._fileDeselectorCheckBox.setSelected(enabled);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.getText() != null) {
            if (this._oldFileName == null || !this.getText().equals(this._oldFileName)) {
                this.getPropertyChangeSupport().firePropertyChange("property", this._oldFileName, this.getText());
            }
            this._oldFileName = this.getText();
        }
    }

    public Document getDOM() {
        return null;
    }

    private JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            if (this._suffix.equals(SUFFIX_XSD)) {
                this._fileChooser.setFileFilter(new XSDFilter());
            } else if (this._suffix.equals(SUFFIX_XML)) {
                this._fileChooser.setFileFilter(new XMLFilter());
            } else if (this._suffix.equals(SUFFIX_XUI)) {
                this._fileChooser.setFileFilter(new XUIFilter());
            }
        }
        if (this.getText() != null && this.getText().length() > 0) {
            if (this.getURL() != null && this.getURL().getProtocol().equalsIgnoreCase("file")) {
                this._fileChooser.setCurrentDirectory(new File(this.getURL().getFile()));
            }
        } else if (this.getDefaultDirectory() != null) {
            this._fileChooser.setCurrentDirectory(this.getDefaultDirectory());
        }
        return this._fileChooser;
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this._propertyChangeSupport;
    }

    public String getSelectedItem() {
        return null;
    }

    public String getText() {
        String temp = null;
        if (this._comboField.isEnabled()) {
            temp = (String)this._comboField.getEditor().getItem();
        }
        return temp;
    }

    public void setText(String text) {
        if (this._comboField.isEnabled()) {
            this._comboField.getEditor().setItem(text);
        }
    }

    public URL getURL() {
        URL url = null;
        if (this.getText() != null && this.getText().length() > 0 && (url = this.getClass().getClassLoader().getResource(this.getText())) == null) {
            if (this.getText().startsWith(".")) {
                String newUrl = System.getProperty("user.dir") + this.getText().substring(1, this.getText().length());
                url = URLHelper.getUserURL((String)newUrl);
            } else {
                url = URLHelper.getUserURL((String)this.getText());
            }
        }
        return url;
    }

    private void init(Vector lastFiles, String currentName, String labelName, boolean useFileDeselector) {
        this.setLayout(new PercentLayout(1));
        PercentLayout.Constraints spacer = null;
        PercentLayout.Constraints labelConstraint = null;
        PercentLayout.Constraints checkBoxConstraint = null;
        PercentLayout.Constraints comboFieldConstraint = null;
        PercentLayout.Constraints buttonConstraint = null;
        spacer = new PercentLayout.Constraints(1, 0);
        labelConstraint = new PercentLayout.Constraints(30, 3);
        checkBoxConstraint = new PercentLayout.Constraints(4, 3);
        comboFieldConstraint = new PercentLayout.Constraints(58, 3);
        buttonConstraint = new PercentLayout.Constraints(6, 3);
        this._fileDeselectorCheckBox = new JCheckBox();
        this._fileDeselectorCheckBox.addActionListener(this);
        this._fileDeselectorCheckBox.setSelected(true);
        this._comboField = new JComboBox();
        for (int i = 0; i < lastFiles.size(); ++i) {
            String fileName = (String)lastFiles.get(i);
            JMenuItem label = new JMenuItem(fileName);
            label.setToolTipText(fileName);
            this._comboField.addItem(label.getText());
        }
        this._comboField.setEditable(true);
        this._comboField.addActionListener(this);
        this._comboField.addFocusListener(this);
        this._comboField.getEditor().getEditorComponent().addFocusListener(this);
        if (currentName != null) {
            this._comboField.setSelectedItem(currentName);
        }
        ImageIcon openIcon = JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/openFile_16x16.gif");
        this._button = new JButton(openIcon);
        this._button.setPreferredSize(new Dimension(16, 16));
        this._button.addActionListener(this);
        this.add((Component)new JLabel(""), spacer);
        this.add((Component)new JLabel(labelName), labelConstraint);
        if (useFileDeselector) {
            this.add((Component)this._fileDeselectorCheckBox, checkBoxConstraint);
        } else {
            this.add((Component)new JLabel(""), checkBoxConstraint);
        }
        this.add((Component)this._comboField, comboFieldConstraint);
        this.add((Component)new JLabel(""), spacer);
        this.add((Component)this._button, buttonConstraint);
    }

    public void setItems(String[] items) {
    }

    public void setSelectedItem(String name) {
        if (this._comboField != null) {
            this._comboField.setSelectedItem(name);
        }
    }

    public void setDefaultDirectory(File directory) {
        this._defaultDirectory = directory;
    }

    public File getDefaultDirectory() {
        return this._defaultDirectory;
    }
}

