/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.EventUtil;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.VectorHelper;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.AbstractPopUpMenu;
import com.jaxfront.swing.ui.editor.DefaultPopUpMenu;
import com.jaxfront.swing.ui.editor.NavigationTreeCellEditor;
import com.jaxfront.swing.ui.editor.NavigationTreeCellRenderer;
import com.jaxfront.swing.ui.tools.OverlayListener;
import com.jaxfront.swing.ui.tools.TreeUtil;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeView;
import com.jaxfront.swing.ui.wrapper.RecursionWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NavigationTree
extends JTree
implements DOMChangeListener,
PropertyChangeListener,
ActionListener,
PopupMenuListener {
    public static final String ADD_NODE = "ADD_NODE";
    public static final String ADD_NODE_BEFORE = "ADD_BEFORE_NODE";
    public static final String ADD_NODE_AFTER = "ADD_AFTER_NODE";
    public static final String COPY_NODE = "COPY_NODE";
    public static final String COPY_NODES = "COPY_NODES";
    public static final String SORT_ASC = "SORT_ASC";
    public static final String SORT_DES = "SORT_DES";
    public static final String ADD_RECURSIVE_NODE = "ADD_RECURSIVE_NODE";
    public static final String REMOVE_NODE = "REMOVE_NODE";
    public static final String REMOVE_NODES = "REMOVE_NODES";
    public static final String COLLAPSE_NODE = "COLLAPSE_NODE";
    public static final String EXPAND_COLLAPSE_NODE = "EXP_COL_NODE";
    public static final String COPY_CONTENT = "COPY_CONTENT";
    public static final String PASTE_CONTENT = "PASTE_CONTENT";
    public static final String NODE_NAME_PROPERTY = "NODE_NAME_PROPERTY";
    private OverlayListener _olListener = null;
    protected AbstractEditorPanel _editor;
    private List _treeTypes;
    protected TreeCellRenderer _treeCellRenderer;
    private boolean _isMultiSelectOperation;

    public NavigationTree(AbstractEditorPanel editor, List treeTypes) {
        this._treeTypes = treeTypes;
        this._editor = editor;
        this.setFocusable(false);
        if (this.getDOM() != null) {
            this.getDOM().setXPathCached(true);
        }
        this.initialize();
        if (this.getDOM() != null) {
            this.getDOM().setXPathCached(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem && this.getSelectionPath() != null) {
            JMenuItem item = (JMenuItem)e.getSource();
            if (e.getActionCommand().equals(ADD_NODE)) {
                this.addNode((String)item.getClientProperty(NODE_NAME_PROPERTY));
            } else if (e.getActionCommand().equals(ADD_NODE_AFTER)) {
                this.addNodeAfter();
            } else if (e.getActionCommand().equals(ADD_NODE_BEFORE)) {
                this.addNodeBefore();
            } else if (e.getActionCommand().equals(REMOVE_NODE)) {
                TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
                this.removeNode(selectedNode);
            } else if (e.getActionCommand().equals(REMOVE_NODES)) {
                this.removeNodes();
            } else if (e.getActionCommand().equals(COPY_NODE)) {
                this.copyNode();
            } else if (e.getActionCommand().equals(COPY_NODES)) {
                this.copyNodes();
            } else if (e.getActionCommand().equals(SORT_ASC)) {
                TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
                if (selectedNode != null) {
                    this.sortListElements(selectedNode, 0);
                }
            } else if (e.getActionCommand().equals(SORT_DES)) {
                TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
                if (selectedNode != null) {
                    this.sortListElements(selectedNode, 1);
                }
            } else if (e.getActionCommand().equals(COLLAPSE_NODE)) {
                this.collapseNode();
            } else if (e.getActionCommand().equals(EXPAND_COLLAPSE_NODE)) {
                this.expCollapseNode(item);
            } else if (e.getActionCommand().equals(ADD_RECURSIVE_NODE)) {
                this.addRecursiveNode((String)item.getClientProperty(NODE_NAME_PROPERTY));
                item.setEnabled(false);
            } else if (e.getActionCommand().equals(COPY_CONTENT)) {
                this.stopAllCellEditing();
                TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
                if (selectedNode != null) {
                    this.getDOM().getClipBoard().copy(selectedNode.getType());
                }
            } else if (e.getActionCommand().equals(PASTE_CONTENT)) {
                this.doPaste();
            }
        }
    }

    private void expCollapseNode(JMenuItem item) {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        if (TreeUtil.isExpandend(this, (DefaultMutableTreeNode)selectedNode)) {
            TreeUtil.collapseJTreeNode(this, (DefaultMutableTreeNode)selectedNode, -1);
        } else {
            TreeUtil.expandJTreeNode((JTree)this, (DefaultMutableTreeNode)selectedNode, -1);
        }
    }

    public void doPaste() {
        this.stopAllCellEditing();
        this.getEditor().clearWorkbench();
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        TreePath treePath = this.getSelectionPath();
        if (selectedNode != null) {
            ((AbstractEditorPanel)this.getDOM().getEditor()).setIsSelectingTreeNode(true);
            Vector states = new Vector();
            TreeUtil.getTreeNodeStates(this, (DefaultMutableTreeNode)selectedNode, states, new Stack());
            this.getDOM().getClipBoard().paste(selectedNode.getType());
            TypeVisualizerFactory.getInstance().releaseCache(selectedNode.getType());
            TreeUtil.setTreeNodeStates((JTree)this, selectedNode, states, 0);
            this.getDOM().validateKeyRefIntegrity(true);
            String iconName = selectedNode.getType().getStyle().getTreeIcon();
            if (!selectedNode.getType().isReleased()) {
                ImageIcon icon = JAXFrontProperties.getImageIcon((URL)selectedNode.getType().getDOM().getFingerPrint().getXUIURL(), (String)iconName);
                selectedNode.setIcon(icon);
            }
            this.getEditor().getWorkspace().visualize(selectedNode, true);
            this.setSelectionPath(treePath);
            ((AbstractEditorPanel)this.getDOM().getEditor()).setIsSelectingTreeNode(false);
            this.repaint();
        }
    }

    public void sortListElements(TreeNode selectedNode, int direction) {
        ListType selectedList = (ListType)selectedNode.getType();
        this.sortListElements(selectedList, direction);
    }

    public void sortListElements(ListType selectedList, int direction) {
        List backup = VectorHelper.copy((List)selectedList);
        List sorted = ((AbstractListType)selectedList).sort(direction);
        boolean same = VectorHelper.isSame((List)selectedList, (List)backup);
        Vector vis = TypeVisualizerFactory.getInstance().getAllVisualizers((Type)selectedList);
        for (int v = 0; v < vis.size(); ++v) {
            ((ListVisualizer)vis.get(v)).resetView();
        }
        int inverse = -1;
        switch (direction) {
            case 0: {
                inverse = 1;
                break;
            }
            case 1: {
                inverse = 0;
            }
        }
        this.getDOM().getUndoManager().addListSortEvent(this.getClass(), selectedList, direction, inverse, "sort");
        TreeUtil.expandJTreeNode((JTree)this, (DefaultMutableTreeNode)this.getNode((Type)selectedList), 1);
        if (!same) {
            this.getDOM().getController().fireDirtyChange();
        }
    }

    public void collapsePath(TreePath path) {
        this.getEditor().setHighLightMode(true);
        super.collapsePath(path);
        this.getEditor().setHighLightMode(false);
    }

    private void addNode(String nodeName) {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        Type selectedType = selectedNode.getType();
        if (selectedType != null) {
            boolean wascompoundEdit = this.getDOM().getUndoManager().isInCompoundEditState();
            this.getDOM().getUndoManager().startCompoundEdit();
            boolean isListVisible = selectedType.getXUIDefinition().getStyle().isVisible();
            if (selectedType.isList()) {
                TreeNode node;
                ListType listType = (ListType)selectedType;
                Type editingType = listType.getEditingType();
                Type addedType = null;
                try {
                    listType.checkCardinality(1);
                }
                catch (ValidationException ve) {
                    return;
                }
                selectedType.getXUIDefinition().getStyle().setVisible(true);
                if (listType.getEditingType().isAbstract()) {
                    Type derivatType = DOMHelper.getDerivedType((Type)listType.getEditingType(), (String)nodeName, (boolean)false);
                    if (derivatType != null) {
                        try {
                            Type newType = derivatType.deepClone(this.getDOM(), false, false);
                            listType.add(newType);
                            addedType = newType;
                        }
                        catch (CloneNotSupportedException ex) {
                            LogRegistry.getInstance().warn(this.getModel().getClass(), "Not able to create deepClone from " + derivatType.getXPathLocation());
                        }
                    }
                } else {
                    addedType = listType.addNewChild();
                }
                if (!editingType.isAbstract() && editingType.isChoice() && nodeName != null) {
                    Type choosenType = addedType.getDirectChild(nodeName);
                    if (choosenType == null) {
                        choosenType = ((CompositeType)addedType).createChoiceType(nodeName);
                    }
                    if (choosenType != null) {
                        addedType.setChoosenType(choosenType);
                    }
                }
                if (addedType.isRepresentedAsTreeNode() && (node = this.getNode(addedType)) != null) {
                    TreePath treePath = new TreePath(node.getPath());
                    this.setSelectionPath(treePath);
                    TreeUtil.expandJTreeNode((JTree)this, (DefaultMutableTreeNode)node, 1);
                }
                selectedType.getXUIDefinition().getStyle().setVisible(isListVisible);
            }
            if (!wascompoundEdit) {
                this.getDOM().getUndoManager().stopCompoundEdit();
            }
        }
    }

    private Type getSelectedType() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectedNode != null) {
            return selectedNode.getType();
        }
        return null;
    }

    private void addRecursiveNode(String nodeName) {
        CompositeType composite;
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        Type selectedType = selectedNode.getType();
        if (selectedType != null && selectedType.isComposite() && !(composite = (CompositeType)selectedNode.getType()).hasRecursionBeenBuilt()) {
            RecursionWrapper recVis = null;
            Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer((Type)composite);
            if (vis.getImplementation() instanceof RecursionVisualizer) {
                recVis = (RecursionWrapper)vis.getImplementation();
            }
            if (recVis != null) {
                recVis.createRecursion();
            }
        }
    }

    private void checkPopUp(MouseEvent e) {
        if (this.getSelectionPath() != null && e.isPopupTrigger() && this.getSelectionPath().getLastPathComponent() != null) {
            boolean canShow = true;
            JPopupMenu popUp = this.getPopUp((TreeNode)this.getSelectionPath().getLastPathComponent());
            if (popUp != null && AbstractPopUpMenu.class.isAssignableFrom(popUp.getClass())) {
                if (((AbstractPopUpMenu)popUp)._pasteContentItem != null) {
                    Type selection = this.getSelectedType();
                    boolean canPaste = this.getDOM().getClipBoard().canPaste(selection, false);
                    ((AbstractPopUpMenu)popUp).setPasteContentEnabled(canPaste);
                }
                boolean bl = canShow = !((AbstractPopUpMenu)popUp).isEmpty();
            }
            if (canShow) {
                popUp.show(this, e.getX(), e.getY());
            }
        }
    }

    public String getToolTipText(MouseEvent e) {
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath != null) {
            String tooltip = ((TreeNode)selPath.getLastPathComponent()).getToolTip();
            return tooltip;
        }
        return null;
    }

    private void collapseNode() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        Enumeration children = selectedNode.children();
        while (children.hasMoreElements()) {
            TreeNode childNode = (TreeNode)children.nextElement();
            TreePath childPath = this.getSelectionPath().pathByAddingChild(childNode);
            this.collapsePath(childPath);
        }
        this.collapsePath(this.getSelectionPath());
    }

    public void domChanged(DOMChangeEvent event) {
        boolean relevantEvent = false;
        TreeNode selectedNode = null;
        if (this.getSelectionPath() != null) {
            selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        }
        if (event.isAddingNode()) {
            relevantEvent = this.performAddNode((Type)event.getSource());
        } else if (event.isRemovingNode()) {
            relevantEvent = true;
            Type type = (Type)event.getSource();
            this.performRemoveNode(type);
            if (this.getEditor().getWorkspace().getLastVisualizedType() == type) {
                this.getEditor().clearWorkbench();
                this.getEditor().repaint();
            }
        } else if (event.isSwappingNode()) {
            relevantEvent = true;
            ListType listType = (ListType)event.getSource();
            Type fromType = null;
            Type toType = null;
            if (event.getMovedFromIndex() >= 0 && event.getMovedFromIndex() < listType.getList().size()) {
                fromType = (Type)listType.getList().get(event.getMovedFromIndex());
            }
            if (event.getMovedToIndex() >= 0 && event.getMovedToIndex() < listType.getList().size()) {
                toType = (Type)listType.getList().get(event.getMovedToIndex());
            }
            if (fromType != null && toType != null && fromType.isRepresentedAsTreeNode() && toType.isRepresentedAsTreeNode()) {
                TreeNode listTreeNode = this.getNode((Type)listType);
                Vector listEntries = new Vector();
                listEntries.addAll(listTreeNode.getChildren());
                TreeNode treeNode = null;
                listTreeNode.removeAllChildren();
                for (int i = 0; i < listType.size(); ++i) {
                    Type child = (Type)listType.getList().get(i);
                    treeNode = this.getTreeNode(child, listEntries);
                    listTreeNode.add((MutableTreeNode)treeNode);
                }
                ((com.jaxfront.core.ui.TreeModel)this.getModel()).nodeStructureChanged((javax.swing.tree.TreeNode)listTreeNode);
                this.repaint();
            }
        } else if (event.isSorted()) {
            relevantEvent = true;
            int[] indexes = event.getIndexes();
            ListType listType = (ListType)event.getSource();
            TreeNode listTreeNode = this.getNode((Type)listType);
            Vector listEntries = new Vector();
            if (listTreeNode != null && listTreeNode.getChildren() != null && listTreeNode.getChildCount() > 0) {
                Type child;
                listEntries.addAll(listTreeNode.getChildren());
                TreeNode treeNode = null;
                TreePath selectionPath = this.getSelectionPath();
                listTreeNode.removeAllChildren();
                if (indexes != null) {
                    for (int i = 0; i < indexes.length; ++i) {
                        child = (Type)listType.getList().get(indexes[i]);
                        treeNode = this.getTreeNode(child, listEntries);
                        listTreeNode.add((MutableTreeNode)treeNode);
                    }
                } else {
                    for (int i = 0; i < listType.size(); ++i) {
                        child = (Type)listType.getList().get(i);
                        treeNode = this.getTreeNode(child, listEntries);
                        listTreeNode.add((MutableTreeNode)treeNode);
                    }
                }
                ((com.jaxfront.core.ui.TreeModel)this.getModel()).nodeStructureChanged((javax.swing.tree.TreeNode)listTreeNode);
                if (treeNode != null) {
                    this.expandPath(new TreePath(treeNode));
                }
                if (selectionPath != null) {
                    this.setSelectionPath(selectionPath);
                }
            }
            ListVisualizer listVisualizer = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)listType);
            listVisualizer.showUpDownButtons(false);
            if (selectedNode != null && listType.contains((Object)selectedNode.getType())) {
                listVisualizer.selectType(selectedNode.getType());
            }
        }
        if (relevantEvent) {
            this.maintainIcons((TreeNode)this.getModel().getRoot());
        }
    }

    private void performRemoveNode(Type type) {
        this.stopEditing();
        boolean wasHighlightMode = this.getEditor()._isOnlyHighLightMode;
        this.getEditor().setHighLightMode(true);
        ((com.jaxfront.core.ui.TreeModel)this.getModel()).removeNode(type);
        if (!wasHighlightMode) {
            this.getEditor().setHighLightMode(false);
        }
        this.repaint();
    }

    private boolean performAddNode(Type type) {
        boolean relevantEvent = true;
        if (type.isRepresentedAsTreeNode()) {
            ((com.jaxfront.core.ui.TreeModel)this.getModel()).insertNode(type);
            this.repaint();
        }
        return relevantEvent;
    }

    private void maintainIcons(TreeNode node) {
        if (node != null && node.getType() != null && !node.getType().getDOM().isPasteMode() && !node.getType().getDOM().isBinding()) {
            ImageIcon icon;
            if (node.getType().getStyle().hasTreeIconFormula() && (icon = JAXFrontProperties.getImageIcon((URL)node.getType().getDOM().getFingerPrint().getXUIURL(), (String)node.getType().getStyle().getTreeIcon())) != null) {
                node.setIcon(icon);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.maintainIcons((TreeNode)node.getChildren().get(i));
            }
        }
    }

    private TreeNode getTreeNode(Type type, List treeNodes) {
        Iterator iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (treeNode.getType() != type) continue;
            return treeNode;
        }
        return null;
    }

    public DefaultMutableTreeNode getTreeNode(Type type) {
        return TreeUtil.searchTypeTreeNode((DefaultMutableTreeNode)this.getModel().getRoot(), -1, type);
    }

    public Document getDOM() {
        if (this._treeTypes != null && this._treeTypes.size() > 0) {
            return ((Type)this._treeTypes.get(0)).getDOM();
        }
        return null;
    }

    public TreeNode getNode(Type type) {
        TreeNode rootNode = (TreeNode)this.getModel().getRoot();
        return this.getNode(rootNode, type);
    }

    private TreeNode getNode(TreeNode node, Type type) {
        if (node.getType() == type) {
            return node;
        }
        Enumeration children = node.children();
        TreeNode found = null;
        while (children.hasMoreElements() && found == null) {
            TreeNode child = (TreeNode)children.nextElement();
            found = this.getNode(child, type);
        }
        return found;
    }

    private JPopupMenu getPopUp(TreeNode treeNode) {
        String popUpImpl;
        Type type = treeNode.getType();
        AbstractPopUpMenu popUp = null;
        XUIDefinition xuiDef = type.getXUIDefinition(false);
        if (xuiDef != null && (popUpImpl = type.getXUIDefinition().getStyle().getTreePopUpClass()) != null) {
            popUp = this.getPopUpImpl(popUpImpl, treeNode);
        }
        if (popUp == null) {
            popUp = new DefaultPopUpMenu(this, treeNode);
        }
        return popUp;
    }

    private AbstractPopUpMenu getPopUpImpl(String className, TreeNode treeNode) {
        block13: {
            try {
                Class<?> implClass = Class.forName(className);
                if (implClass == null) break block13;
                if (AbstractPopUpMenu.class.isAssignableFrom(implClass)) {
                    Class[] parameterClasses = new Class[]{this.getClass(), treeNode.getClass()};
                    Constructor<?> constructor = implClass.getConstructor(parameterClasses);
                    if (constructor != null) {
                        Object[] parameters = new Object[]{this, treeNode};
                        return (AbstractPopUpMenu)constructor.newInstance(parameters);
                    }
                    break block13;
                }
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "Class: " + className + " not derived from JPopupMenu");
                }
                return null;
            }
            catch (ClassNotFoundException ex) {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "Class: " + className + " can not be found");
                }
            }
            catch (InstantiationException ie) {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "Error while creating instance of " + className);
                }
            }
            catch (IllegalAccessException ia) {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "Error while creating instance of " + className);
                }
            }
            catch (NoSuchMethodException nm) {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "Error while creating constructor of " + className);
                }
            }
            catch (InvocationTargetException it) {
                if (!LogRegistry.getInstance().logLogs()) break block13;
                LogRegistry.getInstance().log(this.getClass(), "Error while invoking constructuor of " + className);
            }
        }
        return null;
    }

    private Type getRoot(List treeTypes) {
        if (treeTypes.size() == 1) {
            return (Type)treeTypes.get(0);
        }
        RootType rootType = new RootType(treeTypes);
        rootType.setDOM(this.getDOM());
        return rootType;
    }

    public Type getRootType() {
        TreeNode rootNode = (TreeNode)this.getModel().getRoot();
        return rootNode.getType();
    }

    private Type getTreeParentType(Type type) {
        if (type.getParent().isRepresentedAsTreeNode()) {
            return type.getParent();
        }
        Type found = null;
        while (type.getParent() != null && found == null) {
            found = this.getTreeParentType(type.getParent());
        }
        return found;
    }

    protected TreeCellRenderer getTreeCellRenderer() {
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = new NavigationTreeCellRenderer(new DefaultTreeCellRenderer());
        }
        return this._treeCellRenderer;
    }

    protected void initialize() {
        this.setCellRenderer(this.getTreeCellRenderer());
        NavigationTreeCellEditor editor = new NavigationTreeCellEditor(new NavigationTreeCellRenderer(new DefaultTreeCellRenderer()));
        this.setCellEditor(editor);
        Type rootType = this.getRoot(this._treeTypes);
        if (rootType.getDOM() != null) {
            rootType.getDOM().getPropertyChangeSupport().addPropertyChangeListener((PropertyChangeListener)this);
        } else {
            this.setRootVisible(false);
        }
        boolean showTreeListContainer = true;
        if (this.getDOM() != null) {
            showTreeListContainer = this.getDOM().isShowingTreeListContainer();
        }
        if (this._treeTypes.size() > 1) {
            this.setRootVisible(false);
        } else if (!showTreeListContainer && rootType.isList()) {
            this.setRootVisible(false);
        }
        com.jaxfront.core.ui.TreeModel treeModel = this.initTreeModel(rootType);
        this.setModel((TreeModel)treeModel);
        TreeUtil.expandJTreeNode((JTree)this, (DefaultMutableTreeNode)treeModel.getRoot(), this.getInitialTreeExpandDepth());
        this.setEditable(true);
        this.initKeyBindings();
        this._olListener = new OverlayListener(this);
    }

    protected int getInitialTreeExpandDepth() {
        int expandDepth = 3;
        if (this.getDOM() != null) {
            expandDepth = this.getDOM().getGlobalDefinition().getInitialTreeExpandDepth();
        }
        return expandDepth;
    }

    private void initKeyBindings() {
        AbstractAction moveUpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractListTypeView listView;
                ListInfo info;
                TreeNode selectedNode;
                Type selType;
                if (NavigationTree.this.getSelectionPath() != null && (selType = (selectedNode = (TreeNode)NavigationTree.this.getSelectionPath().getLastPathComponent()).getType()).getParent() != null && selType.getParent().isList() && (info = selType.getParent().getStyle().getListInfo()) != null && info.allowReOrdering() && (listView = (AbstractListTypeView)TypeVisualizerFactory.getInstance().getVisualizer((Type)selType.getParentList()).getImplementation()) != null) {
                    listView.doMoveUpAction(selType);
                    NavigationTree.this.getEditor().selectNode(selType);
                    listView.handleButtonEnabling();
                }
            }
        };
        AbstractAction moveDownAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractListTypeView listView;
                ListInfo info;
                TreeNode selectedNode;
                Type selType;
                if (NavigationTree.this.getSelectionPath() != null && (selType = (selectedNode = (TreeNode)NavigationTree.this.getSelectionPath().getLastPathComponent()).getType()).getParent() != null && selType.getParent().isList() && (info = selType.getParent().getStyle().getListInfo()) != null && info.allowReOrdering() && (listView = (AbstractListTypeView)TypeVisualizerFactory.getInstance().getVisualizer((Type)selType.getParentList()).getImplementation()) != null) {
                    listView.doMoveDownAction(selType);
                    NavigationTree.this.getEditor().selectNode(selType);
                    listView.handleButtonEnabling();
                }
            }
        };
        String language = "en";
        if (this.getDOM() != null) {
            language = this.getDOM().getLanguage();
        }
        String moveUpText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_up", "Up${ALT+U}");
        EventUtil.addKeyboardBinding((JComponent)this, (Action)moveUpAction, (String)EventUtil.parseAccelDefinitions((String)moveUpText)[1], (int)2);
        String moveDownText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_down", "Down${ALT+W}");
        EventUtil.addKeyboardBinding((JComponent)this, (Action)moveDownAction, (String)EventUtil.parseAccelDefinitions((String)moveDownText)[1], (int)2);
    }

    protected com.jaxfront.core.ui.TreeModel initTreeModel(Type rootType) {
        com.jaxfront.core.ui.TreeModel model = new com.jaxfront.core.ui.TreeModel(rootType);
        model.addTreeModelListener((TreeModelListener)this.getEditor());
        if (this.getDOM() != null) {
            this.getDOM().addDOMChangeListener((DOMChangeListener)this);
            this.getDOM().getController().addPropertyChangeListener((PropertyChangeListener)this);
        }
        return model;
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        DefaultPopUpMenu popup;
        Object source = e.getSource();
        if (source instanceof DefaultPopUpMenu && (popup = (DefaultPopUpMenu)source) != null && popup.getType() != null && popup.getType().getParent() != null && popup.getType().getParent().isList()) {
            ListType parList = popup.getType().getParentList();
            AbstractListTypeView listView = (AbstractListTypeView)TypeVisualizerFactory.getInstance().getVisualizer((Type)parList).getImplementation();
            if (listView != null) {
                listView.getMoveUpAction().setEnabled(false);
                listView.getMoveDownAction().setEnabled(false);
            }
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getSource().getClass() != NavigationTree.class) {
            super.processMouseEvent(e);
        } else if (e.isPopupTrigger()) {
            this.checkPopUp(e);
        } else if (e.getButton() == 3) {
            if (this.getSelectionCount() <= 1) {
                super.processMouseEvent(e);
            }
        } else if (this.getEditor() != null) {
            this.getEditor().setIsSelectingTreeNode(true);
            super.processMouseEvent(e);
            this.getEditor().setIsSelectingTreeNode(false);
        }
    }

    public void release() {
        this._treeCellRenderer = null;
        if (this.getDOM() != null) {
            this.getDOM().removeDOMChangeListener((DOMChangeListener)this);
            this.getDOM().getPropertyChangeSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.getModel() != null) {
            ((com.jaxfront.core.ui.TreeModel)this.getModel()).release();
        }
        this.removeAll();
        if (this._olListener != null) {
            this._olListener.release();
        }
        this._editor = null;
        this._treeTypes = null;
    }

    private void removeNode(TreeNode selectedNode) {
        if (selectedNode != null && selectedNode.getType() != null) {
            Vector<Type> typesToDelete = new Vector<Type>(1);
            typesToDelete.add(selectedNode.getType());
            this.removeNodes(typesToDelete);
        }
    }

    private void removeNodes() {
        TreePath[] paths = this.getSelectionPaths();
        Vector<Type> typesToDelete = new Vector<Type>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            TreeNode aSNode = (TreeNode)paths[i].getLastPathComponent();
            typesToDelete.add(aSNode.getType());
        }
        this.removeNodes(typesToDelete);
    }

    private void removeNodes(Vector typesToDelete) {
        ListType parentList;
        this.setMultiSelectOperation(true);
        boolean wasCompoundEdit = this.getDOM().getUndoManager().isInCompoundEditState();
        this.getDOM().getUndoManager().startCompoundEdit();
        ListType listType = parentList = typesToDelete.size() > 0 ? ((Type)typesToDelete.get(0)).getParentList() : null;
        if (parentList != null) {
            ((AbstractListTypeView)TypeVisualizerFactory.getInstance().getVisualizer((Type)parentList).getImplementation()).delete(typesToDelete);
        }
        if (!wasCompoundEdit) {
            this.getDOM().getUndoManager().stopCompoundEdit();
        }
        this.setMultiSelectOperation(false);
        if (parentList != null && parentList.size() == 0) {
            this.getEditor().clearWorkbench();
            TreeNode nodeToVisualize = this.getNode((Type)parentList);
            if (nodeToVisualize != null) {
                this.getEditor().getWorkspace().visualize(this.getNode((Type)parentList), true);
            }
        } else {
            TreeNode nodeToVisualize = this.getNode((Type)parentList.get(0));
            if (nodeToVisualize != null) {
                this.getEditor().getWorkspace().visualize(nodeToVisualize, true);
            }
        }
    }

    private void copyNode() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        this.copyNode(selectedNode);
    }

    private void addNodeAfter() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectedNode.getType().getParent().isList()) {
            int currentPos = selectedNode.getType().getParentList().indexOf((Object)selectedNode.getType());
            Type newType = ((ListType)selectedNode.getType().getParent()).addNewChild(currentPos + 1);
            this.getEditor().selectNode(newType);
            ListVisualizer listVisualizer = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)selectedNode.getType().getParentList(), false);
            if (listVisualizer != null) {
                listVisualizer.refresh();
            }
        }
    }

    private void addNodeBefore() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectedNode.getType().getParent().isList()) {
            int currentPos = selectedNode.getType().getParentList().indexOf((Object)selectedNode.getType());
            Type newType = ((ListType)selectedNode.getType().getParent()).addNewChild(currentPos);
            this.getEditor().selectNode(newType);
            ListVisualizer listVisualizer = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer((Type)selectedNode.getType().getParentList(), false);
            if (listVisualizer != null) {
                listVisualizer.refresh();
            }
        }
    }

    private void copyNode(TreeNode selectedNode) {
        if (selectedNode != null && selectedNode.getType().getParent().isList()) {
            Type newType = ((ListType)selectedNode.getType().getParent()).addNewChild(selectedNode.getType());
            this.getEditor().selectNode(newType);
        }
    }

    private void copyNodes() {
        this.setMultiSelectOperation(true);
        TreePath[] paths = this.getSelectionPaths();
        boolean wasCompoundEdit = this.getDOM().getUndoManager().isInCompoundEditState();
        this.getDOM().getUndoManager().startCompoundEdit();
        for (int i = 0; i < paths.length; ++i) {
            TreeNode aSNode = (TreeNode)paths[i].getLastPathComponent();
            this.copyNode(aSNode);
        }
        if (!wasCompoundEdit) {
            this.getDOM().getUndoManager().stopCompoundEdit();
        }
        this.setMultiSelectOperation(false);
    }

    private void addNode() {
        TreeNode selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectedNode != null) {
            if (selectedNode.getType().isList()) {
                ((ListType)selectedNode.getType()).addNewChild();
            } else if (selectedNode.getType().getParent().isList()) {
                ((ListType)selectedNode.getType().getParent()).addNewChild();
            }
        }
    }

    public TreeCellRenderer getRenderer() {
        return this._treeCellRenderer;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        TreeNode selectedNode;
        if (this.getSelectionPath() != null && (selectedNode = (TreeNode)this.getSelectionPath().getLastPathComponent()) != null && this.getEditor() != null && !this.getEditor().isSelectingTreeNode() && selectedNode.getType().isRenderable()) {
            this.getEditor().setHighLightMode(true);
            TreePath treePath = new TreePath(selectedNode.getPath());
            this.getSelectionModel().removeSelectionPath(treePath);
            ((DefaultTreeModel)this.getModel()).reload((javax.swing.tree.TreeNode)selectedNode);
            this.getSelectionModel().setSelectionPath(treePath);
            this.getEditor().setHighLightMode(false);
        }
        this.maintainIcons((TreeNode)this.getModel().getRoot());
    }

    public void addSelectionPath(TreePath path) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        Type aType = node.getType();
        TreePath[] paths = this.getSelectionPaths();
        Type cParent = aType.getParent();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                TreeNode aSNode = (TreeNode)paths[i].getLastPathComponent();
                Type aSType = aSNode.getType();
                if (aSType.getParent() == cParent) continue;
                return;
            }
        }
        super.addSelectionPath(path);
    }

    public boolean isMultiSelectOperation() {
        return this._isMultiSelectOperation;
    }

    public void setMultiSelectOperation(boolean multi) {
        this._isMultiSelectOperation = multi;
    }

    public void stopAllCellEditing() {
        Vector allVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(this.getDOM());
        for (int i = 0; i < allVisualizers.size(); ++i) {
            Visualizer vis = ((Visualizer)allVisualizers.get(i)).getImplementation();
            if (!(vis instanceof AbstractListTypeView)) continue;
            ((AbstractListTypeView)vis).stopCellEditing();
        }
    }

    public AbstractEditorPanel getEditor() {
        return this._editor;
    }

    public String getSelectedXPath() {
        StringBuffer xpath = new StringBuffer();
        TreePath leadPath = this.getLeadSelectionPath();
        return leadPath.toString();
    }

    private class RootType
    extends ComplexGroup {
        public RootType(List types) {
            super(null, null);
            this._types = types;
        }

        public String getName() {
            return "root";
        }

        public boolean isChoice() {
            return false;
        }

        public XUIDefinition getXUIDefinition() {
            return this.getXUIDefinition(false);
        }

        public XUIDefinition getXUIDefinition(boolean lazyInit) {
            if (this._uiDefinition == null) {
                this._uiDefinition = new XUIDefinition((Type)this, null);
            }
            return this._uiDefinition;
        }
    }
}

