/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.swing.ui.tools.FontFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class NavigationTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private JCheckBox _checkBox = new JCheckBox();
    private static Font _leafFont = FontFactory.getTreeEntryFontDefinition().createFont();
    private static Font _leafFolderFont = FontFactory.getTreeEntryFolderFontDefinition().createFont();
    private DefaultTreeCellRenderer _delegate;
    private TreeNode _treeNode;

    public NavigationTreeCellRenderer(DefaultTreeCellRenderer delegate) {
        this._delegate = delegate;
        this.setLayout(new BorderLayout());
        this.setVisible(true);
        this.setOpaque(false);
        this._checkBox.setOpaque(false);
        if (this._checkBox != null) {
            this._checkBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (NavigationTreeCellRenderer.this._treeNode != null) {
                        NavigationTreeCellRenderer.this._treeNode.setIsCheckBoxSelected(NavigationTreeCellRenderer.this._checkBox.isSelected());
                    }
                }
            });
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String toolTip;
        String visualName = "";
        if (!(value instanceof TreeNode)) {
            return this._delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
        this._treeNode = (TreeNode)value;
        visualName = this._treeNode.getVisualName();
        TreeNode treeNode = (TreeNode)value;
        Type type = treeNode.getType();
        if (type != null && (toolTip = treeNode.getToolTip()) != null) {
            this.setToolTipText(toolTip);
        }
        this.handleIcon(expanded, leaf, treeNode);
        if (leaf) {
            this._delegate.setFont(_leafFont);
        } else {
            this._delegate.setFont(_leafFolderFont);
        }
        Object formulaResult = null;
        if (treeNode.showCheckBox()) {
            Component defaultComponent = this._delegate.getTreeCellRendererComponent(tree, visualName, sel, expanded, leaf, row, hasFocus);
            this.removeAll();
            this.setBorder(null);
            if (treeNode.getIcon() != null) {
                this.add((Component)new JLabel(treeNode.getIcon()), "West");
            }
            this.add((Component)this._checkBox, "Center");
            this.add(defaultComponent, "East");
            this._checkBox.setSelected(treeNode.isCheckBoxSelected());
            return this;
        }
        if (type != null && (formulaResult = type.getStyle().getTreeLabelFormulaResult()) instanceof SimpleType) {
            Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer((Type)formulaResult, type, true);
            if (vis instanceof SimpleTypeVisualizer) {
                this.removeAll();
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
                int height = 22;
                if (treeNode.getIcon() != null) {
                    height = treeNode.getIcon().getIconHeight();
                }
                this.setPreferredSize(new Dimension(120, height));
                if (treeNode.getIcon() != null) {
                    JPanel iconPanel = new JPanel(new BorderLayout());
                    iconPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("Tree.background"));
                    iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
                    iconPanel.add((Component)new JLabel(treeNode.getIcon()), "Center");
                    this.add((Component)iconPanel, "West");
                }
                JComponent editorField = ((SimpleTypeVisualizer)vis).getEditorField();
                editorField.setBorder(null);
                this.add((Component)editorField, "Center");
                return this;
            }
            return this._delegate.getTreeCellRendererComponent(tree, visualName, sel, expanded, leaf, row, hasFocus);
        }
        return this._delegate.getTreeCellRendererComponent(tree, visualName, sel, expanded, leaf, row, hasFocus);
    }

    private void handleIcon(boolean expanded, boolean leaf, TreeNode treeNode) {
        if (treeNode.getIcon() != null) {
            if (leaf) {
                this._delegate.setLeafIcon(treeNode.getIcon());
            } else if (expanded) {
                this._delegate.setOpenIcon(treeNode.getIcon());
            } else {
                this._delegate.setClosedIcon(treeNode.getIcon());
            }
        } else if (leaf) {
            this._delegate.setLeafIcon(this._delegate.getDefaultLeafIcon());
        } else if (expanded) {
            this._delegate.setOpenIcon(this._delegate.getDefaultOpenIcon());
        } else {
            this._delegate.setClosedIcon(this._delegate.getDefaultClosedIcon());
        }
    }

    public JCheckBox getCheckBox() {
        return this._checkBox;
    }
}

