/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ListLayout
implements LayoutManager {
    private int _space;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int _orientation = 1;

    public ListLayout() {
    }

    public ListLayout(int space) {
        this._space = space;
    }

    public ListLayout(int space, int orientation) {
        this._space = space;
        this._orientation = orientation;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        int x = 0;
        int y = 0;
        int xpos = parent.getInsets().left;
        int ypos = parent.getInsets().top;
        int width = parent.getSize().width - parent.getInsets().left - parent.getInsets().right;
        int height = parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom;
        int numberOfComponents = parent.getComponentCount();
        block3: for (int i = 0; i < numberOfComponents; ++i) {
            Component currentComp = parent.getComponent(i);
            switch (this.getOrientation()) {
                case 0: {
                    int ww = currentComp.getPreferredSize().width;
                    int hh = currentComp.getPreferredSize().height;
                    if (currentComp != null) {
                        currentComp.setBounds(xpos + x, ypos + y, ww, hh);
                    }
                    x += ww + this._space;
                    continue block3;
                }
                default: {
                    int hh = currentComp.getPreferredSize().height;
                    if (currentComp != null && y < height) {
                        currentComp.setBounds(xpos + x, ypos + y, width, hh);
                    }
                    y += hh + this._space;
                }
            }
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Border border;
        int w = 0;
        int h = 0;
        int comps = parent.getComponentCount();
        block6: for (int i = 0; i < comps; ++i) {
            Component comp = parent.getComponent(i);
            if (comp == null) continue;
            Dimension dim = comp.getPreferredSize();
            switch (this.getOrientation()) {
                case 0: {
                    w += dim.width + this._space;
                    h = Math.max(h, dim.height);
                    continue block6;
                }
                default: {
                    w = Math.max(w, dim.width);
                    h += dim.height + this._space;
                }
            }
        }
        h -= this._space;
        if (parent instanceof JComponent && (border = ((JComponent)parent).getBorder()) != null) {
            Insets insets = border.getBorderInsets(parent);
            switch (this.getOrientation()) {
                case 0: {
                    w += insets.left + insets.right;
                    break;
                }
                default: {
                    h += insets.top + insets.bottom;
                }
            }
        }
        return new Dimension(w, h);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setOrientation(int _orientation) {
        this._orientation = _orientation;
    }

    public int getOrientation() {
        return this._orientation;
    }
}

