/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.alphase.lic.License;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.swing.ui.beans.MouseLinkAdapter;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class LicenseCheckerDialog
extends JDialog
implements ActionListener {
    private Frame _frame;
    private JDialog _licenseAcceptanceDialog;
    private int _errorCode;
    private String _fileLocation;
    private boolean _closeByError;
    private boolean _closeIfInvalidLicense;
    private boolean _allowEnterLicense;
    private JRadioButton _noButton;
    private JRadioButton _yesButton;

    public LicenseCheckerDialog(Frame frame, String title, boolean closeByError, int errorCode) {
        this(frame, title, closeByError, false, errorCode);
    }

    public LicenseCheckerDialog(Frame frame, String title, boolean closeByError, boolean closeIfInvalidLicense, int errorCode, boolean allowEnterLicense) {
        super(frame, title, true);
        this._frame = frame;
        this._closeByError = closeByError;
        this._errorCode = errorCode;
        this._closeIfInvalidLicense = closeIfInvalidLicense;
        this._allowEnterLicense = allowEnterLicense;
        this.init();
    }

    public LicenseCheckerDialog(Frame frame, String title, boolean closeByError, boolean closeIfInvalidLicense, int errorCode) {
        this(frame, title, closeByError, closeIfInvalidLicense, errorCode, true);
    }

    private void cancelLicense() {
        this.setVisible(false);
        if (this._closeByError) {
            System.exit(0);
        }
    }

    private void enterLicense() {
        FileDialog fileDialog = new FileDialog(this._frame, "Choose License File");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            this.verifyLicense(fileDialog.getDirectory() + fileDialog.getFile());
            if (LicenseChecker.getInstance().hasValidLicense()) {
                this._fileLocation = fileDialog.getDirectory() + fileDialog.getFile();
                this.getLicenseAcceptanceDialog().setVisible(true);
            }
            this.refresh();
        }
    }

    private void verifyLicense(String fileName) {
        License lic = LicenseChecker.verifyLicense((String)fileName);
        this._errorCode = lic.LicenseVal < 0 ? lic.LicenseVal : 0;
    }

    private void init() {
        Object license = null;
        this.refresh();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                LicenseCheckerDialog.this.cancelLicense();
            }

            public void windowClosing(WindowEvent e) {
                LicenseCheckerDialog.this.cancelLicense();
            }
        });
    }

    private void refresh() {
        String colSpec = "100px,450px";
        String rowSpec = "pref,pref,pref,pref,pref,pref,pref,pref";
        FormLayout tableLayout = new FormLayout(colSpec, rowSpec);
        JPanel panel = new JPanel(tableLayout);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        JButton enterLicense = new JButton(GUIComponentNLS.getInstance().getNLSText("enter_license", "Enter license"));
        enterLicense.setActionCommand("enterLicense");
        ActionAdapter actionAdapter = new ActionAdapter();
        enterLicense.addActionListener(actionAdapter);
        JButton requestLicense = new JButton(GUIComponentNLS.getInstance().getNLSText("request_license_key", "Request license"));
        MouseLinkAdapter adapter = new MouseLinkAdapter(requestLicense);
        adapter.setHTTPURL("mailto:info@jaxfront.com");
        requestLicense.addMouseListener(adapter);
        String colSpecific = "0:g(0.6),0:g(0.05),0:g(0.35)";
        String rowSpecific = "pref,pref,pref,pref";
        FormLayout actionTableLayout = new FormLayout(colSpecific, rowSpecific);
        JPanel actionPanel = new JPanel(actionTableLayout);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton saveButton = new JButton(GUIComponentNLS.getInstance().getNLSText("button_save", "Save"));
        saveButton.setActionCommand("save");
        saveButton.addActionListener(actionAdapter);
        JButton cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText("button_cancel", "Cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(actionAdapter);
        buttonPanel.add((Component)saveButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        panel.add((Component)new HeaderPanel(null, "", 0, 2, 0, Color.YELLOW, Color.BLACK, UIManager.getColor("Label.background"), 0, FontTools.getFont("Verdana", 14.0f).deriveFont(1), null), "1,1,2,1");
        panel.add((Component)new JLabel(" " + GUIComponentNLS.getInstance().getNLSText("license_produkt", " Product:")), "1,4");
        panel.add((Component)new JLabel(" " + GUIComponentNLS.getInstance().getNLSText("license_version", " Version:")), "1,3");
        JLabel customerLabel = new JLabel(" " + GUIComponentNLS.getInstance().getNLSText("license_customer", " Customer:"));
        customerLabel.setFont(FontTools.getBoldFont(11.0f));
        panel.add((Component)customerLabel, "1,2");
        panel.add((Component)new JLabel(" " + GUIComponentNLS.getInstance().getNLSText("license_expires", " Expires:")), "1,5");
        panel.add((Component)new HeaderPanel("", 1), "1,6,1,1");
        actionPanel.add((Component)new JLabel("1) " + GUIComponentNLS.getInstance().getNLSText("license_wish_evaluate", "if you wish to evaluate/order JAXFront, click here")), "1,1");
        actionPanel.add((Component)requestLicense, "3,1");
        if (this._allowEnterLicense) {
            actionPanel.add((Component)new JLabel("2) " + GUIComponentNLS.getInstance().getNLSText("license_received_key_code", "if you have received an email with a key-code, press here")), "1,2");
            actionPanel.add((Component)enterLicense, "3,2");
            actionPanel.add((Component)buttonPanel, "1,4,3,1");
        }
        actionPanel.add((Component)new HeaderPanel("", 1), "1,3,3,1");
        panel.add((Component)actionPanel, "1,7,2,1");
        License lic = LicenseChecker.getLicense();
        if (LicenseChecker.getInstance().hasValidLicense()) {
            panel.add((Component)new JLabel(LicenseChecker.getLicense().Product), "2,4");
            LicenseChecker.getInstance();
            panel.add((Component)new JLabel(LicenseChecker.getVersion()), "2,3");
            customerLabel = new JLabel(LicenseChecker.getLicense().Customer);
            customerLabel.setFont(FontTools.getBoldFont(11.0f));
            panel.add((Component)customerLabel, "2,2");
            panel.add((Component)new JLabel(LicenseChecker.getLicense().ExDate), "2,5");
            buttonPanel.add((Component)new JLabel(""), "Center");
        } else {
            panel.add((Component)new JLabel(" (no License installed)"), "2,2");
            if (this._errorCode < 0) {
                String errorText = null;
                switch (this._errorCode) {
                    case -1: {
                        errorText = "-1 Missing file specification.";
                        break;
                    }
                    case -2: {
                        errorText = "-2 Can't find license file.";
                        break;
                    }
                    case -3: {
                        errorText = "-3 Product line is missing.";
                        break;
                    }
                    case -4: {
                        errorText = "-4 Customer line is issing.";
                        break;
                    }
                    case -5: {
                        errorText = "-5 License has expired.";
                        break;
                    }
                    case -6: {
                        errorText = "-6 Invalid License.";
                    }
                }
                JLabel error = new JLabel(errorText);
                error.setForeground(Color.red);
                buttonPanel.add((Component)error, "Center");
            }
        }
        panel.updateUI();
        this.pack();
        this.setLocationRelativeTo(this._frame);
    }

    private void saveLicense() {
        this.setVisible(false);
        if (LicenseChecker.getInstance().hasValidLicense()) {
            JAXFrontProperties.getInstance().setLicenseLocaction(this._fileLocation);
            try {
                JAXFrontProperties.getInstance().save();
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)e);
                Dialog.showErrorDialog(this, e.getMessage());
            }
        } else if (this._closeByError || this._closeIfInvalidLicense && this._errorCode < 0) {
            System.exit(0);
        }
    }

    private JDialog getLicenseAcceptanceDialog() {
        if (this._licenseAcceptanceDialog == null) {
            this._licenseAcceptanceDialog = new JDialog((java.awt.Dialog)this, "JAXFront License Agreement");
            this._licenseAcceptanceDialog.setDefaultCloseOperation(0);
            this._licenseAcceptanceDialog.setModal(true);
            this._licenseAcceptanceDialog.setSize(500, 500);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this._licenseAcceptanceDialog.setLocation((dimension.width - 500) / 2, (dimension.height - 500) / 2);
            this._licenseAcceptanceDialog.getContentPane().setLayout(new BorderLayout());
            JPanel acceptancePanel = new JPanel(new BorderLayout());
            acceptancePanel.add((Component)new JLabel("Do you accept this license agreement?"), "Center");
            ButtonGroup buttonGroup = new ButtonGroup();
            this._yesButton = new JRadioButton(GUIComponentNLS.getInstance().getNLSText("button_yes", "Yes"));
            this._noButton = new JRadioButton(GUIComponentNLS.getInstance().getNLSText("button_no", "No"));
            buttonGroup.add(this._yesButton);
            buttonGroup.add(this._noButton);
            this._yesButton.addActionListener(this);
            this._noButton.addActionListener(this);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(this._yesButton);
            buttonPanel.add(this._noButton);
            acceptancePanel.add((Component)buttonPanel, "South");
            JTextArea licenseTextArea = new JTextArea(10, 0);
            licenseTextArea.setText(JAXFrontProperties.getLicenceText());
            licenseTextArea.setLineWrap(true);
            licenseTextArea.setCaretPosition(0);
            licenseTextArea.setEditable(false);
            licenseTextArea.setWrapStyleWord(true);
            acceptancePanel.add((Component)licenseTextArea, "North");
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(acceptancePanel);
            scrollPane.setAutoscrolls(false);
            this._licenseAcceptanceDialog.getContentPane().add((Component)scrollPane, "Center");
        } else {
            this._yesButton.setSelected(false);
            this._noButton.setSelected(false);
        }
        return this._licenseAcceptanceDialog;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._yesButton) {
            this.getLicenseAcceptanceDialog().setVisible(false);
        } else if (e.getSource() == this._noButton) {
            this.verifyLicense(null);
            if (!LicenseChecker.getInstance().hasValidLicense()) {
                this._fileLocation = null;
            }
            this.getLicenseAcceptanceDialog().setVisible(false);
            this.refresh();
        }
    }

    class ActionAdapter
    implements ActionListener {
        ActionAdapter() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("enterLicense")) {
                LicenseCheckerDialog.this.enterLicense();
            } else if (event.getActionCommand().equals("save")) {
                LicenseCheckerDialog.this.saveLicense();
            } else if (event.getActionCommand().equals("cancel")) {
                LicenseCheckerDialog.this.cancelLicense();
            }
        }
    }
}

