/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.log.Log4JLogRegistry;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.log.Logger;
import com.jaxfront.core.util.JAXFrontProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public class LogPanel
extends JPanel
implements ItemListener {
    public static Category root = Category.getRoot();
    private WriterAppender appender;
    private PatternLayout layout;
    private Action clearAction;
    private final int MAXLINES = 1000;
    private JScrollPane pane = null;
    private JTextArea textarea = null;
    private LogWriter writer = new LogWriter(this);
    private JCheckBox offCB = null;
    private JCheckBox errorCB = null;
    private JCheckBox fatalCB = null;
    private JCheckBox infoCB = null;
    private JCheckBox logCB = null;
    private JCheckBox warnCB = null;

    public LogPanel() {
        this.appender = new WriterAppender((Layout)this.layout, (Writer)this.writer);
        Appender a1 = root.getAppender("ERROR");
        this.layout = a1 == null ? new PatternLayout("%d{HH:mm} [%-5p] %-25c - %m%n") : (PatternLayout)a1.getLayout();
        this.pane = new JScrollPane();
        this.textarea = new JTextArea();
        this.appender.setLayout((Layout)this.layout);
        this.setLayout(new BorderLayout());
        this.textarea.setEditable(false);
        this.pane.getViewport().add((Component)this.textarea, null);
        this.add((Component)this.pane, "Center");
        this.add((Component)this.buildControlPanel(), "North");
        this.add((Component)new JButton(this.getClearAction()), "South");
        root.addAppender((Appender)this.appender);
    }

    private Action getClearAction() {
        this.clearAction = new AbstractAction("ClearTrackings"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.textarea.setText("");
            }
        };
        return this.clearAction;
    }

    public JPanel buildControlPanel() {
        JPanel panel = new JPanel();
        this.errorCB = new JCheckBox("ERROR");
        this.fatalCB = new JCheckBox("FATAL");
        this.infoCB = new JCheckBox("INFO");
        this.logCB = new JCheckBox("LOG");
        this.warnCB = new JCheckBox("WARN");
        this.offCB = new JCheckBox("OFF");
        this.offCB.setSelected(!JAXFrontProperties.LOG_ENABLED);
        panel.add(this.offCB);
        panel.add(this.errorCB);
        panel.add(this.fatalCB);
        panel.add(this.infoCB);
        panel.add(this.logCB);
        panel.add(this.warnCB);
        String logLevel = JAXFrontProperties.getInstance()._logLevel;
        if (logLevel.equalsIgnoreCase("ERROR")) {
            this.errorCB.setSelected(true);
        } else if (logLevel.equalsIgnoreCase("FATAL")) {
            this.fatalCB.setSelected(true);
        } else if (logLevel.equalsIgnoreCase("INFO")) {
            this.infoCB.setSelected(true);
        } else if (logLevel.equalsIgnoreCase("LOG")) {
            this.logCB.setSelected(true);
        } else if (logLevel.equalsIgnoreCase("WARN")) {
            this.warnCB.setSelected(true);
        } else {
            this.offCB.setSelected(false);
        }
        this.fatalCB.addItemListener(this);
        this.errorCB.addItemListener(this);
        this.infoCB.addItemListener(this);
        this.logCB.addItemListener(this);
        this.warnCB.addItemListener(this);
        this.offCB.addItemListener(this);
        return panel;
    }

    public void setLogCheckBoxesEnabled(boolean enabled) {
        this.errorCB.setEnabled(enabled);
        this.fatalCB.setEnabled(enabled);
        this.infoCB.setEnabled(enabled);
        this.logCB.setEnabled(enabled);
        this.warnCB.setEnabled(enabled);
    }

    public void append(String s) {
        this.textarea.append(s);
        int len = this.textarea.getLineCount();
        if (len > 1000) {
            try {
                this.textarea.getDocument().remove(0, 5);
            }
            catch (BadLocationException exception) {
                exception.printStackTrace();
            }
        }
        Dimension size = this.textarea.getSize();
        JViewport port = this.pane.getViewport();
        Point point = new Point(0, size.height);
        port.setViewPosition(point);
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setFormat(String Format2) {
        this.layout.setConversionPattern(Format2);
    }

    public void itemStateChanged(ItemEvent e) {
        Logger logger = LogRegistry.getInstance().getLogger();
        if (e.getSource() == this.offCB) {
            this.setLogCheckBoxesEnabled(!this.offCB.isSelected());
            boolean bl = JAXFrontProperties.LOG_ENABLED = !this.offCB.isSelected();
            if (this.offCB.isSelected() && logger instanceof Log4JLogRegistry) {
                ((Log4JLogRegistry)logger).setLogLevels(new String[0]);
            } else if (logger instanceof Log4JLogRegistry) {
                ((Log4JLogRegistry)logger).setLogLevels(this.getLevels());
            }
        } else {
            logger.setLogLevels(this.getLevels());
        }
    }

    public String[] getLevels() {
        Vector<String> levels = new Vector<String>();
        if (this.errorCB.isSelected()) {
            levels.add("ERROR");
        }
        if (this.fatalCB.isSelected()) {
            levels.add("FATAL");
        }
        if (this.infoCB.isSelected()) {
            levels.add("INFO");
        }
        if (this.logCB.isSelected()) {
            levels.add("LOG");
        }
        if (this.warnCB.isSelected()) {
            levels.add("WARN");
        }
        String[] levelsArray = new String[levels.size()];
        for (int i = 0; i < levels.size(); ++i) {
            levelsArray[i] = (String)levels.get(i);
        }
        return levelsArray;
    }

    private class LogWriter
    extends Writer {
        private LogPanel logpanel;

        public LogWriter(LogPanel logframe) {
            this.logpanel = logframe;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(String text) {
            this.logpanel.append(text);
        }

        public void write(char[] parm1, int parm2, int parm3) throws IOException {
            this.write(String.valueOf(parm1, parm2, parm3));
        }
    }
}

