/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.error.Error;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class MessageTableCellRenderer
extends DefaultTableCellRenderer {
    private JTextArea _textArea = new JTextArea();
    private JScrollPane _scrollPane = new JScrollPane(this._textArea);
    private UIDefaults defaults = UIManager.getLookAndFeelDefaults();
    private Color selectionBackground = this.defaults.getColor("Table.selectionBackground");
    private Color selectionForeground = this.defaults.getColor("Table.selectionForeground");
    private Color background = this.defaults.getColor("Table.background");
    private Color foreground = this.defaults.getColor("Table.foreground");

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        if (isSelected) {
            this._textArea.setBackground(this.selectionBackground);
            this._textArea.setForeground(this.selectionForeground);
            this.setBackground(this.selectionBackground);
            this.setForeground(this.selectionForeground);
        } else {
            this._textArea.setBackground(this.background);
            this._textArea.setForeground(this.foreground);
            this.setBackground(this.background);
            this.setForeground(this.foreground);
        }
        if (value != null) {
            try {
                if (vColIndex == 0 && value instanceof Error) {
                    this.setIcon(((Error)value).getMessageIcon());
                    String messageClassification = ((Error)value).getMessageClassification();
                    this.setText(messageClassification);
                    this.setToolTipText(messageClassification);
                    this.setHorizontalAlignment(2);
                    this.setFont(this.defaults.getFont("Table.font"));
                }
                if (vColIndex == 1) {
                    this._textArea.setWrapStyleWord(true);
                    this._textArea.setLineWrap(true);
                    this._textArea.setText((String)value);
                    this._textArea.setFont(this.defaults.getFont("Table.font"));
                    int height_wanted = (int)this._textArea.getPreferredSize().getHeight();
                    if (height_wanted != table.getRowHeight(rowIndex)) {
                        table.setRowHeight(rowIndex, height_wanted);
                    }
                    this._scrollPane.setHorizontalScrollBarPolicy(31);
                    this._scrollPane.setVerticalScrollBarPolicy(21);
                    this._scrollPane.setBorder(null);
                    this._scrollPane.setToolTipText((String)value);
                    return this._scrollPane;
                }
                if (vColIndex == 2 && value instanceof Error) {
                    this.setIcon(((Error)value).getMessageContextIcon());
                    String messageContext = ((Error)value).getHolderXPath();
                    this.setText(((Error)value).getErrorHolder().getShortCaption());
                    this.setToolTipText(messageContext);
                    this.setHorizontalAlignment(2);
                    this.setFont(this.defaults.getFont("Table.font"));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return this;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

