/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JWindow;
import javax.swing.Timer;

public class ShadowedWindow
extends JWindow {
    private BufferedImage splash = null;

    public ShadowedWindow(Window owner, BufferedImage image) {
        super(owner);
        this.createShadowPicture(image);
    }

    public void paint(Graphics g) {
        if (this.splash != null) {
            g.drawImage(this.splash, 0, 0, null);
        }
    }

    private void createShadowPicture(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int extra = 14;
        this.setSize(new Dimension(width + extra, height + extra));
        this.setLocationRelativeTo(null);
        Rectangle windowRect = this.getBounds();
        this.splash = new BufferedImage(width + extra, height + extra, 2);
        Graphics2D g2 = (Graphics2D)this.splash.getGraphics();
        try {
            Robot robot = new Robot(this.getGraphicsConfiguration().getDevice());
            BufferedImage capture = robot.createScreenCapture(new Rectangle(windowRect.x, windowRect.y, windowRect.width + extra, windowRect.height + extra));
            g2.drawImage(capture, null, 0, 0);
        }
        catch (AWTException e) {
            // empty catch block
        }
        BufferedImage shadow = new BufferedImage(width + extra, height + extra, 2);
        Graphics g = shadow.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        g.fillRoundRect(6, 6, width, height, 12, 12);
        g2.drawImage(shadow, this.getBlurOp(7), 0, 0);
        g2.drawImage((Image)image, 0, 0, this);
    }

    private ConvolveOp getBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        for (int i = 0; i < data.length; ++i) {
            data[i] = value;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public static void main(String[] args) {
        try {
            BufferedImage image = ImageIO.read(ShadowedWindow.class.getResourceAsStream("images/splash.png"));
            ShadowedWindow window = new ShadowedWindow(null, image);
            window.setVisible(true);
            Timer timer = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.exit(0);
                }
            });
            timer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

