/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.search.DefaultTreeSearcher;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.core.util.search.SearchComparator;
import com.jaxfront.core.util.search.SearchResultProcessor;
import com.jaxfront.core.util.search.TypeNameComparator;
import com.jaxfront.core.util.search.TypeTreeNodeComparator;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.search.Find;
import com.jaxfront.swing.ui.tools.search.ResultTreeNodeCellRenderer;
import com.jaxfront.swing.ui.tools.search.ResultTypeCellRenderer;
import com.jaxfront.swing.ui.tools.search.TypeSearchTreeResultProcessor;
import java.awt.Component;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static void collapseJTreeNode(JTree tree, DefaultMutableTreeNode node, int depth) {
        if (node.isLeaf()) {
            return;
        }
        if (depth != 0) {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                TreeUtil.collapseJTreeNode(tree, childNode, depth - 1);
            }
            tree.collapsePath(new TreePath(node.getPath()));
        }
    }

    public static void collapseJTreeNodeUp(JTree tree, DefaultMutableTreeNode node, int depth) {
        if (node.getParent() == null) {
            return;
        }
        if (depth != 0) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            tree.collapsePath(new TreePath(node.getPath()));
            TreeUtil.collapseJTreeNodeUp(tree, parentNode, depth - 1);
        }
    }

    public static void expandJTreeNode(JTree tree, DefaultMutableTreeNode node, int depth) {
        if (node.isLeaf()) {
            return;
        }
        if (depth != 0) {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                TreeUtil.expandJTreeNode(tree, childNode, depth - 1);
            }
            tree.expandPath(new TreePath(node.getPath()));
        }
    }

    public static void expandJTreeNode(JTree tree, DefaultMutableTreeNode node, TreePath[] paths) {
        if (node.isLeaf()) {
            return;
        }
        if (paths != null) {
            for (int i = paths.length - 1; i >= 0; --i) {
                tree.expandPath(paths[i]);
            }
        }
    }

    public static int countNodes(JTree tree, DefaultMutableTreeNode node) {
        int count = 0;
        if (node.isLeaf()) {
            count = 1;
        } else {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                count += TreeUtil.countNodes(tree, childNode);
            }
        }
        return count;
    }

    public static void getTreeNodeStates(JTree tree, DefaultMutableTreeNode node, Vector foundExpandedNodes, Stack pathHierarchy) {
        TreePath path;
        if (node instanceof TreeNode) {
            pathHierarchy.push(((TreeNode)node).getType().getName());
        }
        if (tree.isExpanded(path = new TreePath(node.getPath()))) {
            foundExpandedNodes.add(pathHierarchy.toArray());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            TreeUtil.getTreeNodeStates(tree, childNode, foundExpandedNodes, pathHierarchy);
        }
        pathHierarchy.pop();
    }

    public static void setTreeNodeStates(JTree tree, TreeNode node, Vector expandedNodePaths, int start) {
        for (int e = start; e < expandedNodePaths.size(); ++e) {
            TreeUtil.setTreeNodeStates(tree, node, (Object[])expandedNodePaths.get(e), 0);
        }
    }

    private static void setTreeNodeStates(JTree tree, TreeNode node, Object[] expandedNodePath, int pos) {
        if (pos < expandedNodePath.length) {
            String name = (String)expandedNodePath[pos];
            String nodeName = node.getType().getName();
            if (nodeName.equals(name)) {
                tree.expandPath(new TreePath(node.getPath()));
                ++pos;
                for (int c = 0; c < node.getChildCount(); ++c) {
                    TreeUtil.setTreeNodeStates(tree, (TreeNode)node.getChildAt(c), expandedNodePath, pos);
                }
            }
        }
    }

    public static void searchTreeNode(JTree tree, TreeModel model, DefaultMutableTreeNode node, int depth, String searchText, Vector foundNodes, boolean caseSensitive) {
        String nodeValue = "";
        int pos = -1;
        nodeValue = node.toString();
        if (nodeValue != null && (pos = caseSensitive ? nodeValue.indexOf(searchText) : StringUtil.indexOfIgnoreCase((String)nodeValue, (String)searchText, (int)0)) >= 0) {
            foundNodes.add(node);
        }
        if (depth != 0) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                TreeUtil.searchTreeNode(tree, model, childNode, depth - 1, searchText, foundNodes, caseSensitive);
            }
        }
    }

    public static DefaultMutableTreeNode searchTypeTreeNode(DefaultMutableTreeNode baseNode, int depth, Type searchedType) {
        Type aType;
        if (baseNode instanceof TreeNode ? (aType = ((TreeNode)baseNode).getType()) == searchedType : baseNode.getUserObject() instanceof Type && (aType = (Type)baseNode.getUserObject()) == searchedType) {
            return baseNode;
        }
        if (depth != 0) {
            for (int i = 0; i < baseNode.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)baseNode.getChildAt(i);
                DefaultMutableTreeNode childResult = TreeUtil.searchTypeTreeNode(childNode, depth - 1, searchedType);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    public static void jumpTo(JTree tree, TreePath path) {
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public static void collapseTo(JTree tree, TreePath path) {
        tree.collapsePath(path);
    }

    public static void searchForNodes(JTree tree, Component aComponent, String searchDialogHeader, String foundNodeDialogHeader) {
        Find find = Find.getSharedInstance(GUITools.createDialogFor(aComponent));
        DefaultTreeSearcher search = new DefaultTreeSearcher(tree);
        search.setComparator((SearchComparator)new TypeNameComparator());
        find.setSearcher((Search)search);
        find.setResultProcessor((SearchResultProcessor)new TypeSearchTreeResultProcessor(tree));
        find.setListRenderer(new ResultTypeCellRenderer());
        find.showFind();
    }

    public static void searchForTypeNodes(JTree tree, Component aComponent, String searchDialogHeader, String foundNodeDialogHeader) {
        Find find = Find.getSharedInstance(GUITools.createDialogFor(aComponent));
        GUITools.centerRelativeToParent(aComponent, find);
        DefaultTreeSearcher search = new DefaultTreeSearcher(tree);
        search.setComparator((SearchComparator)new TypeTreeNodeComparator());
        find.setSearcher((Search)search);
        find.setResultProcessor((SearchResultProcessor)new TypeSearchTreeResultProcessor(tree));
        find.setListRenderer(new ResultTreeNodeCellRenderer());
        find.showFind();
    }

    public static boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public static String getExpansionState(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        StringBuffer buf = new StringBuffer();
        int rowCount = tree.getRowCount();
        for (int i = row; i < rowCount; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (i != row && !TreeUtil.isDescendant(path, rowPath)) break;
            if (!tree.isExpanded(path)) continue;
            buf.append("," + String.valueOf(i - row));
        }
        return buf.toString();
    }

    public static boolean isExpandend(JTree tree, DefaultMutableTreeNode selectedNode) {
        return tree.isExpanded(new TreePath(selectedNode.getPath()));
    }

    public static boolean isCollapsed(JTree tree, DefaultMutableTreeNode selectedNode) {
        return tree.isCollapsed(new TreePath(selectedNode.getPath()));
    }

    public static void restoreExpanstionState(JTree tree, int row, String expansionState) {
        StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while (stok.hasMoreTokens()) {
            int token = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token);
        }
    }
}

