/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.mask;

import com.jaxfront.swing.ui.tools.mask.MaskToken;
import java.util.Vector;

public class MaskTokenizer {
    protected Vector tokens = new Vector();
    protected String include;
    protected String exclude;
    protected int pos = 0;

    public MaskTokenizer(String include, String exclude) {
        this.include = include;
        this.exclude = exclude;
    }

    public void tokenize(String text) {
        int prev = 0;
        this.tokens.removeAllElements();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (this.include.indexOf(text.charAt(i)) > -1) {
                if (buffer.length() > 0) {
                    this.tokens.addElement(new MaskToken(prev, buffer.toString()));
                }
                this.tokens.addElement(new MaskToken(i, "" + text.charAt(i)));
                buffer.setLength(0);
                prev = i + 1;
                continue;
            }
            if (this.exclude.indexOf(text.charAt(i)) > -1) {
                if (buffer.length() > 0) {
                    this.tokens.addElement(new MaskToken(prev, buffer.toString()));
                }
                buffer.setLength(0);
                prev = i + 1;
                continue;
            }
            buffer.append(text.charAt(i));
        }
        if (buffer.length() > 0) {
            this.tokens.addElement(new MaskToken(prev, buffer.toString()));
        }
    }

    public boolean hasMoreTokens() {
        return this.pos < this.tokens.size();
    }

    public MaskToken nextToken() {
        return (MaskToken)this.tokens.elementAt(this.pos++);
    }

    public void ignoreToken() {
        if (this.pos > 0) {
            --this.pos;
        }
    }

    public static void main(String[] args) {
        MaskTokenizer tokenizer = new MaskTokenizer("-,", " \t\n");
        String text = "123-45-6--7,234  2423";
        tokenizer.tokenize(text);
        System.out.println(text);
        while (tokenizer.hasMoreTokens()) {
            System.out.println(tokenizer.nextToken());
        }
    }
}

