/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SelectionTableModel
implements TableModel {
    private TableModel theRealTableModel;
    private Vector _selections;

    public SelectionTableModel(TableModel aRealModel) {
        this.theRealTableModel = aRealModel;
    }

    public SelectionTableModel() {
        this.theRealTableModel = new DefaultTableModel();
    }

    public int getColumnCount() {
        return this.theRealTableModel.getColumnCount() + 1;
    }

    public int getRowCount() {
        return this.theRealTableModel.getRowCount();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return true;
        }
        return this.theRealTableModel.isCellEditable(rowIndex, columnIndex - 1);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return this.theRealTableModel.getColumnClass(columnIndex - 1);
    }

    public Vector getSelections() {
        if (this._selections == null) {
            this._selections = new Vector();
        }
        return this._selections;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getSelectionValue(rowIndex);
        }
        return this.theRealTableModel.getValueAt(rowIndex, columnIndex - 1);
    }

    public Object getSelectionValue(int row) {
        if (row >= 0 && row <= this.getSelections().size()) {
            return this.getSelections().get(row);
        }
        return null;
    }

    public void setSelectionValue(int row, Object aValue) {
        if (row >= 0 && row < this.getSelections().size()) {
            this.getSelections().remove(row);
            this.getSelections().add(row, aValue);
        } else if (row == -1) {
            this.getSelections().add(aValue);
        }
        ((DefaultTableModel)this.theRealTableModel).fireTableRowsUpdated(row, row);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.setSelectionValue(rowIndex, aValue);
        } else {
            this.theRealTableModel.setValueAt(aValue, rowIndex, columnIndex - 1);
        }
    }

    public void addRow(Object[] rowData) {
        for (int i = 0; i < rowData.length; ++i) {
            if (i == 0) {
                this.setSelectionValue(-1, rowData[0]);
                continue;
            }
            if (this.theRealTableModel.getColumnCount() < i) {
                ((DefaultTableModel)this.theRealTableModel).addColumn("Value");
            }
            ((DefaultTableModel)this.theRealTableModel).addRow(new Object[]{rowData[1]});
        }
    }

    public void addRow(Vector rowData) {
        this.addRow(rowData.toArray());
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Selected";
        }
        return this.theRealTableModel.getColumnName(columnIndex - 1);
    }

    public void addTableModelListener(TableModelListener l) {
        this.theRealTableModel.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.theRealTableModel.addTableModelListener(l);
    }

    public List getSelectedValues() {
        Vector<Object> result = new Vector<Object>();
        for (int r = 0; r < this.getRowCount(); ++r) {
            Boolean selectedBoolean = (Boolean)this.getValueAt(r, 0);
            if (!selectedBoolean.booleanValue()) continue;
            result.add(this.getValueAt(r, 1));
        }
        return result;
    }
}

