/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageVisualizer
extends AbstractSimpleTypeView
implements MouseListener {
    private FileSelector _fileSelector = null;
    private JButton _selectFileButton = null;
    private boolean _showSelect = false;
    private JLabel _imageLabel = null;
    private byte[] _imageData = null;
    private int _maxHeight = -1;
    private int _maxWidth = -1;

    public ImageVisualizer() {
    }

    public ImageVisualizer(SimpleType simpleType) {
        this.setModel((Type)simpleType);
    }

    public ImageVisualizer(boolean showSelect) {
        this(showSelect, 600, 800);
    }

    public ImageVisualizer(boolean showSelect, int maxImageHeight, int maxImageWidth) {
        this._showSelect = showSelect;
        this._maxHeight = maxImageHeight;
        this._maxWidth = maxImageWidth;
    }

    protected JComponent createEditorComponent() {
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.add((Component)this.getImageLabel(), "Center");
        this.createSelectButton(editorPanel);
        this.setSelectButtonVisible(this._showSelect);
        this._editorComponent = editorPanel;
        return this._editorComponent;
    }

    private void setSelectButtonVisible(boolean visible) {
        this.getSelectFileButton().setVisible(visible);
    }

    private void createSelectButton(JPanel editorPanel) {
        FileSelector fileSelector = new FileSelector(GUIComponentNLS.getInstance().getNLSText("dialog_fileselection", "File Selection"));
        fileSelector.setCurrentFileFilter("gif", ".gif", false);
        fileSelector.addFileFilter("jpg", ".jpg", false);
        this.setFileSelector(fileSelector);
        editorPanel.add((Component)this.getSelectFileButton(), "South");
        this.initActions();
    }

    protected void defaultBuild() {
        super.defaultBuild();
    }

    public void addFileFilter(String suffix, String description, boolean allowDirectories) {
        if (this.getFileSelector() != null) {
            this.getFileSelector().addFileFilter(suffix, description, allowDirectories);
        }
    }

    public void populateModel() {
        String newValue;
        String oldModelValue = this.getValue();
        if (oldModelValue == null) {
            oldModelValue = "";
        }
        if ((newValue = this.getText()) == null || !oldModelValue.equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public void populateView() {
        if (this.getValue() != null) {
            this.setText(this.getValue());
        }
    }

    private void setText(String value) {
        if (value != null) {
            try {
                this._imageData = TextTools.decodeBase64Ziped((String)value);
                this.getImageLabel().setIcon(new ImageIcon(this._imageData));
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)e);
                this.getSelectFileButton().setVisible(true);
            }
        }
    }

    private void setButtonLabel() {
        String text = GUIComponentNLS.getInstance().getNLSText("button_select", "Select");
        if (this._maxHeight != -1 || this._maxWidth != -1) {
            text = text + " (h:" + this._maxHeight + ",w:" + this._maxWidth + ")";
        }
        this._selectFileButton.setText(text);
    }

    private void setValue(String value) {
        ((SimpleType)this.getModel()).setValue(value);
    }

    private void showDialog() {
        EditablePanel editablePanel = this.getModel().getDOM().getEditor();
        if (editablePanel != null) {
            this.getFileSelector().setRootDir(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile());
            this.getFileSelector().showOpenDialog((Component)editablePanel.getWindow());
            if (this.getFileSelector().getSelectedFile() != null && this.getFileSelector().hasSelectionChanged()) {
                String currentValue = null;
                currentValue = this.getFileSelector().getSelectedFile().toString();
                currentValue = TextTools.replace((String)currentValue, (String)"\\", (String)"/");
                currentValue = "file:/" + currentValue;
                try {
                    this._imageData = FileHelper.readFile((String)currentValue);
                    ImageIcon imageIcon = new ImageIcon(this._imageData);
                    boolean isImageOversized = false;
                    if (imageIcon != null && (this._maxHeight != -1 || this._maxWidth != -1)) {
                        int height = imageIcon.getIconHeight();
                        int width = imageIcon.getIconWidth();
                        if (this._maxHeight != -1 && height > this._maxHeight || this._maxWidth != -1 && width > this._maxWidth) {
                            isImageOversized = true;
                        }
                    }
                    if (isImageOversized) {
                        this._selectFileButton.setText("Image to big.");
                    } else {
                        this.getImageLabel().setIcon(imageIcon);
                        this.setButtonLabel();
                    }
                    if (imageIcon != null && (imageIcon.getIconHeight() == -1 || isImageOversized)) {
                        this._imageData = null;
                        this.setSelectButtonVisible(true);
                    }
                    this.populateModel();
                }
                catch (IOException e) {
                    this.getSelectFileButton().setVisible(true);
                }
            }
        }
    }

    public void initActions() {
        this.getSelectFileButton().addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ImageVisualizer.this.populateModel();
                ImageVisualizer.this.showDialog();
            }
        });
    }

    private void setFileSelector(FileSelector _fileSelector) {
        this._fileSelector = _fileSelector;
    }

    private FileSelector getFileSelector() {
        return this._fileSelector;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEditorField() != null) {
            this.getEditorField().setEnabled(enabled);
        }
        if (this.getSelectFileButton() != null) {
            this.getSelectFileButton().setEnabled(enabled);
        }
    }

    public String getText() {
        if (this._imageData != null) {
            try {
                return TextTools.encodeBase64Ziped((byte[])this._imageData);
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)e);
            }
        }
        return "";
    }

    private String getValue() {
        if (this.getModel() != null) {
            return ((SimpleType)this.getModel()).getValue();
        }
        return null;
    }

    public void setApplicationRequired(boolean required) {
    }

    public void setRequired(boolean required) {
    }

    protected void setImageLabel(JLabel label) {
        this._imageLabel = label;
    }

    protected JLabel getImageLabel() {
        if (this._imageLabel == null) {
            this._imageLabel = new JLabel();
            this._imageLabel.addMouseListener(this);
        }
        return this._imageLabel;
    }

    public void mouseClicked(MouseEvent e) {
        this.populateModel();
        this.showDialog();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected JButton getSelectFileButton() {
        if (this._selectFileButton == null) {
            this._selectFileButton = new JButton();
            this.setButtonLabel();
        }
        return this._selectFileButton;
    }
}

