/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.Type;
import com.jaxfront.swing.ui.visualizers.JAXFrontCellRenderer;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class KeyRefListCellRenderer
extends DefaultListCellRenderer
implements JAXFrontCellRenderer {
    private Type _keyRefType;
    private FormulaExpression _formulaExpression;
    private String _defaultPrefix = null;
    private String _defaultPostfix = null;
    private String _defaultValue;

    public KeyRefListCellRenderer(Type keyRefType) {
        this._keyRefType = keyRefType;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel defaultListCellRenderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            Type type = (Type)value;
            if (type.isEmpty()) {
                defaultListCellRenderer.setText(" ");
            } else {
                String typeValue = type.getDisplayValue();
                if (this._keyRefType != null && this.getFormulaExpression() != null) {
                    this.getFormulaExpression().setSource(type);
                    try {
                        typeValue = this.getFormulaExpression().evaluate(true);
                    }
                    catch (FormulaException ex) {
                        LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
                    }
                }
                if (typeValue != null && typeValue.equals("")) {
                    typeValue = " ";
                }
                defaultListCellRenderer.setText(typeValue);
            }
        }
        return defaultListCellRenderer;
    }

    private FormulaExpression getFormulaExpression() {
        if (this._formulaExpression == null && this._keyRefType.getXUIDefinition().getStyle().hasKeyRefSelectionLineInfoFE()) {
            this._formulaExpression = new FormulaExpression(null, this._keyRefType.getXUIDefinition().getStyle().getKeyRefSelectionLineInfoFE());
        }
        return this._formulaExpression;
    }

    public void setDefaultPostfix(String postfix) {
        this._defaultPostfix = postfix;
    }

    public void setDefaultPrefix(String prefix) {
        this._defaultPrefix = prefix;
    }

    public String getDefaultPostfix() {
        return this._defaultPostfix;
    }

    public String getDefaultPrefix() {
        return this._defaultPrefix;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }
}

